/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration settings for the application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationConfig.Builder, ApplicationConfig> {
    private static final SdkField<ContactHandling> CONTACT_HANDLING_FIELD = SdkField
            .<ContactHandling> builder(MarshallingType.SDK_POJO).memberName("ContactHandling")
            .getter(getter(ApplicationConfig::contactHandling)).setter(setter(Builder::contactHandling))
            .constructor(ContactHandling::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactHandling").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_HANDLING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ContactHandling contactHandling;

    private ApplicationConfig(BuilderImpl builder) {
        this.contactHandling = builder.contactHandling;
    }

    /**
     * <p>
     * The contact handling configuration for the application.
     * </p>
     * 
     * @return The contact handling configuration for the application.
     */
    public final ContactHandling contactHandling() {
        return contactHandling;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contactHandling());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationConfig)) {
            return false;
        }
        ApplicationConfig other = (ApplicationConfig) obj;
        return Objects.equals(contactHandling(), other.contactHandling());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationConfig").add("ContactHandling", contactHandling()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactHandling":
            return Optional.ofNullable(clazz.cast(contactHandling()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContactHandling", CONTACT_HANDLING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationConfig, T> g) {
        return obj -> g.apply((ApplicationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationConfig> {
        /**
         * <p>
         * The contact handling configuration for the application.
         * </p>
         * 
         * @param contactHandling
         *        The contact handling configuration for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactHandling(ContactHandling contactHandling);

        /**
         * <p>
         * The contact handling configuration for the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContactHandling.Builder} avoiding the
         * need to create one manually via {@link ContactHandling#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContactHandling.Builder#build()} is called immediately and its
         * result is passed to {@link #contactHandling(ContactHandling)}.
         * 
         * @param contactHandling
         *        a consumer that will call methods on {@link ContactHandling.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contactHandling(ContactHandling)
         */
        default Builder contactHandling(Consumer<ContactHandling.Builder> contactHandling) {
            return contactHandling(ContactHandling.builder().applyMutation(contactHandling).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ContactHandling contactHandling;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationConfig model) {
            contactHandling(model.contactHandling);
        }

        public final ContactHandling.Builder getContactHandling() {
            return contactHandling != null ? contactHandling.toBuilder() : null;
        }

        public final void setContactHandling(ContactHandling.BuilderImpl contactHandling) {
            this.contactHandling = contactHandling != null ? contactHandling.build() : null;
        }

        @Override
        public final Builder contactHandling(ContactHandling contactHandling) {
            this.contactHandling = contactHandling;
            return this;
        }

        @Override
        public ApplicationConfig build() {
            return new ApplicationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
