/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The contact handling configuration for the application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactHandling implements SdkPojo, Serializable, ToCopyableBuilder<ContactHandling.Builder, ContactHandling> {
    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Scope")
            .getter(getter(ContactHandling::scopeAsString)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String scope;

    private ContactHandling(BuilderImpl builder) {
        this.scope = builder.scope;
    }

    /**
     * <p>
     * Indicates whether the application refreshes for each contact or refreshes only with each new browser session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link ContactHandlingScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Indicates whether the application refreshes for each contact or refreshes only with each new browser
     *         session.
     * @see ContactHandlingScope
     */
    public final ContactHandlingScope scope() {
        return ContactHandlingScope.fromValue(scope);
    }

    /**
     * <p>
     * Indicates whether the application refreshes for each contact or refreshes only with each new browser session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link ContactHandlingScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Indicates whether the application refreshes for each contact or refreshes only with each new browser
     *         session.
     * @see ContactHandlingScope
     */
    public final String scopeAsString() {
        return scope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactHandling)) {
            return false;
        }
        ContactHandling other = (ContactHandling) obj;
        return Objects.equals(scopeAsString(), other.scopeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactHandling").add("Scope", scopeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Scope":
            return Optional.ofNullable(clazz.cast(scopeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Scope", SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactHandling, T> g) {
        return obj -> g.apply((ContactHandling) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactHandling> {
        /**
         * <p>
         * Indicates whether the application refreshes for each contact or refreshes only with each new browser session.
         * </p>
         * 
         * @param scope
         *        Indicates whether the application refreshes for each contact or refreshes only with each new browser
         *        session.
         * @see ContactHandlingScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactHandlingScope
         */
        Builder scope(String scope);

        /**
         * <p>
         * Indicates whether the application refreshes for each contact or refreshes only with each new browser session.
         * </p>
         * 
         * @param scope
         *        Indicates whether the application refreshes for each contact or refreshes only with each new browser
         *        session.
         * @see ContactHandlingScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactHandlingScope
         */
        Builder scope(ContactHandlingScope scope);
    }

    static final class BuilderImpl implements Builder {
        private String scope;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactHandling model) {
            scope(model.scope);
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(ContactHandlingScope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        @Override
        public ContactHandling build() {
            return new ContactHandling(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
