/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appintegrations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApplicationRequest extends AppIntegrationsRequest implements
        ToCopyableBuilder<CreateApplicationRequest.Builder, CreateApplicationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateApplicationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(CreateApplicationRequest::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateApplicationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ApplicationSourceConfig> APPLICATION_SOURCE_CONFIG_FIELD = SdkField
            .<ApplicationSourceConfig> builder(MarshallingType.SDK_POJO).memberName("ApplicationSourceConfig")
            .getter(getter(CreateApplicationRequest::applicationSourceConfig)).setter(setter(Builder::applicationSourceConfig))
            .constructor(ApplicationSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSourceConfig").build())
            .build();

    private static final SdkField<List<Subscription>> SUBSCRIPTIONS_FIELD = SdkField
            .<List<Subscription>> builder(MarshallingType.LIST)
            .memberName("Subscriptions")
            .getter(getter(CreateApplicationRequest::subscriptions))
            .setter(setter(Builder::subscriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Subscription> builder(MarshallingType.SDK_POJO)
                                            .constructor(Subscription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Publication>> PUBLICATIONS_FIELD = SdkField
            .<List<Publication>> builder(MarshallingType.LIST)
            .memberName("Publications")
            .getter(getter(CreateApplicationRequest::publications))
            .setter(setter(Builder::publications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Publications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Publication> builder(MarshallingType.SDK_POJO)
                                            .constructor(Publication::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateApplicationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateApplicationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Permissions")
            .getter(getter(CreateApplicationRequest::permissions))
            .setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_SERVICE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsService").getter(getter(CreateApplicationRequest::isService)).setter(setter(Builder::isService))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsService").build()).build();

    private static final SdkField<Integer> INITIALIZATION_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InitializationTimeout").getter(getter(CreateApplicationRequest::initializationTimeout))
            .setter(setter(Builder::initializationTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitializationTimeout").build())
            .build();

    private static final SdkField<ApplicationConfig> APPLICATION_CONFIG_FIELD = SdkField
            .<ApplicationConfig> builder(MarshallingType.SDK_POJO).memberName("ApplicationConfig")
            .getter(getter(CreateApplicationRequest::applicationConfig)).setter(setter(Builder::applicationConfig))
            .constructor(ApplicationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationConfig").build()).build();

    private static final SdkField<IframeConfig> IFRAME_CONFIG_FIELD = SdkField.<IframeConfig> builder(MarshallingType.SDK_POJO)
            .memberName("IframeConfig").getter(getter(CreateApplicationRequest::iframeConfig))
            .setter(setter(Builder::iframeConfig)).constructor(IframeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IframeConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, NAMESPACE_FIELD,
            DESCRIPTION_FIELD, APPLICATION_SOURCE_CONFIG_FIELD, SUBSCRIPTIONS_FIELD, PUBLICATIONS_FIELD, CLIENT_TOKEN_FIELD,
            TAGS_FIELD, PERMISSIONS_FIELD, IS_SERVICE_FIELD, INITIALIZATION_TIMEOUT_FIELD, APPLICATION_CONFIG_FIELD,
            IFRAME_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String namespace;

    private final String description;

    private final ApplicationSourceConfig applicationSourceConfig;

    private final List<Subscription> subscriptions;

    private final List<Publication> publications;

    private final String clientToken;

    private final Map<String, String> tags;

    private final List<String> permissions;

    private final Boolean isService;

    private final Integer initializationTimeout;

    private final ApplicationConfig applicationConfig;

    private final IframeConfig iframeConfig;

    private CreateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.namespace = builder.namespace;
        this.description = builder.description;
        this.applicationSourceConfig = builder.applicationSourceConfig;
        this.subscriptions = builder.subscriptions;
        this.publications = builder.publications;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
        this.permissions = builder.permissions;
        this.isService = builder.isService;
        this.initializationTimeout = builder.initializationTimeout;
        this.applicationConfig = builder.applicationConfig;
        this.iframeConfig = builder.iframeConfig;
    }

    /**
     * <p>
     * The name of the application.
     * </p>
     * 
     * @return The name of the application.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The namespace of the application.
     * </p>
     * 
     * @return The namespace of the application.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The description of the application.
     * </p>
     * 
     * @return The description of the application.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The configuration for where the application should be loaded from.
     * </p>
     * 
     * @return The configuration for where the application should be loaded from.
     */
    public final ApplicationSourceConfig applicationSourceConfig() {
        return applicationSourceConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subscriptions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     *
     * @deprecated Subscriptions has been replaced with Permissions
     */
    @Deprecated
    public final boolean hasSubscriptions() {
        return subscriptions != null && !(subscriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The events that the application subscribes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubscriptions} method.
     * </p>
     * 
     * @return The events that the application subscribes.
     * @deprecated Subscriptions has been replaced with Permissions
     */
    @Deprecated
    public final List<Subscription> subscriptions() {
        return subscriptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Publications property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     *
     * @deprecated Publications has been replaced with Permissions
     */
    @Deprecated
    public final boolean hasPublications() {
        return publications != null && !(publications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The events that the application publishes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPublications} method.
     * </p>
     * 
     * @return The events that the application publishes.
     * @deprecated Publications has been replaced with Permissions
     */
    @Deprecated
    public final List<Publication> publications() {
        return publications;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
     *         retries safe with idempotent APIs</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1",
     * "key2":"value2"} }.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource. For example, { "tags":
     *         {"key1":"value1", "key2":"value2"} }.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Permissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration of events or requests that the application has access to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return The configuration of events or requests that the application has access to.
     */
    public final List<String> permissions() {
        return permissions;
    }

    /**
     * <p>
     * Indicates whether the application is a service.
     * </p>
     * 
     * @return Indicates whether the application is a service.
     */
    public final Boolean isService() {
        return isService;
    }

    /**
     * <p>
     * The maximum time in milliseconds allowed to establish a connection with the workspace.
     * </p>
     * 
     * @return The maximum time in milliseconds allowed to establish a connection with the workspace.
     */
    public final Integer initializationTimeout() {
        return initializationTimeout;
    }

    /**
     * <p>
     * The configuration settings for the application.
     * </p>
     * 
     * @return The configuration settings for the application.
     */
    public final ApplicationConfig applicationConfig() {
        return applicationConfig;
    }

    /**
     * <p>
     * The iframe configuration for the application.
     * </p>
     * 
     * @return The iframe configuration for the application.
     */
    public final IframeConfig iframeConfig() {
        return iframeConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(applicationSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubscriptions() ? subscriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPublications() ? publications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isService());
        hashCode = 31 * hashCode + Objects.hashCode(initializationTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(applicationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(iframeConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(namespace(), other.namespace())
                && Objects.equals(description(), other.description())
                && Objects.equals(applicationSourceConfig(), other.applicationSourceConfig())
                && hasSubscriptions() == other.hasSubscriptions() && Objects.equals(subscriptions(), other.subscriptions())
                && hasPublications() == other.hasPublications() && Objects.equals(publications(), other.publications())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasPermissions() == other.hasPermissions()
                && Objects.equals(permissions(), other.permissions()) && Objects.equals(isService(), other.isService())
                && Objects.equals(initializationTimeout(), other.initializationTimeout())
                && Objects.equals(applicationConfig(), other.applicationConfig())
                && Objects.equals(iframeConfig(), other.iframeConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateApplicationRequest").add("Name", name()).add("Namespace", namespace())
                .add("Description", description()).add("ApplicationSourceConfig", applicationSourceConfig())
                .add("Subscriptions", hasSubscriptions() ? subscriptions() : null)
                .add("Publications", hasPublications() ? publications() : null).add("ClientToken", clientToken())
                .add("Tags", hasTags() ? tags() : null).add("Permissions", hasPermissions() ? permissions() : null)
                .add("IsService", isService()).add("InitializationTimeout", initializationTimeout())
                .add("ApplicationConfig", applicationConfig()).add("IframeConfig", iframeConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ApplicationSourceConfig":
            return Optional.ofNullable(clazz.cast(applicationSourceConfig()));
        case "Subscriptions":
            return Optional.ofNullable(clazz.cast(subscriptions()));
        case "Publications":
            return Optional.ofNullable(clazz.cast(publications()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        case "IsService":
            return Optional.ofNullable(clazz.cast(isService()));
        case "InitializationTimeout":
            return Optional.ofNullable(clazz.cast(initializationTimeout()));
        case "ApplicationConfig":
            return Optional.ofNullable(clazz.cast(applicationConfig()));
        case "IframeConfig":
            return Optional.ofNullable(clazz.cast(iframeConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Namespace", NAMESPACE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ApplicationSourceConfig", APPLICATION_SOURCE_CONFIG_FIELD);
        map.put("Subscriptions", SUBSCRIPTIONS_FIELD);
        map.put("Publications", PUBLICATIONS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Permissions", PERMISSIONS_FIELD);
        map.put("IsService", IS_SERVICE_FIELD);
        map.put("InitializationTimeout", INITIALIZATION_TIMEOUT_FIELD);
        map.put("ApplicationConfig", APPLICATION_CONFIG_FIELD);
        map.put("IframeConfig", IFRAME_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationRequest, T> g) {
        return obj -> g.apply((CreateApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppIntegrationsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateApplicationRequest> {
        /**
         * <p>
         * The name of the application.
         * </p>
         * 
         * @param name
         *        The name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The namespace of the application.
         * </p>
         * 
         * @param namespace
         *        The namespace of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The description of the application.
         * </p>
         * 
         * @param description
         *        The description of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The configuration for where the application should be loaded from.
         * </p>
         * 
         * @param applicationSourceConfig
         *        The configuration for where the application should be loaded from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSourceConfig(ApplicationSourceConfig applicationSourceConfig);

        /**
         * <p>
         * The configuration for where the application should be loaded from.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApplicationSourceConfig.Builder} avoiding
         * the need to create one manually via {@link ApplicationSourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationSourceConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #applicationSourceConfig(ApplicationSourceConfig)}.
         * 
         * @param applicationSourceConfig
         *        a consumer that will call methods on {@link ApplicationSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationSourceConfig(ApplicationSourceConfig)
         */
        default Builder applicationSourceConfig(Consumer<ApplicationSourceConfig.Builder> applicationSourceConfig) {
            return applicationSourceConfig(ApplicationSourceConfig.builder().applyMutation(applicationSourceConfig).build());
        }

        /**
         * <p>
         * The events that the application subscribes.
         * </p>
         * 
         * @param subscriptions
         *        The events that the application subscribes.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Subscriptions has been replaced with Permissions
         */
        @Deprecated
        Builder subscriptions(Collection<Subscription> subscriptions);

        /**
         * <p>
         * The events that the application subscribes.
         * </p>
         * 
         * @param subscriptions
         *        The events that the application subscribes.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Subscriptions has been replaced with Permissions
         */
        @Deprecated
        Builder subscriptions(Subscription... subscriptions);

        /**
         * <p>
         * The events that the application subscribes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appintegrations.model.Subscription.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.appintegrations.model.Subscription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appintegrations.model.Subscription.Builder#build()} is called
         * immediately and its result is passed to {@link #subscriptions(List<Subscription>)}.
         * 
         * @param subscriptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appintegrations.model.Subscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscriptions(java.util.Collection<Subscription>)
         * @deprecated Subscriptions has been replaced with Permissions
         */
        @Deprecated
        Builder subscriptions(Consumer<Subscription.Builder>... subscriptions);

        /**
         * <p>
         * The events that the application publishes.
         * </p>
         * 
         * @param publications
         *        The events that the application publishes.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Publications has been replaced with Permissions
         */
        @Deprecated
        Builder publications(Collection<Publication> publications);

        /**
         * <p>
         * The events that the application publishes.
         * </p>
         * 
         * @param publications
         *        The events that the application publishes.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Publications has been replaced with Permissions
         */
        @Deprecated
        Builder publications(Publication... publications);

        /**
         * <p>
         * The events that the application publishes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appintegrations.model.Publication.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.appintegrations.model.Publication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appintegrations.model.Publication.Builder#build()} is called
         * immediately and its result is passed to {@link #publications(List<Publication>)}.
         * 
         * @param publications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appintegrations.model.Publication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publications(java.util.Collection<Publication>)
         * @deprecated Publications has been replaced with Permissions
         */
        @Deprecated
        Builder publications(Consumer<Publication.Builder>... publications);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource. For example, { "tags":
         * {"key1":"value1", "key2":"value2"} }.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource. For example, { "tags":
         *        {"key1":"value1", "key2":"value2"} }.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The configuration of events or requests that the application has access to.
         * </p>
         * 
         * @param permissions
         *        The configuration of events or requests that the application has access to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<String> permissions);

        /**
         * <p>
         * The configuration of events or requests that the application has access to.
         * </p>
         * 
         * @param permissions
         *        The configuration of events or requests that the application has access to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(String... permissions);

        /**
         * <p>
         * Indicates whether the application is a service.
         * </p>
         * 
         * @param isService
         *        Indicates whether the application is a service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isService(Boolean isService);

        /**
         * <p>
         * The maximum time in milliseconds allowed to establish a connection with the workspace.
         * </p>
         * 
         * @param initializationTimeout
         *        The maximum time in milliseconds allowed to establish a connection with the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initializationTimeout(Integer initializationTimeout);

        /**
         * <p>
         * The configuration settings for the application.
         * </p>
         * 
         * @param applicationConfig
         *        The configuration settings for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationConfig(ApplicationConfig applicationConfig);

        /**
         * <p>
         * The configuration settings for the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApplicationConfig.Builder} avoiding the
         * need to create one manually via {@link ApplicationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #applicationConfig(ApplicationConfig)}.
         * 
         * @param applicationConfig
         *        a consumer that will call methods on {@link ApplicationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationConfig(ApplicationConfig)
         */
        default Builder applicationConfig(Consumer<ApplicationConfig.Builder> applicationConfig) {
            return applicationConfig(ApplicationConfig.builder().applyMutation(applicationConfig).build());
        }

        /**
         * <p>
         * The iframe configuration for the application.
         * </p>
         * 
         * @param iframeConfig
         *        The iframe configuration for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iframeConfig(IframeConfig iframeConfig);

        /**
         * <p>
         * The iframe configuration for the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link IframeConfig.Builder} avoiding the need
         * to create one manually via {@link IframeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IframeConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #iframeConfig(IframeConfig)}.
         * 
         * @param iframeConfig
         *        a consumer that will call methods on {@link IframeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iframeConfig(IframeConfig)
         */
        default Builder iframeConfig(Consumer<IframeConfig.Builder> iframeConfig) {
            return iframeConfig(IframeConfig.builder().applyMutation(iframeConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppIntegrationsRequest.BuilderImpl implements Builder {
        private String name;

        private String namespace;

        private String description;

        private ApplicationSourceConfig applicationSourceConfig;

        private List<Subscription> subscriptions = DefaultSdkAutoConstructList.getInstance();

        private List<Publication> publications = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();

        private Boolean isService;

        private Integer initializationTimeout;

        private ApplicationConfig applicationConfig;

        private IframeConfig iframeConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            super(model);
            name(model.name);
            namespace(model.namespace);
            description(model.description);
            applicationSourceConfig(model.applicationSourceConfig);
            subscriptions(model.subscriptions);
            publications(model.publications);
            clientToken(model.clientToken);
            tags(model.tags);
            permissions(model.permissions);
            isService(model.isService);
            initializationTimeout(model.initializationTimeout);
            applicationConfig(model.applicationConfig);
            iframeConfig(model.iframeConfig);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ApplicationSourceConfig.Builder getApplicationSourceConfig() {
            return applicationSourceConfig != null ? applicationSourceConfig.toBuilder() : null;
        }

        public final void setApplicationSourceConfig(ApplicationSourceConfig.BuilderImpl applicationSourceConfig) {
            this.applicationSourceConfig = applicationSourceConfig != null ? applicationSourceConfig.build() : null;
        }

        @Override
        public final Builder applicationSourceConfig(ApplicationSourceConfig applicationSourceConfig) {
            this.applicationSourceConfig = applicationSourceConfig;
            return this;
        }

        @Deprecated
        public final List<Subscription.Builder> getSubscriptions() {
            List<Subscription.Builder> result = SubscriptionListCopier.copyToBuilder(this.subscriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Deprecated
        public final void setSubscriptions(Collection<Subscription.BuilderImpl> subscriptions) {
            this.subscriptions = SubscriptionListCopier.copyFromBuilder(subscriptions);
        }

        @Override
        @Deprecated
        public final Builder subscriptions(Collection<Subscription> subscriptions) {
            this.subscriptions = SubscriptionListCopier.copy(subscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder subscriptions(Subscription... subscriptions) {
            subscriptions(Arrays.asList(subscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder subscriptions(Consumer<Subscription.Builder>... subscriptions) {
            subscriptions(Stream.of(subscriptions).map(c -> Subscription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Deprecated
        public final List<Publication.Builder> getPublications() {
            List<Publication.Builder> result = PublicationListCopier.copyToBuilder(this.publications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Deprecated
        public final void setPublications(Collection<Publication.BuilderImpl> publications) {
            this.publications = PublicationListCopier.copyFromBuilder(publications);
        }

        @Override
        @Deprecated
        public final Builder publications(Collection<Publication> publications) {
            this.publications = PublicationListCopier.copy(publications);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder publications(Publication... publications) {
            publications(Arrays.asList(publications));
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder publications(Consumer<Publication.Builder>... publications) {
            publications(Stream.of(publications).map(c -> Publication.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Collection<String> getPermissions() {
            if (permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return permissions;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
        }

        @Override
        public final Builder permissions(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(String... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        public final Boolean getIsService() {
            return isService;
        }

        public final void setIsService(Boolean isService) {
            this.isService = isService;
        }

        @Override
        public final Builder isService(Boolean isService) {
            this.isService = isService;
            return this;
        }

        public final Integer getInitializationTimeout() {
            return initializationTimeout;
        }

        public final void setInitializationTimeout(Integer initializationTimeout) {
            this.initializationTimeout = initializationTimeout;
        }

        @Override
        public final Builder initializationTimeout(Integer initializationTimeout) {
            this.initializationTimeout = initializationTimeout;
            return this;
        }

        public final ApplicationConfig.Builder getApplicationConfig() {
            return applicationConfig != null ? applicationConfig.toBuilder() : null;
        }

        public final void setApplicationConfig(ApplicationConfig.BuilderImpl applicationConfig) {
            this.applicationConfig = applicationConfig != null ? applicationConfig.build() : null;
        }

        @Override
        public final Builder applicationConfig(ApplicationConfig applicationConfig) {
            this.applicationConfig = applicationConfig;
            return this;
        }

        public final IframeConfig.Builder getIframeConfig() {
            return iframeConfig != null ? iframeConfig.toBuilder() : null;
        }

        public final void setIframeConfig(IframeConfig.BuilderImpl iframeConfig) {
            this.iframeConfig = iframeConfig != null ? iframeConfig.build() : null;
        }

        @Override
        public final Builder iframeConfig(IframeConfig iframeConfig) {
            this.iframeConfig = iframeConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
