/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appintegrations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataIntegrationAssociationRequest extends AppIntegrationsRequest implements
        ToCopyableBuilder<CreateDataIntegrationAssociationRequest.Builder, CreateDataIntegrationAssociationRequest> {
    private static final SdkField<String> DATA_INTEGRATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataIntegrationIdentifier")
            .getter(getter(CreateDataIntegrationAssociationRequest::dataIntegrationIdentifier))
            .setter(setter(Builder::dataIntegrationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientId").getter(getter(CreateDataIntegrationAssociationRequest::clientId))
            .setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final SdkField<Map<String, Map<String, List<String>>>> OBJECT_CONFIGURATION_FIELD = SdkField
            .<Map<String, Map<String, List<String>>>> builder(MarshallingType.MAP)
            .memberName("ObjectConfiguration")
            .getter(getter(CreateDataIntegrationAssociationRequest::objectConfiguration))
            .setter(setter(Builder::objectConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectConfiguration").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Map<String, List<String>>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build(),
                                                                                    ListTrait
                                                                                            .builder()
                                                                                            .memberLocationName(null)
                                                                                            .memberFieldInfo(
                                                                                                    SdkField.<String> builder(
                                                                                                            MarshallingType.STRING)
                                                                                                            .traits(LocationTrait
                                                                                                                    .builder()
                                                                                                                    .location(
                                                                                                                            MarshallLocation.PAYLOAD)
                                                                                                                    .locationName(
                                                                                                                            "member")
                                                                                                                    .build())
                                                                                                            .build()).build())
                                                                            .build()).build()).build()).build()).build();

    private static final SdkField<String> DESTINATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationURI").getter(getter(CreateDataIntegrationAssociationRequest::destinationURI))
            .setter(setter(Builder::destinationURI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationURI").build()).build();

    private static final SdkField<Map<String, String>> CLIENT_ASSOCIATION_METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("ClientAssociationMetadata")
            .getter(getter(CreateDataIntegrationAssociationRequest::clientAssociationMetadata))
            .setter(setter(Builder::clientAssociationMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientAssociationMetadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateDataIntegrationAssociationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<ExecutionConfiguration> EXECUTION_CONFIGURATION_FIELD = SdkField
            .<ExecutionConfiguration> builder(MarshallingType.SDK_POJO).memberName("ExecutionConfiguration")
            .getter(getter(CreateDataIntegrationAssociationRequest::executionConfiguration))
            .setter(setter(Builder::executionConfiguration)).constructor(ExecutionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATA_INTEGRATION_IDENTIFIER_FIELD, CLIENT_ID_FIELD, OBJECT_CONFIGURATION_FIELD, DESTINATION_URI_FIELD,
            CLIENT_ASSOCIATION_METADATA_FIELD, CLIENT_TOKEN_FIELD, EXECUTION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dataIntegrationIdentifier;

    private final String clientId;

    private final Map<String, Map<String, List<String>>> objectConfiguration;

    private final String destinationURI;

    private final Map<String, String> clientAssociationMetadata;

    private final String clientToken;

    private final ExecutionConfiguration executionConfiguration;

    private CreateDataIntegrationAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.dataIntegrationIdentifier = builder.dataIntegrationIdentifier;
        this.clientId = builder.clientId;
        this.objectConfiguration = builder.objectConfiguration;
        this.destinationURI = builder.destinationURI;
        this.clientAssociationMetadata = builder.clientAssociationMetadata;
        this.clientToken = builder.clientToken;
        this.executionConfiguration = builder.executionConfiguration;
    }

    /**
     * <p>
     * A unique identifier for the DataIntegration.
     * </p>
     * 
     * @return A unique identifier for the DataIntegration.
     */
    public final String dataIntegrationIdentifier() {
        return dataIntegrationIdentifier;
    }

    /**
     * <p>
     * The identifier for the client that is associated with the DataIntegration association.
     * </p>
     * 
     * @return The identifier for the client that is associated with the DataIntegration association.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ObjectConfiguration property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasObjectConfiguration() {
        return objectConfiguration != null && !(objectConfiguration instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the ObjectConfiguration property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasObjectConfiguration} method.
     * </p>
     * 
     * @return The value of the ObjectConfiguration property for this object.
     */
    public final Map<String, Map<String, List<String>>> objectConfiguration() {
        return objectConfiguration;
    }

    /**
     * <p>
     * The URI of the data destination.
     * </p>
     * 
     * @return The URI of the data destination.
     */
    public final String destinationURI() {
        return destinationURI;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClientAssociationMetadata property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasClientAssociationMetadata() {
        return clientAssociationMetadata != null && !(clientAssociationMetadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The mapping of metadata to be extracted from the data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClientAssociationMetadata} method.
     * </p>
     * 
     * @return The mapping of metadata to be extracted from the data.
     */
    public final Map<String, String> clientAssociationMetadata() {
        return clientAssociationMetadata;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
     *         retries safe with idempotent APIs</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The configuration for how the files should be pulled from the source.
     * </p>
     * 
     * @return The configuration for how the files should be pulled from the source.
     */
    public final ExecutionConfiguration executionConfiguration() {
        return executionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataIntegrationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(hasObjectConfiguration() ? objectConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(destinationURI());
        hashCode = 31 * hashCode + Objects.hashCode(hasClientAssociationMetadata() ? clientAssociationMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(executionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataIntegrationAssociationRequest)) {
            return false;
        }
        CreateDataIntegrationAssociationRequest other = (CreateDataIntegrationAssociationRequest) obj;
        return Objects.equals(dataIntegrationIdentifier(), other.dataIntegrationIdentifier())
                && Objects.equals(clientId(), other.clientId()) && hasObjectConfiguration() == other.hasObjectConfiguration()
                && Objects.equals(objectConfiguration(), other.objectConfiguration())
                && Objects.equals(destinationURI(), other.destinationURI())
                && hasClientAssociationMetadata() == other.hasClientAssociationMetadata()
                && Objects.equals(clientAssociationMetadata(), other.clientAssociationMetadata())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(executionConfiguration(), other.executionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataIntegrationAssociationRequest")
                .add("DataIntegrationIdentifier", dataIntegrationIdentifier()).add("ClientId", clientId())
                .add("ObjectConfiguration", hasObjectConfiguration() ? objectConfiguration() : null)
                .add("DestinationURI", destinationURI())
                .add("ClientAssociationMetadata", hasClientAssociationMetadata() ? clientAssociationMetadata() : null)
                .add("ClientToken", clientToken()).add("ExecutionConfiguration", executionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataIntegrationIdentifier":
            return Optional.ofNullable(clazz.cast(dataIntegrationIdentifier()));
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "ObjectConfiguration":
            return Optional.ofNullable(clazz.cast(objectConfiguration()));
        case "DestinationURI":
            return Optional.ofNullable(clazz.cast(destinationURI()));
        case "ClientAssociationMetadata":
            return Optional.ofNullable(clazz.cast(clientAssociationMetadata()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "ExecutionConfiguration":
            return Optional.ofNullable(clazz.cast(executionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Identifier", DATA_INTEGRATION_IDENTIFIER_FIELD);
        map.put("ClientId", CLIENT_ID_FIELD);
        map.put("ObjectConfiguration", OBJECT_CONFIGURATION_FIELD);
        map.put("DestinationURI", DESTINATION_URI_FIELD);
        map.put("ClientAssociationMetadata", CLIENT_ASSOCIATION_METADATA_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("ExecutionConfiguration", EXECUTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataIntegrationAssociationRequest, T> g) {
        return obj -> g.apply((CreateDataIntegrationAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppIntegrationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDataIntegrationAssociationRequest> {
        /**
         * <p>
         * A unique identifier for the DataIntegration.
         * </p>
         * 
         * @param dataIntegrationIdentifier
         *        A unique identifier for the DataIntegration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataIntegrationIdentifier(String dataIntegrationIdentifier);

        /**
         * <p>
         * The identifier for the client that is associated with the DataIntegration association.
         * </p>
         * 
         * @param clientId
         *        The identifier for the client that is associated with the DataIntegration association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * Sets the value of the ObjectConfiguration property for this object.
         *
         * @param objectConfiguration
         *        The new value for the ObjectConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectConfiguration(Map<String, ? extends Map<String, ? extends Collection<String>>> objectConfiguration);

        /**
         * <p>
         * The URI of the data destination.
         * </p>
         * 
         * @param destinationURI
         *        The URI of the data destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationURI(String destinationURI);

        /**
         * <p>
         * The mapping of metadata to be extracted from the data.
         * </p>
         * 
         * @param clientAssociationMetadata
         *        The mapping of metadata to be extracted from the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientAssociationMetadata(Map<String, String> clientAssociationMetadata);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The configuration for how the files should be pulled from the source.
         * </p>
         * 
         * @param executionConfiguration
         *        The configuration for how the files should be pulled from the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionConfiguration(ExecutionConfiguration executionConfiguration);

        /**
         * <p>
         * The configuration for how the files should be pulled from the source.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutionConfiguration.Builder} avoiding
         * the need to create one manually via {@link ExecutionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutionConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #executionConfiguration(ExecutionConfiguration)}.
         * 
         * @param executionConfiguration
         *        a consumer that will call methods on {@link ExecutionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionConfiguration(ExecutionConfiguration)
         */
        default Builder executionConfiguration(Consumer<ExecutionConfiguration.Builder> executionConfiguration) {
            return executionConfiguration(ExecutionConfiguration.builder().applyMutation(executionConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppIntegrationsRequest.BuilderImpl implements Builder {
        private String dataIntegrationIdentifier;

        private String clientId;

        private Map<String, Map<String, List<String>>> objectConfiguration = DefaultSdkAutoConstructMap.getInstance();

        private String destinationURI;

        private Map<String, String> clientAssociationMetadata = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private ExecutionConfiguration executionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataIntegrationAssociationRequest model) {
            super(model);
            dataIntegrationIdentifier(model.dataIntegrationIdentifier);
            clientId(model.clientId);
            objectConfiguration(model.objectConfiguration);
            destinationURI(model.destinationURI);
            clientAssociationMetadata(model.clientAssociationMetadata);
            clientToken(model.clientToken);
            executionConfiguration(model.executionConfiguration);
        }

        public final String getDataIntegrationIdentifier() {
            return dataIntegrationIdentifier;
        }

        public final void setDataIntegrationIdentifier(String dataIntegrationIdentifier) {
            this.dataIntegrationIdentifier = dataIntegrationIdentifier;
        }

        @Override
        public final Builder dataIntegrationIdentifier(String dataIntegrationIdentifier) {
            this.dataIntegrationIdentifier = dataIntegrationIdentifier;
            return this;
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final Map<String, ? extends Map<String, ? extends Collection<String>>> getObjectConfiguration() {
            if (objectConfiguration instanceof SdkAutoConstructMap) {
                return null;
            }
            return objectConfiguration;
        }

        public final void setObjectConfiguration(
                Map<String, ? extends Map<String, ? extends Collection<String>>> objectConfiguration) {
            this.objectConfiguration = ObjectConfigurationCopier.copy(objectConfiguration);
        }

        @Override
        public final Builder objectConfiguration(
                Map<String, ? extends Map<String, ? extends Collection<String>>> objectConfiguration) {
            this.objectConfiguration = ObjectConfigurationCopier.copy(objectConfiguration);
            return this;
        }

        public final String getDestinationURI() {
            return destinationURI;
        }

        public final void setDestinationURI(String destinationURI) {
            this.destinationURI = destinationURI;
        }

        @Override
        public final Builder destinationURI(String destinationURI) {
            this.destinationURI = destinationURI;
            return this;
        }

        public final Map<String, String> getClientAssociationMetadata() {
            if (clientAssociationMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return clientAssociationMetadata;
        }

        public final void setClientAssociationMetadata(Map<String, String> clientAssociationMetadata) {
            this.clientAssociationMetadata = ClientAssociationMetadataCopier.copy(clientAssociationMetadata);
        }

        @Override
        public final Builder clientAssociationMetadata(Map<String, String> clientAssociationMetadata) {
            this.clientAssociationMetadata = ClientAssociationMetadataCopier.copy(clientAssociationMetadata);
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final ExecutionConfiguration.Builder getExecutionConfiguration() {
            return executionConfiguration != null ? executionConfiguration.toBuilder() : null;
        }

        public final void setExecutionConfiguration(ExecutionConfiguration.BuilderImpl executionConfiguration) {
            this.executionConfiguration = executionConfiguration != null ? executionConfiguration.build() : null;
        }

        @Override
        public final Builder executionConfiguration(ExecutionConfiguration executionConfiguration) {
            this.executionConfiguration = executionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataIntegrationAssociationRequest build() {
            return new CreateDataIntegrationAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
