/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataIntegrationAssociationResponse extends AppIntegrationsResponse implements
        ToCopyableBuilder<CreateDataIntegrationAssociationResponse.Builder, CreateDataIntegrationAssociationResponse> {
    private static final SdkField<String> DATA_INTEGRATION_ASSOCIATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DataIntegrationAssociationId")
            .getter(getter(CreateDataIntegrationAssociationResponse::dataIntegrationAssociationId))
            .setter(setter(Builder::dataIntegrationAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataIntegrationAssociationId")
                    .build()).build();

    private static final SdkField<String> DATA_INTEGRATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataIntegrationArn").getter(getter(CreateDataIntegrationAssociationResponse::dataIntegrationArn))
            .setter(setter(Builder::dataIntegrationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataIntegrationArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATA_INTEGRATION_ASSOCIATION_ID_FIELD, DATA_INTEGRATION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dataIntegrationAssociationId;

    private final String dataIntegrationArn;

    private CreateDataIntegrationAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.dataIntegrationAssociationId = builder.dataIntegrationAssociationId;
        this.dataIntegrationArn = builder.dataIntegrationArn;
    }

    /**
     * <p>
     * A unique identifier. for the DataIntegrationAssociation.
     * </p>
     * 
     * @return A unique identifier. for the DataIntegrationAssociation.
     */
    public final String dataIntegrationAssociationId() {
        return dataIntegrationAssociationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the DataIntegration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the DataIntegration.
     */
    public final String dataIntegrationArn() {
        return dataIntegrationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataIntegrationAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(dataIntegrationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataIntegrationAssociationResponse)) {
            return false;
        }
        CreateDataIntegrationAssociationResponse other = (CreateDataIntegrationAssociationResponse) obj;
        return Objects.equals(dataIntegrationAssociationId(), other.dataIntegrationAssociationId())
                && Objects.equals(dataIntegrationArn(), other.dataIntegrationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataIntegrationAssociationResponse")
                .add("DataIntegrationAssociationId", dataIntegrationAssociationId())
                .add("DataIntegrationArn", dataIntegrationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataIntegrationAssociationId":
            return Optional.ofNullable(clazz.cast(dataIntegrationAssociationId()));
        case "DataIntegrationArn":
            return Optional.ofNullable(clazz.cast(dataIntegrationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataIntegrationAssociationId", DATA_INTEGRATION_ASSOCIATION_ID_FIELD);
        map.put("DataIntegrationArn", DATA_INTEGRATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataIntegrationAssociationResponse, T> g) {
        return obj -> g.apply((CreateDataIntegrationAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppIntegrationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDataIntegrationAssociationResponse> {
        /**
         * <p>
         * A unique identifier. for the DataIntegrationAssociation.
         * </p>
         * 
         * @param dataIntegrationAssociationId
         *        A unique identifier. for the DataIntegrationAssociation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataIntegrationAssociationId(String dataIntegrationAssociationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the DataIntegration.
         * </p>
         * 
         * @param dataIntegrationArn
         *        The Amazon Resource Name (ARN) for the DataIntegration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataIntegrationArn(String dataIntegrationArn);
    }

    static final class BuilderImpl extends AppIntegrationsResponse.BuilderImpl implements Builder {
        private String dataIntegrationAssociationId;

        private String dataIntegrationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataIntegrationAssociationResponse model) {
            super(model);
            dataIntegrationAssociationId(model.dataIntegrationAssociationId);
            dataIntegrationArn(model.dataIntegrationArn);
        }

        public final String getDataIntegrationAssociationId() {
            return dataIntegrationAssociationId;
        }

        public final void setDataIntegrationAssociationId(String dataIntegrationAssociationId) {
            this.dataIntegrationAssociationId = dataIntegrationAssociationId;
        }

        @Override
        public final Builder dataIntegrationAssociationId(String dataIntegrationAssociationId) {
            this.dataIntegrationAssociationId = dataIntegrationAssociationId;
            return this;
        }

        public final String getDataIntegrationArn() {
            return dataIntegrationArn;
        }

        public final void setDataIntegrationArn(String dataIntegrationArn) {
            this.dataIntegrationArn = dataIntegrationArn;
        }

        @Override
        public final Builder dataIntegrationArn(String dataIntegrationArn) {
            this.dataIntegrationArn = dataIntegrationArn;
            return this;
        }

        @Override
        public CreateDataIntegrationAssociationResponse build() {
            return new CreateDataIntegrationAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
