/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The event integration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventIntegration implements SdkPojo, Serializable,
        ToCopyableBuilder<EventIntegration.Builder, EventIntegration> {
    private static final SdkField<String> EVENT_INTEGRATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventIntegrationArn").getter(getter(EventIntegration::eventIntegrationArn))
            .setter(setter(Builder::eventIntegrationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventIntegrationArn").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(EventIntegration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(EventIntegration::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<EventFilter> EVENT_FILTER_FIELD = SdkField.<EventFilter> builder(MarshallingType.SDK_POJO)
            .memberName("EventFilter").getter(getter(EventIntegration::eventFilter)).setter(setter(Builder::eventFilter))
            .constructor(EventFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventFilter").build()).build();

    private static final SdkField<String> EVENT_BRIDGE_BUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventBridgeBus").getter(getter(EventIntegration::eventBridgeBus))
            .setter(setter(Builder::eventBridgeBus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBridgeBus").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(EventIntegration::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_INTEGRATION_ARN_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, EVENT_FILTER_FIELD, EVENT_BRIDGE_BUS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String eventIntegrationArn;

    private final String name;

    private final String description;

    private final EventFilter eventFilter;

    private final String eventBridgeBus;

    private final Map<String, String> tags;

    private EventIntegration(BuilderImpl builder) {
        this.eventIntegrationArn = builder.eventIntegrationArn;
        this.name = builder.name;
        this.description = builder.description;
        this.eventFilter = builder.eventFilter;
        this.eventBridgeBus = builder.eventBridgeBus;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the event integration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the event integration.
     */
    public final String eventIntegrationArn() {
        return eventIntegrationArn;
    }

    /**
     * <p>
     * The name of the event integration.
     * </p>
     * 
     * @return The name of the event integration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The event integration description.
     * </p>
     * 
     * @return The event integration description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The event integration filter.
     * </p>
     * 
     * @return The event integration filter.
     */
    public final EventFilter eventFilter() {
        return eventFilter;
    }

    /**
     * <p>
     * The Amazon EventBridge bus for the event integration.
     * </p>
     * 
     * @return The Amazon EventBridge bus for the event integration.
     */
    public final String eventBridgeBus() {
        return eventBridgeBus;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1",
     * "key2":"value2"} }.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource. For example, { "tags":
     *         {"key1":"value1", "key2":"value2"} }.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventIntegrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(eventFilter());
        hashCode = 31 * hashCode + Objects.hashCode(eventBridgeBus());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventIntegration)) {
            return false;
        }
        EventIntegration other = (EventIntegration) obj;
        return Objects.equals(eventIntegrationArn(), other.eventIntegrationArn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(eventFilter(), other.eventFilter())
                && Objects.equals(eventBridgeBus(), other.eventBridgeBus()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventIntegration").add("EventIntegrationArn", eventIntegrationArn()).add("Name", name())
                .add("Description", description()).add("EventFilter", eventFilter()).add("EventBridgeBus", eventBridgeBus())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventIntegrationArn":
            return Optional.ofNullable(clazz.cast(eventIntegrationArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EventFilter":
            return Optional.ofNullable(clazz.cast(eventFilter()));
        case "EventBridgeBus":
            return Optional.ofNullable(clazz.cast(eventBridgeBus()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventIntegrationArn", EVENT_INTEGRATION_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("EventFilter", EVENT_FILTER_FIELD);
        map.put("EventBridgeBus", EVENT_BRIDGE_BUS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventIntegration, T> g) {
        return obj -> g.apply((EventIntegration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventIntegration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the event integration.
         * </p>
         * 
         * @param eventIntegrationArn
         *        The Amazon Resource Name (ARN) of the event integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventIntegrationArn(String eventIntegrationArn);

        /**
         * <p>
         * The name of the event integration.
         * </p>
         * 
         * @param name
         *        The name of the event integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The event integration description.
         * </p>
         * 
         * @param description
         *        The event integration description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The event integration filter.
         * </p>
         * 
         * @param eventFilter
         *        The event integration filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventFilter(EventFilter eventFilter);

        /**
         * <p>
         * The event integration filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventFilter.Builder} avoiding the need to
         * create one manually via {@link EventFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #eventFilter(EventFilter)}.
         * 
         * @param eventFilter
         *        a consumer that will call methods on {@link EventFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventFilter(EventFilter)
         */
        default Builder eventFilter(Consumer<EventFilter.Builder> eventFilter) {
            return eventFilter(EventFilter.builder().applyMutation(eventFilter).build());
        }

        /**
         * <p>
         * The Amazon EventBridge bus for the event integration.
         * </p>
         * 
         * @param eventBridgeBus
         *        The Amazon EventBridge bus for the event integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBridgeBus(String eventBridgeBus);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource. For example, { "tags":
         * {"key1":"value1", "key2":"value2"} }.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource. For example, { "tags":
         *        {"key1":"value1", "key2":"value2"} }.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String eventIntegrationArn;

        private String name;

        private String description;

        private EventFilter eventFilter;

        private String eventBridgeBus;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventIntegration model) {
            eventIntegrationArn(model.eventIntegrationArn);
            name(model.name);
            description(model.description);
            eventFilter(model.eventFilter);
            eventBridgeBus(model.eventBridgeBus);
            tags(model.tags);
        }

        public final String getEventIntegrationArn() {
            return eventIntegrationArn;
        }

        public final void setEventIntegrationArn(String eventIntegrationArn) {
            this.eventIntegrationArn = eventIntegrationArn;
        }

        @Override
        public final Builder eventIntegrationArn(String eventIntegrationArn) {
            this.eventIntegrationArn = eventIntegrationArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final EventFilter.Builder getEventFilter() {
            return eventFilter != null ? eventFilter.toBuilder() : null;
        }

        public final void setEventFilter(EventFilter.BuilderImpl eventFilter) {
            this.eventFilter = eventFilter != null ? eventFilter.build() : null;
        }

        @Override
        public final Builder eventFilter(EventFilter eventFilter) {
            this.eventFilter = eventFilter;
            return this;
        }

        public final String getEventBridgeBus() {
            return eventBridgeBus;
        }

        public final void setEventBridgeBus(String eventBridgeBus) {
            this.eventBridgeBus = eventBridgeBus;
        }

        @Override
        public final Builder eventBridgeBus(String eventBridgeBus) {
            this.eventBridgeBus = eventBridgeBus;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public EventIntegration build() {
            return new EventIntegration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
