/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The external URL source for the application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExternalUrlConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ExternalUrlConfig.Builder, ExternalUrlConfig> {
    private static final SdkField<String> ACCESS_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessUrl").getter(getter(ExternalUrlConfig::accessUrl)).setter(setter(Builder::accessUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessUrl").build()).build();

    private static final SdkField<List<String>> APPROVED_ORIGINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ApprovedOrigins")
            .getter(getter(ExternalUrlConfig::approvedOrigins))
            .setter(setter(Builder::approvedOrigins))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovedOrigins").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_URL_FIELD,
            APPROVED_ORIGINS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accessUrl;

    private final List<String> approvedOrigins;

    private ExternalUrlConfig(BuilderImpl builder) {
        this.accessUrl = builder.accessUrl;
        this.approvedOrigins = builder.approvedOrigins;
    }

    /**
     * <p>
     * The URL to access the application.
     * </p>
     * 
     * @return The URL to access the application.
     */
    public final String accessUrl() {
        return accessUrl;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApprovedOrigins property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApprovedOrigins() {
        return approvedOrigins != null && !(approvedOrigins instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional URLs to allow list if different than the access URL.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApprovedOrigins} method.
     * </p>
     * 
     * @return Additional URLs to allow list if different than the access URL.
     */
    public final List<String> approvedOrigins() {
        return approvedOrigins;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasApprovedOrigins() ? approvedOrigins() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalUrlConfig)) {
            return false;
        }
        ExternalUrlConfig other = (ExternalUrlConfig) obj;
        return Objects.equals(accessUrl(), other.accessUrl()) && hasApprovedOrigins() == other.hasApprovedOrigins()
                && Objects.equals(approvedOrigins(), other.approvedOrigins());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExternalUrlConfig").add("AccessUrl", accessUrl())
                .add("ApprovedOrigins", hasApprovedOrigins() ? approvedOrigins() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessUrl":
            return Optional.ofNullable(clazz.cast(accessUrl()));
        case "ApprovedOrigins":
            return Optional.ofNullable(clazz.cast(approvedOrigins()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccessUrl", ACCESS_URL_FIELD);
        map.put("ApprovedOrigins", APPROVED_ORIGINS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExternalUrlConfig, T> g) {
        return obj -> g.apply((ExternalUrlConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExternalUrlConfig> {
        /**
         * <p>
         * The URL to access the application.
         * </p>
         * 
         * @param accessUrl
         *        The URL to access the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessUrl(String accessUrl);

        /**
         * <p>
         * Additional URLs to allow list if different than the access URL.
         * </p>
         * 
         * @param approvedOrigins
         *        Additional URLs to allow list if different than the access URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvedOrigins(Collection<String> approvedOrigins);

        /**
         * <p>
         * Additional URLs to allow list if different than the access URL.
         * </p>
         * 
         * @param approvedOrigins
         *        Additional URLs to allow list if different than the access URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvedOrigins(String... approvedOrigins);
    }

    static final class BuilderImpl implements Builder {
        private String accessUrl;

        private List<String> approvedOrigins = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalUrlConfig model) {
            accessUrl(model.accessUrl);
            approvedOrigins(model.approvedOrigins);
        }

        public final String getAccessUrl() {
            return accessUrl;
        }

        public final void setAccessUrl(String accessUrl) {
            this.accessUrl = accessUrl;
        }

        @Override
        public final Builder accessUrl(String accessUrl) {
            this.accessUrl = accessUrl;
            return this;
        }

        public final Collection<String> getApprovedOrigins() {
            if (approvedOrigins instanceof SdkAutoConstructList) {
                return null;
            }
            return approvedOrigins;
        }

        public final void setApprovedOrigins(Collection<String> approvedOrigins) {
            this.approvedOrigins = ApplicationApprovedOriginsCopier.copy(approvedOrigins);
        }

        @Override
        public final Builder approvedOrigins(Collection<String> approvedOrigins) {
            this.approvedOrigins = ApplicationApprovedOriginsCopier.copy(approvedOrigins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvedOrigins(String... approvedOrigins) {
            approvedOrigins(Arrays.asList(approvedOrigins));
            return this;
        }

        @Override
        public ExternalUrlConfig build() {
            return new ExternalUrlConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
