/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The iframe configuration for the application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IframeConfig implements SdkPojo, Serializable, ToCopyableBuilder<IframeConfig.Builder, IframeConfig> {
    private static final SdkField<List<String>> ALLOW_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Allow")
            .getter(getter(IframeConfig::allow))
            .setter(setter(Builder::allow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Allow").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SANDBOX_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Sandbox")
            .getter(getter(IframeConfig::sandbox))
            .setter(setter(Builder::sandbox))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sandbox").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_FIELD, SANDBOX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> allow;

    private final List<String> sandbox;

    private IframeConfig(BuilderImpl builder) {
        this.allow = builder.allow;
        this.sandbox = builder.sandbox;
    }

    /**
     * For responses, this returns true if the service returned a value for the Allow property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasAllow() {
        return allow != null && !(allow instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of features that are allowed in the iframe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllow} method.
     * </p>
     * 
     * @return The list of features that are allowed in the iframe.
     */
    public final List<String> allow() {
        return allow;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sandbox property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSandbox() {
        return sandbox != null && !(sandbox instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of sandbox attributes for the iframe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSandbox} method.
     * </p>
     * 
     * @return The list of sandbox attributes for the iframe.
     */
    public final List<String> sandbox() {
        return sandbox;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAllow() ? allow() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSandbox() ? sandbox() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IframeConfig)) {
            return false;
        }
        IframeConfig other = (IframeConfig) obj;
        return hasAllow() == other.hasAllow() && Objects.equals(allow(), other.allow()) && hasSandbox() == other.hasSandbox()
                && Objects.equals(sandbox(), other.sandbox());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IframeConfig").add("Allow", hasAllow() ? allow() : null)
                .add("Sandbox", hasSandbox() ? sandbox() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Allow":
            return Optional.ofNullable(clazz.cast(allow()));
        case "Sandbox":
            return Optional.ofNullable(clazz.cast(sandbox()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Allow", ALLOW_FIELD);
        map.put("Sandbox", SANDBOX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IframeConfig, T> g) {
        return obj -> g.apply((IframeConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IframeConfig> {
        /**
         * <p>
         * The list of features that are allowed in the iframe.
         * </p>
         * 
         * @param allow
         *        The list of features that are allowed in the iframe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allow(Collection<String> allow);

        /**
         * <p>
         * The list of features that are allowed in the iframe.
         * </p>
         * 
         * @param allow
         *        The list of features that are allowed in the iframe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allow(String... allow);

        /**
         * <p>
         * The list of sandbox attributes for the iframe.
         * </p>
         * 
         * @param sandbox
         *        The list of sandbox attributes for the iframe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sandbox(Collection<String> sandbox);

        /**
         * <p>
         * The list of sandbox attributes for the iframe.
         * </p>
         * 
         * @param sandbox
         *        The list of sandbox attributes for the iframe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sandbox(String... sandbox);
    }

    static final class BuilderImpl implements Builder {
        private List<String> allow = DefaultSdkAutoConstructList.getInstance();

        private List<String> sandbox = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IframeConfig model) {
            allow(model.allow);
            sandbox(model.sandbox);
        }

        public final Collection<String> getAllow() {
            if (allow instanceof SdkAutoConstructList) {
                return null;
            }
            return allow;
        }

        public final void setAllow(Collection<String> allow) {
            this.allow = IframePermissionListCopier.copy(allow);
        }

        @Override
        public final Builder allow(Collection<String> allow) {
            this.allow = IframePermissionListCopier.copy(allow);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allow(String... allow) {
            allow(Arrays.asList(allow));
            return this;
        }

        public final Collection<String> getSandbox() {
            if (sandbox instanceof SdkAutoConstructList) {
                return null;
            }
            return sandbox;
        }

        public final void setSandbox(Collection<String> sandbox) {
            this.sandbox = IframePermissionListCopier.copy(sandbox);
        }

        @Override
        public final Builder sandbox(Collection<String> sandbox) {
            this.sandbox = IframePermissionListCopier.copy(sandbox);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sandbox(String... sandbox) {
            sandbox(Arrays.asList(sandbox));
            return this;
        }

        @Override
        public IframeConfig build() {
            return new IframeConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
