/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appintegrations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEventIntegrationsResponse extends AppIntegrationsResponse implements
        ToCopyableBuilder<ListEventIntegrationsResponse.Builder, ListEventIntegrationsResponse> {
    private static final SdkField<List<EventIntegration>> EVENT_INTEGRATIONS_FIELD = SdkField
            .<List<EventIntegration>> builder(MarshallingType.LIST)
            .memberName("EventIntegrations")
            .getter(getter(ListEventIntegrationsResponse::eventIntegrations))
            .setter(setter(Builder::eventIntegrations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventIntegrations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventIntegration> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventIntegration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEventIntegrationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_INTEGRATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<EventIntegration> eventIntegrations;

    private final String nextToken;

    private ListEventIntegrationsResponse(BuilderImpl builder) {
        super(builder);
        this.eventIntegrations = builder.eventIntegrations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventIntegrations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventIntegrations() {
        return eventIntegrations != null && !(eventIntegrations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The event integrations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventIntegrations} method.
     * </p>
     * 
     * @return The event integrations.
     */
    public final List<EventIntegration> eventIntegrations() {
        return eventIntegrations;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEventIntegrations() ? eventIntegrations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventIntegrationsResponse)) {
            return false;
        }
        ListEventIntegrationsResponse other = (ListEventIntegrationsResponse) obj;
        return hasEventIntegrations() == other.hasEventIntegrations()
                && Objects.equals(eventIntegrations(), other.eventIntegrations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEventIntegrationsResponse")
                .add("EventIntegrations", hasEventIntegrations() ? eventIntegrations() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventIntegrations":
            return Optional.ofNullable(clazz.cast(eventIntegrations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventIntegrations", EVENT_INTEGRATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEventIntegrationsResponse, T> g) {
        return obj -> g.apply((ListEventIntegrationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppIntegrationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEventIntegrationsResponse> {
        /**
         * <p>
         * The event integrations.
         * </p>
         * 
         * @param eventIntegrations
         *        The event integrations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventIntegrations(Collection<EventIntegration> eventIntegrations);

        /**
         * <p>
         * The event integrations.
         * </p>
         * 
         * @param eventIntegrations
         *        The event integrations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventIntegrations(EventIntegration... eventIntegrations);

        /**
         * <p>
         * The event integrations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appintegrations.model.EventIntegration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.appintegrations.model.EventIntegration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appintegrations.model.EventIntegration.Builder#build()} is called
         * immediately and its result is passed to {@link #eventIntegrations(List<EventIntegration>)}.
         * 
         * @param eventIntegrations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appintegrations.model.EventIntegration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventIntegrations(java.util.Collection<EventIntegration>)
         */
        Builder eventIntegrations(Consumer<EventIntegration.Builder>... eventIntegrations);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AppIntegrationsResponse.BuilderImpl implements Builder {
        private List<EventIntegration> eventIntegrations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventIntegrationsResponse model) {
            super(model);
            eventIntegrations(model.eventIntegrations);
            nextToken(model.nextToken);
        }

        public final List<EventIntegration.Builder> getEventIntegrations() {
            List<EventIntegration.Builder> result = EventIntegrationsListCopier.copyToBuilder(this.eventIntegrations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventIntegrations(Collection<EventIntegration.BuilderImpl> eventIntegrations) {
            this.eventIntegrations = EventIntegrationsListCopier.copyFromBuilder(eventIntegrations);
        }

        @Override
        public final Builder eventIntegrations(Collection<EventIntegration> eventIntegrations) {
            this.eventIntegrations = EventIntegrationsListCopier.copy(eventIntegrations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventIntegrations(EventIntegration... eventIntegrations) {
            eventIntegrations(Arrays.asList(eventIntegrations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventIntegrations(Consumer<EventIntegration.Builder>... eventIntegrations) {
            eventIntegrations(Stream.of(eventIntegrations).map(c -> EventIntegration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEventIntegrationsResponse build() {
            return new ListEventIntegrationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
