/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.applicationautoscaling.ApplicationAutoScalingClient;
import software.amazon.awssdk.services.applicationautoscaling.model.ApplicationAutoScalingException;
import software.amazon.awssdk.services.applicationautoscaling.model.ApplicationAutoScalingRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.ConcurrentUpdateException;
import software.amazon.awssdk.services.applicationautoscaling.model.DeleteScalingPolicyRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DeleteScalingPolicyResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.DeleteScheduledActionRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DeleteScheduledActionResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.DeregisterScalableTargetRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DeregisterScalableTargetResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalableTargetsRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalableTargetsResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingPoliciesRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingPoliciesResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.FailedResourceAccessException;
import software.amazon.awssdk.services.applicationautoscaling.model.InternalServiceException;
import software.amazon.awssdk.services.applicationautoscaling.model.InvalidNextTokenException;
import software.amazon.awssdk.services.applicationautoscaling.model.LimitExceededException;
import software.amazon.awssdk.services.applicationautoscaling.model.ObjectNotFoundException;
import software.amazon.awssdk.services.applicationautoscaling.model.PutScalingPolicyRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.PutScalingPolicyResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.PutScheduledActionRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.PutScheduledActionResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.RegisterScalableTargetRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.RegisterScalableTargetResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.ValidationException;
import software.amazon.awssdk.services.applicationautoscaling.paginators.DescribeScalableTargetsIterable;
import software.amazon.awssdk.services.applicationautoscaling.paginators.DescribeScalingActivitiesIterable;
import software.amazon.awssdk.services.applicationautoscaling.paginators.DescribeScalingPoliciesIterable;
import software.amazon.awssdk.services.applicationautoscaling.paginators.DescribeScheduledActionsIterable;
import software.amazon.awssdk.services.applicationautoscaling.transform.DeleteScalingPolicyRequestMarshaller;
import software.amazon.awssdk.services.applicationautoscaling.transform.DeleteScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.applicationautoscaling.transform.DeregisterScalableTargetRequestMarshaller;
import software.amazon.awssdk.services.applicationautoscaling.transform.DescribeScalableTargetsRequestMarshaller;
import software.amazon.awssdk.services.applicationautoscaling.transform.DescribeScalingActivitiesRequestMarshaller;
import software.amazon.awssdk.services.applicationautoscaling.transform.DescribeScalingPoliciesRequestMarshaller;
import software.amazon.awssdk.services.applicationautoscaling.transform.DescribeScheduledActionsRequestMarshaller;
import software.amazon.awssdk.services.applicationautoscaling.transform.PutScalingPolicyRequestMarshaller;
import software.amazon.awssdk.services.applicationautoscaling.transform.PutScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.applicationautoscaling.transform.RegisterScalableTargetRequestMarshaller;

@SdkInternalApi
final class DefaultApplicationAutoScalingClient
implements ApplicationAutoScalingClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultApplicationAutoScalingClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "application-autoscaling";
    }

    @Override
    public DeleteScalingPolicyResponse deleteScalingPolicy(DeleteScalingPolicyRequest deleteScalingPolicyRequest) throws ValidationException, ObjectNotFoundException, ConcurrentUpdateException, InternalServiceException, AwsServiceException, SdkClientException, ApplicationAutoScalingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteScalingPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteScalingPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteScalingPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteScalingPolicyRequest).withMarshaller((Marshaller)new DeleteScalingPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteScheduledActionResponse deleteScheduledAction(DeleteScheduledActionRequest deleteScheduledActionRequest) throws ValidationException, ObjectNotFoundException, ConcurrentUpdateException, InternalServiceException, AwsServiceException, SdkClientException, ApplicationAutoScalingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteScheduledActionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteScheduledActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteScheduledAction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteScheduledActionRequest).withMarshaller((Marshaller)new DeleteScheduledActionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeregisterScalableTargetResponse deregisterScalableTarget(DeregisterScalableTargetRequest deregisterScalableTargetRequest) throws ValidationException, ObjectNotFoundException, ConcurrentUpdateException, InternalServiceException, AwsServiceException, SdkClientException, ApplicationAutoScalingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterScalableTargetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeregisterScalableTargetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterScalableTarget").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deregisterScalableTargetRequest).withMarshaller((Marshaller)new DeregisterScalableTargetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeScalableTargetsResponse describeScalableTargets(DescribeScalableTargetsRequest describeScalableTargetsRequest) throws ValidationException, InvalidNextTokenException, ConcurrentUpdateException, InternalServiceException, AwsServiceException, SdkClientException, ApplicationAutoScalingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeScalableTargetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeScalableTargetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScalableTargets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeScalableTargetsRequest).withMarshaller((Marshaller)new DescribeScalableTargetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeScalableTargetsIterable describeScalableTargetsPaginator(DescribeScalableTargetsRequest describeScalableTargetsRequest) throws ValidationException, InvalidNextTokenException, ConcurrentUpdateException, InternalServiceException, AwsServiceException, SdkClientException, ApplicationAutoScalingException {
        return new DescribeScalableTargetsIterable(this, this.applyPaginatorUserAgent(describeScalableTargetsRequest));
    }

    @Override
    public DescribeScalingActivitiesResponse describeScalingActivities(DescribeScalingActivitiesRequest describeScalingActivitiesRequest) throws ValidationException, InvalidNextTokenException, ConcurrentUpdateException, InternalServiceException, AwsServiceException, SdkClientException, ApplicationAutoScalingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeScalingActivitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeScalingActivitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScalingActivities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeScalingActivitiesRequest).withMarshaller((Marshaller)new DescribeScalingActivitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeScalingActivitiesIterable describeScalingActivitiesPaginator(DescribeScalingActivitiesRequest describeScalingActivitiesRequest) throws ValidationException, InvalidNextTokenException, ConcurrentUpdateException, InternalServiceException, AwsServiceException, SdkClientException, ApplicationAutoScalingException {
        return new DescribeScalingActivitiesIterable(this, this.applyPaginatorUserAgent(describeScalingActivitiesRequest));
    }

    @Override
    public DescribeScalingPoliciesResponse describeScalingPolicies(DescribeScalingPoliciesRequest describeScalingPoliciesRequest) throws ValidationException, FailedResourceAccessException, InvalidNextTokenException, ConcurrentUpdateException, InternalServiceException, AwsServiceException, SdkClientException, ApplicationAutoScalingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeScalingPoliciesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeScalingPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScalingPolicies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeScalingPoliciesRequest).withMarshaller((Marshaller)new DescribeScalingPoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeScalingPoliciesIterable describeScalingPoliciesPaginator(DescribeScalingPoliciesRequest describeScalingPoliciesRequest) throws ValidationException, FailedResourceAccessException, InvalidNextTokenException, ConcurrentUpdateException, InternalServiceException, AwsServiceException, SdkClientException, ApplicationAutoScalingException {
        return new DescribeScalingPoliciesIterable(this, this.applyPaginatorUserAgent(describeScalingPoliciesRequest));
    }

    @Override
    public DescribeScheduledActionsResponse describeScheduledActions(DescribeScheduledActionsRequest describeScheduledActionsRequest) throws ValidationException, InvalidNextTokenException, ConcurrentUpdateException, InternalServiceException, AwsServiceException, SdkClientException, ApplicationAutoScalingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeScheduledActionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeScheduledActionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScheduledActions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeScheduledActionsRequest).withMarshaller((Marshaller)new DescribeScheduledActionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeScheduledActionsIterable describeScheduledActionsPaginator(DescribeScheduledActionsRequest describeScheduledActionsRequest) throws ValidationException, InvalidNextTokenException, ConcurrentUpdateException, InternalServiceException, AwsServiceException, SdkClientException, ApplicationAutoScalingException {
        return new DescribeScheduledActionsIterable(this, this.applyPaginatorUserAgent(describeScheduledActionsRequest));
    }

    @Override
    public PutScalingPolicyResponse putScalingPolicy(PutScalingPolicyRequest putScalingPolicyRequest) throws ValidationException, LimitExceededException, ObjectNotFoundException, ConcurrentUpdateException, FailedResourceAccessException, InternalServiceException, AwsServiceException, SdkClientException, ApplicationAutoScalingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutScalingPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutScalingPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutScalingPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putScalingPolicyRequest).withMarshaller((Marshaller)new PutScalingPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutScheduledActionResponse putScheduledAction(PutScheduledActionRequest putScheduledActionRequest) throws ValidationException, LimitExceededException, ObjectNotFoundException, ConcurrentUpdateException, InternalServiceException, AwsServiceException, SdkClientException, ApplicationAutoScalingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutScheduledActionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutScheduledActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutScheduledAction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putScheduledActionRequest).withMarshaller((Marshaller)new PutScheduledActionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RegisterScalableTargetResponse registerScalableTarget(RegisterScalableTargetRequest registerScalableTargetRequest) throws ValidationException, LimitExceededException, ConcurrentUpdateException, InternalServiceException, AwsServiceException, SdkClientException, ApplicationAutoScalingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterScalableTargetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RegisterScalableTargetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterScalableTarget").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerScalableTargetRequest).withMarshaller((Marshaller)new RegisterScalableTargetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ApplicationAutoScalingException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ObjectNotFoundException").exceptionBuilderSupplier(ObjectNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FailedResourceAccessException").exceptionBuilderSupplier(FailedResourceAccessException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentUpdateException").exceptionBuilderSupplier(ConcurrentUpdateException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends ApplicationAutoScalingRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.12.0").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ApplicationAutoScalingRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

