/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationautoscaling.model.ApplicationAutoScalingRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalableTargetAction;
import software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutScheduledActionRequest
extends ApplicationAutoScalingRequest
implements ToCopyableBuilder<Builder, PutScheduledActionRequest> {
    private static final SdkField<String> SERVICE_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutScheduledActionRequest.getter(PutScheduledActionRequest::serviceNamespaceAsString)).setter(PutScheduledActionRequest.setter(Builder::serviceNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNamespace").build()}).build();
    private static final SdkField<String> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutScheduledActionRequest.getter(PutScheduledActionRequest::schedule)).setter(PutScheduledActionRequest.setter(Builder::schedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<String> SCHEDULED_ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutScheduledActionRequest.getter(PutScheduledActionRequest::scheduledActionName)).setter(PutScheduledActionRequest.setter(Builder::scheduledActionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledActionName").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutScheduledActionRequest.getter(PutScheduledActionRequest::resourceId)).setter(PutScheduledActionRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> SCALABLE_DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutScheduledActionRequest.getter(PutScheduledActionRequest::scalableDimensionAsString)).setter(PutScheduledActionRequest.setter(Builder::scalableDimension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalableDimension").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(PutScheduledActionRequest.getter(PutScheduledActionRequest::startTime)).setter(PutScheduledActionRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(PutScheduledActionRequest.getter(PutScheduledActionRequest::endTime)).setter(PutScheduledActionRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<ScalableTargetAction> SCALABLE_TARGET_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PutScheduledActionRequest.getter(PutScheduledActionRequest::scalableTargetAction)).setter(PutScheduledActionRequest.setter(Builder::scalableTargetAction)).constructor(ScalableTargetAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalableTargetAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAMESPACE_FIELD, SCHEDULE_FIELD, SCHEDULED_ACTION_NAME_FIELD, RESOURCE_ID_FIELD, SCALABLE_DIMENSION_FIELD, START_TIME_FIELD, END_TIME_FIELD, SCALABLE_TARGET_ACTION_FIELD));
    private final String serviceNamespace;
    private final String schedule;
    private final String scheduledActionName;
    private final String resourceId;
    private final String scalableDimension;
    private final Instant startTime;
    private final Instant endTime;
    private final ScalableTargetAction scalableTargetAction;

    private PutScheduledActionRequest(BuilderImpl builder) {
        super(builder);
        this.serviceNamespace = builder.serviceNamespace;
        this.schedule = builder.schedule;
        this.scheduledActionName = builder.scheduledActionName;
        this.resourceId = builder.resourceId;
        this.scalableDimension = builder.scalableDimension;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.scalableTargetAction = builder.scalableTargetAction;
    }

    public ServiceNamespace serviceNamespace() {
        return ServiceNamespace.fromValue(this.serviceNamespace);
    }

    public String serviceNamespaceAsString() {
        return this.serviceNamespace;
    }

    public String schedule() {
        return this.schedule;
    }

    public String scheduledActionName() {
        return this.scheduledActionName;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public ScalableDimension scalableDimension() {
        return ScalableDimension.fromValue(this.scalableDimension);
    }

    public String scalableDimensionAsString() {
        return this.scalableDimension;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public ScalableTargetAction scalableTargetAction() {
        return this.scalableTargetAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNamespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledActionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalableDimensionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalableTargetAction());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutScheduledActionRequest)) {
            return false;
        }
        PutScheduledActionRequest other = (PutScheduledActionRequest)((Object)obj);
        return Objects.equals(this.serviceNamespaceAsString(), other.serviceNamespaceAsString()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.scheduledActionName(), other.scheduledActionName()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.scalableDimensionAsString(), other.scalableDimensionAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.scalableTargetAction(), other.scalableTargetAction());
    }

    public String toString() {
        return ToString.builder((String)"PutScheduledActionRequest").add("ServiceNamespace", (Object)this.serviceNamespaceAsString()).add("Schedule", (Object)this.schedule()).add("ScheduledActionName", (Object)this.scheduledActionName()).add("ResourceId", (Object)this.resourceId()).add("ScalableDimension", (Object)this.scalableDimensionAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("ScalableTargetAction", (Object)this.scalableTargetAction()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceNamespace": {
                return Optional.ofNullable(clazz.cast(this.serviceNamespaceAsString()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "ScheduledActionName": {
                return Optional.ofNullable(clazz.cast(this.scheduledActionName()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ScalableDimension": {
                return Optional.ofNullable(clazz.cast(this.scalableDimensionAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "ScalableTargetAction": {
                return Optional.ofNullable(clazz.cast(this.scalableTargetAction()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutScheduledActionRequest, T> g) {
        return obj -> g.apply((PutScheduledActionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationAutoScalingRequest.BuilderImpl
    implements Builder {
        private String serviceNamespace;
        private String schedule;
        private String scheduledActionName;
        private String resourceId;
        private String scalableDimension;
        private Instant startTime;
        private Instant endTime;
        private ScalableTargetAction scalableTargetAction;

        private BuilderImpl() {
        }

        private BuilderImpl(PutScheduledActionRequest model) {
            super(model);
            this.serviceNamespace(model.serviceNamespace);
            this.schedule(model.schedule);
            this.scheduledActionName(model.scheduledActionName);
            this.resourceId(model.resourceId);
            this.scalableDimension(model.scalableDimension);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.scalableTargetAction(model.scalableTargetAction);
        }

        public final String getServiceNamespaceAsString() {
            return this.serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        @Override
        public final Builder serviceNamespace(ServiceNamespace serviceNamespace) {
            this.serviceNamespace(serviceNamespace == null ? null : serviceNamespace.toString());
            return this;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        public final String getSchedule() {
            return this.schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        public final String getScheduledActionName() {
            return this.scheduledActionName;
        }

        @Override
        public final Builder scheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
            return this;
        }

        public final void setScheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getScalableDimensionAsString() {
            return this.scalableDimension;
        }

        @Override
        public final Builder scalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
            return this;
        }

        @Override
        public final Builder scalableDimension(ScalableDimension scalableDimension) {
            this.scalableDimension(scalableDimension == null ? null : scalableDimension.toString());
            return this;
        }

        public final void setScalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final ScalableTargetAction.Builder getScalableTargetAction() {
            return this.scalableTargetAction != null ? this.scalableTargetAction.toBuilder() : null;
        }

        @Override
        public final Builder scalableTargetAction(ScalableTargetAction scalableTargetAction) {
            this.scalableTargetAction = scalableTargetAction;
            return this;
        }

        public final void setScalableTargetAction(ScalableTargetAction.BuilderImpl scalableTargetAction) {
            this.scalableTargetAction = scalableTargetAction != null ? scalableTargetAction.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutScheduledActionRequest build() {
            return new PutScheduledActionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationAutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutScheduledActionRequest> {
        public Builder serviceNamespace(String var1);

        public Builder serviceNamespace(ServiceNamespace var1);

        public Builder schedule(String var1);

        public Builder scheduledActionName(String var1);

        public Builder resourceId(String var1);

        public Builder scalableDimension(String var1);

        public Builder scalableDimension(ScalableDimension var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder scalableTargetAction(ScalableTargetAction var1);

        default public Builder scalableTargetAction(Consumer<ScalableTargetAction.Builder> scalableTargetAction) {
            return this.scalableTargetAction((ScalableTargetAction)((ScalableTargetAction.Builder)ScalableTargetAction.builder().applyMutation(scalableTargetAction)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

