/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ScalableDimension {
    ECS_SERVICE_DESIRED_COUNT("ecs:service:DesiredCount"),
    EC2_SPOT_FLEET_REQUEST_TARGET_CAPACITY("ec2:spot-fleet-request:TargetCapacity"),
    ELASTICMAPREDUCE_INSTANCEGROUP_INSTANCE_COUNT("elasticmapreduce:instancegroup:InstanceCount"),
    APPSTREAM_FLEET_DESIRED_CAPACITY("appstream:fleet:DesiredCapacity"),
    DYNAMODB_TABLE_READ_CAPACITY_UNITS("dynamodb:table:ReadCapacityUnits"),
    DYNAMODB_TABLE_WRITE_CAPACITY_UNITS("dynamodb:table:WriteCapacityUnits"),
    DYNAMODB_INDEX_READ_CAPACITY_UNITS("dynamodb:index:ReadCapacityUnits"),
    DYNAMODB_INDEX_WRITE_CAPACITY_UNITS("dynamodb:index:WriteCapacityUnits"),
    RDS_CLUSTER_READ_REPLICA_COUNT("rds:cluster:ReadReplicaCount"),
    SAGEMAKER_VARIANT_DESIRED_INSTANCE_COUNT("sagemaker:variant:DesiredInstanceCount"),
    CUSTOM_RESOURCE_RESOURCE_TYPE_PROPERTY("custom-resource:ResourceType:Property"),
    COMPREHEND_DOCUMENT_CLASSIFIER_ENDPOINT_DESIRED_INFERENCE_UNITS("comprehend:document-classifier-endpoint:DesiredInferenceUnits"),
    LAMBDA_FUNCTION_PROVISIONED_CONCURRENCY("lambda:function:ProvisionedConcurrency"),
    CASSANDRA_TABLE_READ_CAPACITY_UNITS("cassandra:table:ReadCapacityUnits"),
    CASSANDRA_TABLE_WRITE_CAPACITY_UNITS("cassandra:table:WriteCapacityUnits"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ScalableDimension(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScalableDimension fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ScalableDimension.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScalableDimension> knownValues() {
        return Stream.of(ScalableDimension.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

