/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationautoscaling.ApplicationAutoScalingClient;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalableTargetsRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalableTargetsResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalableTarget;

public class DescribeScalableTargetsIterable
implements SdkIterable<DescribeScalableTargetsResponse> {
    private final ApplicationAutoScalingClient client;
    private final DescribeScalableTargetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeScalableTargetsIterable(ApplicationAutoScalingClient client, DescribeScalableTargetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeScalableTargetsResponseFetcher();
    }

    public Iterator<DescribeScalableTargetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ScalableTarget> scalableTargets() {
        Function<DescribeScalableTargetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.scalableTargets() != null) {
                return response.scalableTargets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeScalableTargetsResponseFetcher
    implements SyncPageFetcher<DescribeScalableTargetsResponse> {
        private DescribeScalableTargetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeScalableTargetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeScalableTargetsResponse nextPage(DescribeScalableTargetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeScalableTargetsIterable.this.client.describeScalableTargets(DescribeScalableTargetsIterable.this.firstRequest);
            }
            return DescribeScalableTargetsIterable.this.client.describeScalableTargets((DescribeScalableTargetsRequest)((Object)DescribeScalableTargetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

