/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivityStatusCode;
import software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScalingActivity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScalingActivity> {
    private static final SdkField<String> ACTIVITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActivityId").getter(ScalingActivity.getter(ScalingActivity::activityId)).setter(ScalingActivity.setter(Builder::activityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivityId").build()}).build();
    private static final SdkField<String> SERVICE_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceNamespace").getter(ScalingActivity.getter(ScalingActivity::serviceNamespaceAsString)).setter(ScalingActivity.setter(Builder::serviceNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNamespace").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(ScalingActivity.getter(ScalingActivity::resourceId)).setter(ScalingActivity.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> SCALABLE_DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalableDimension").getter(ScalingActivity.getter(ScalingActivity::scalableDimensionAsString)).setter(ScalingActivity.setter(Builder::scalableDimension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalableDimension").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ScalingActivity.getter(ScalingActivity::description)).setter(ScalingActivity.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Cause").getter(ScalingActivity.getter(ScalingActivity::cause)).setter(ScalingActivity.setter(Builder::cause)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cause").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ScalingActivity.getter(ScalingActivity::startTime)).setter(ScalingActivity.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(ScalingActivity.getter(ScalingActivity::endTime)).setter(ScalingActivity.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusCode").getter(ScalingActivity.getter(ScalingActivity::statusCodeAsString)).setter(ScalingActivity.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(ScalingActivity.getter(ScalingActivity::statusMessage)).setter(ScalingActivity.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Details").getter(ScalingActivity.getter(ScalingActivity::details)).setter(ScalingActivity.setter(Builder::details)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_ID_FIELD, SERVICE_NAMESPACE_FIELD, RESOURCE_ID_FIELD, SCALABLE_DIMENSION_FIELD, DESCRIPTION_FIELD, CAUSE_FIELD, START_TIME_FIELD, END_TIME_FIELD, STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD, DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String activityId;
    private final String serviceNamespace;
    private final String resourceId;
    private final String scalableDimension;
    private final String description;
    private final String cause;
    private final Instant startTime;
    private final Instant endTime;
    private final String statusCode;
    private final String statusMessage;
    private final String details;

    private ScalingActivity(BuilderImpl builder) {
        this.activityId = builder.activityId;
        this.serviceNamespace = builder.serviceNamespace;
        this.resourceId = builder.resourceId;
        this.scalableDimension = builder.scalableDimension;
        this.description = builder.description;
        this.cause = builder.cause;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
        this.details = builder.details;
    }

    public String activityId() {
        return this.activityId;
    }

    public ServiceNamespace serviceNamespace() {
        return ServiceNamespace.fromValue(this.serviceNamespace);
    }

    public String serviceNamespaceAsString() {
        return this.serviceNamespace;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public ScalableDimension scalableDimension() {
        return ScalableDimension.fromValue(this.scalableDimension);
    }

    public String scalableDimensionAsString() {
        return this.scalableDimension;
    }

    public String description() {
        return this.description;
    }

    public String cause() {
        return this.cause;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public ScalingActivityStatusCode statusCode() {
        return ScalingActivityStatusCode.fromValue(this.statusCode);
    }

    public String statusCodeAsString() {
        return this.statusCode;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public String details() {
        return this.details;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNamespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalableDimensionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.cause());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingActivity)) {
            return false;
        }
        ScalingActivity other = (ScalingActivity)obj;
        return Objects.equals(this.activityId(), other.activityId()) && Objects.equals(this.serviceNamespaceAsString(), other.serviceNamespaceAsString()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.scalableDimensionAsString(), other.scalableDimensionAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.cause(), other.cause()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.statusCodeAsString(), other.statusCodeAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.details(), other.details());
    }

    public String toString() {
        return ToString.builder((String)"ScalingActivity").add("ActivityId", (Object)this.activityId()).add("ServiceNamespace", (Object)this.serviceNamespaceAsString()).add("ResourceId", (Object)this.resourceId()).add("ScalableDimension", (Object)this.scalableDimensionAsString()).add("Description", (Object)this.description()).add("Cause", (Object)this.cause()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("StatusCode", (Object)this.statusCodeAsString()).add("StatusMessage", (Object)this.statusMessage()).add("Details", (Object)this.details()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActivityId": {
                return Optional.ofNullable(clazz.cast(this.activityId()));
            }
            case "ServiceNamespace": {
                return Optional.ofNullable(clazz.cast(this.serviceNamespaceAsString()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ScalableDimension": {
                return Optional.ofNullable(clazz.cast(this.scalableDimensionAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Cause": {
                return Optional.ofNullable(clazz.cast(this.cause()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCodeAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "Details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScalingActivity, T> g) {
        return obj -> g.apply((ScalingActivity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String activityId;
        private String serviceNamespace;
        private String resourceId;
        private String scalableDimension;
        private String description;
        private String cause;
        private Instant startTime;
        private Instant endTime;
        private String statusCode;
        private String statusMessage;
        private String details;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingActivity model) {
            this.activityId(model.activityId);
            this.serviceNamespace(model.serviceNamespace);
            this.resourceId(model.resourceId);
            this.scalableDimension(model.scalableDimension);
            this.description(model.description);
            this.cause(model.cause);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.statusCode(model.statusCode);
            this.statusMessage(model.statusMessage);
            this.details(model.details);
        }

        public final String getActivityId() {
            return this.activityId;
        }

        @Override
        public final Builder activityId(String activityId) {
            this.activityId = activityId;
            return this;
        }

        public final void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        public final String getServiceNamespace() {
            return this.serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        @Override
        public final Builder serviceNamespace(ServiceNamespace serviceNamespace) {
            this.serviceNamespace(serviceNamespace == null ? null : serviceNamespace.toString());
            return this;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getScalableDimension() {
            return this.scalableDimension;
        }

        @Override
        public final Builder scalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
            return this;
        }

        @Override
        public final Builder scalableDimension(ScalableDimension scalableDimension) {
            this.scalableDimension(scalableDimension == null ? null : scalableDimension.toString());
            return this;
        }

        public final void setScalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getCause() {
            return this.cause;
        }

        @Override
        public final Builder cause(String cause) {
            this.cause = cause;
            return this;
        }

        public final void setCause(String cause) {
            this.cause = cause;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(ScalingActivityStatusCode statusCode) {
            this.statusCode(statusCode == null ? null : statusCode.toString());
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getDetails() {
            return this.details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        public ScalingActivity build() {
            return new ScalingActivity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScalingActivity> {
        public Builder activityId(String var1);

        public Builder serviceNamespace(String var1);

        public Builder serviceNamespace(ServiceNamespace var1);

        public Builder resourceId(String var1);

        public Builder scalableDimension(String var1);

        public Builder scalableDimension(ScalableDimension var1);

        public Builder description(String var1);

        public Builder cause(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder statusCode(String var1);

        public Builder statusCode(ScalingActivityStatusCode var1);

        public Builder statusMessage(String var1);

        public Builder details(String var1);
    }
}

