/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationautoscaling.model.Alarm;
import software.amazon.awssdk.services.applicationautoscaling.model.AlarmsCopier;
import software.amazon.awssdk.services.applicationautoscaling.model.PolicyType;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension;
import software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace;
import software.amazon.awssdk.services.applicationautoscaling.model.StepScalingPolicyConfiguration;
import software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScalingPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScalingPolicy> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyARN").getter(ScalingPolicy.getter(ScalingPolicy::policyARN)).setter(ScalingPolicy.setter(Builder::policyARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyARN").build()}).build();
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyName").getter(ScalingPolicy.getter(ScalingPolicy::policyName)).setter(ScalingPolicy.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()}).build();
    private static final SdkField<String> SERVICE_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceNamespace").getter(ScalingPolicy.getter(ScalingPolicy::serviceNamespaceAsString)).setter(ScalingPolicy.setter(Builder::serviceNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNamespace").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(ScalingPolicy.getter(ScalingPolicy::resourceId)).setter(ScalingPolicy.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> SCALABLE_DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalableDimension").getter(ScalingPolicy.getter(ScalingPolicy::scalableDimensionAsString)).setter(ScalingPolicy.setter(Builder::scalableDimension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalableDimension").build()}).build();
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyType").getter(ScalingPolicy.getter(ScalingPolicy::policyTypeAsString)).setter(ScalingPolicy.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()}).build();
    private static final SdkField<StepScalingPolicyConfiguration> STEP_SCALING_POLICY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StepScalingPolicyConfiguration").getter(ScalingPolicy.getter(ScalingPolicy::stepScalingPolicyConfiguration)).setter(ScalingPolicy.setter(Builder::stepScalingPolicyConfiguration)).constructor(StepScalingPolicyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepScalingPolicyConfiguration").build()}).build();
    private static final SdkField<TargetTrackingScalingPolicyConfiguration> TARGET_TRACKING_SCALING_POLICY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetTrackingScalingPolicyConfiguration").getter(ScalingPolicy.getter(ScalingPolicy::targetTrackingScalingPolicyConfiguration)).setter(ScalingPolicy.setter(Builder::targetTrackingScalingPolicyConfiguration)).constructor(TargetTrackingScalingPolicyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTrackingScalingPolicyConfiguration").build()}).build();
    private static final SdkField<List<Alarm>> ALARMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Alarms").getter(ScalingPolicy.getter(ScalingPolicy::alarms)).setter(ScalingPolicy.setter(Builder::alarms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alarms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Alarm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ScalingPolicy.getter(ScalingPolicy::creationTime)).setter(ScalingPolicy.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD, POLICY_NAME_FIELD, SERVICE_NAMESPACE_FIELD, RESOURCE_ID_FIELD, SCALABLE_DIMENSION_FIELD, POLICY_TYPE_FIELD, STEP_SCALING_POLICY_CONFIGURATION_FIELD, TARGET_TRACKING_SCALING_POLICY_CONFIGURATION_FIELD, ALARMS_FIELD, CREATION_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String policyARN;
    private final String policyName;
    private final String serviceNamespace;
    private final String resourceId;
    private final String scalableDimension;
    private final String policyType;
    private final StepScalingPolicyConfiguration stepScalingPolicyConfiguration;
    private final TargetTrackingScalingPolicyConfiguration targetTrackingScalingPolicyConfiguration;
    private final List<Alarm> alarms;
    private final Instant creationTime;

    private ScalingPolicy(BuilderImpl builder) {
        this.policyARN = builder.policyARN;
        this.policyName = builder.policyName;
        this.serviceNamespace = builder.serviceNamespace;
        this.resourceId = builder.resourceId;
        this.scalableDimension = builder.scalableDimension;
        this.policyType = builder.policyType;
        this.stepScalingPolicyConfiguration = builder.stepScalingPolicyConfiguration;
        this.targetTrackingScalingPolicyConfiguration = builder.targetTrackingScalingPolicyConfiguration;
        this.alarms = builder.alarms;
        this.creationTime = builder.creationTime;
    }

    public final String policyARN() {
        return this.policyARN;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final ServiceNamespace serviceNamespace() {
        return ServiceNamespace.fromValue(this.serviceNamespace);
    }

    public final String serviceNamespaceAsString() {
        return this.serviceNamespace;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final ScalableDimension scalableDimension() {
        return ScalableDimension.fromValue(this.scalableDimension);
    }

    public final String scalableDimensionAsString() {
        return this.scalableDimension;
    }

    public final PolicyType policyType() {
        return PolicyType.fromValue(this.policyType);
    }

    public final String policyTypeAsString() {
        return this.policyType;
    }

    public final StepScalingPolicyConfiguration stepScalingPolicyConfiguration() {
        return this.stepScalingPolicyConfiguration;
    }

    public final TargetTrackingScalingPolicyConfiguration targetTrackingScalingPolicyConfiguration() {
        return this.targetTrackingScalingPolicyConfiguration;
    }

    public final boolean hasAlarms() {
        return this.alarms != null && !(this.alarms instanceof SdkAutoConstructList);
    }

    public final List<Alarm> alarms() {
        return this.alarms;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNamespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalableDimensionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepScalingPolicyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTrackingScalingPolicyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlarms() ? this.alarms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingPolicy)) {
            return false;
        }
        ScalingPolicy other = (ScalingPolicy)obj;
        return Objects.equals(this.policyARN(), other.policyARN()) && Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.serviceNamespaceAsString(), other.serviceNamespaceAsString()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.scalableDimensionAsString(), other.scalableDimensionAsString()) && Objects.equals(this.policyTypeAsString(), other.policyTypeAsString()) && Objects.equals(this.stepScalingPolicyConfiguration(), other.stepScalingPolicyConfiguration()) && Objects.equals(this.targetTrackingScalingPolicyConfiguration(), other.targetTrackingScalingPolicyConfiguration()) && this.hasAlarms() == other.hasAlarms() && Objects.equals(this.alarms(), other.alarms()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"ScalingPolicy").add("PolicyARN", (Object)this.policyARN()).add("PolicyName", (Object)this.policyName()).add("ServiceNamespace", (Object)this.serviceNamespaceAsString()).add("ResourceId", (Object)this.resourceId()).add("ScalableDimension", (Object)this.scalableDimensionAsString()).add("PolicyType", (Object)this.policyTypeAsString()).add("StepScalingPolicyConfiguration", (Object)this.stepScalingPolicyConfiguration()).add("TargetTrackingScalingPolicyConfiguration", (Object)this.targetTrackingScalingPolicyConfiguration()).add("Alarms", this.hasAlarms() ? this.alarms() : null).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyARN": {
                return Optional.ofNullable(clazz.cast(this.policyARN()));
            }
            case "PolicyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "ServiceNamespace": {
                return Optional.ofNullable(clazz.cast(this.serviceNamespaceAsString()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ScalableDimension": {
                return Optional.ofNullable(clazz.cast(this.scalableDimensionAsString()));
            }
            case "PolicyType": {
                return Optional.ofNullable(clazz.cast(this.policyTypeAsString()));
            }
            case "StepScalingPolicyConfiguration": {
                return Optional.ofNullable(clazz.cast(this.stepScalingPolicyConfiguration()));
            }
            case "TargetTrackingScalingPolicyConfiguration": {
                return Optional.ofNullable(clazz.cast(this.targetTrackingScalingPolicyConfiguration()));
            }
            case "Alarms": {
                return Optional.ofNullable(clazz.cast(this.alarms()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScalingPolicy, T> g) {
        return obj -> g.apply((ScalingPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyARN;
        private String policyName;
        private String serviceNamespace;
        private String resourceId;
        private String scalableDimension;
        private String policyType;
        private StepScalingPolicyConfiguration stepScalingPolicyConfiguration;
        private TargetTrackingScalingPolicyConfiguration targetTrackingScalingPolicyConfiguration;
        private List<Alarm> alarms = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingPolicy model) {
            this.policyARN(model.policyARN);
            this.policyName(model.policyName);
            this.serviceNamespace(model.serviceNamespace);
            this.resourceId(model.resourceId);
            this.scalableDimension(model.scalableDimension);
            this.policyType(model.policyType);
            this.stepScalingPolicyConfiguration(model.stepScalingPolicyConfiguration);
            this.targetTrackingScalingPolicyConfiguration(model.targetTrackingScalingPolicyConfiguration);
            this.alarms(model.alarms);
            this.creationTime(model.creationTime);
        }

        public final String getPolicyARN() {
            return this.policyARN;
        }

        @Override
        public final Builder policyARN(String policyARN) {
            this.policyARN = policyARN;
            return this;
        }

        public final void setPolicyARN(String policyARN) {
            this.policyARN = policyARN;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getServiceNamespace() {
            return this.serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        @Override
        public final Builder serviceNamespace(ServiceNamespace serviceNamespace) {
            this.serviceNamespace(serviceNamespace == null ? null : serviceNamespace.toString());
            return this;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getScalableDimension() {
            return this.scalableDimension;
        }

        @Override
        public final Builder scalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
            return this;
        }

        @Override
        public final Builder scalableDimension(ScalableDimension scalableDimension) {
            this.scalableDimension(scalableDimension == null ? null : scalableDimension.toString());
            return this;
        }

        public final void setScalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        public final StepScalingPolicyConfiguration.Builder getStepScalingPolicyConfiguration() {
            return this.stepScalingPolicyConfiguration != null ? this.stepScalingPolicyConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder stepScalingPolicyConfiguration(StepScalingPolicyConfiguration stepScalingPolicyConfiguration) {
            this.stepScalingPolicyConfiguration = stepScalingPolicyConfiguration;
            return this;
        }

        public final void setStepScalingPolicyConfiguration(StepScalingPolicyConfiguration.BuilderImpl stepScalingPolicyConfiguration) {
            this.stepScalingPolicyConfiguration = stepScalingPolicyConfiguration != null ? stepScalingPolicyConfiguration.build() : null;
        }

        public final TargetTrackingScalingPolicyConfiguration.Builder getTargetTrackingScalingPolicyConfiguration() {
            return this.targetTrackingScalingPolicyConfiguration != null ? this.targetTrackingScalingPolicyConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfiguration targetTrackingScalingPolicyConfiguration) {
            this.targetTrackingScalingPolicyConfiguration = targetTrackingScalingPolicyConfiguration;
            return this;
        }

        public final void setTargetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfiguration.BuilderImpl targetTrackingScalingPolicyConfiguration) {
            this.targetTrackingScalingPolicyConfiguration = targetTrackingScalingPolicyConfiguration != null ? targetTrackingScalingPolicyConfiguration.build() : null;
        }

        public final Collection<Alarm.Builder> getAlarms() {
            if (this.alarms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.alarms != null ? (Collection)this.alarms.stream().map(Alarm::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder alarms(Collection<Alarm> alarms) {
            this.alarms = AlarmsCopier.copy(alarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(Alarm ... alarms) {
            this.alarms(Arrays.asList(alarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(Consumer<Alarm.Builder> ... alarms) {
            this.alarms(Stream.of(alarms).map(c -> (Alarm)((Alarm.Builder)Alarm.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAlarms(Collection<Alarm.BuilderImpl> alarms) {
            this.alarms = AlarmsCopier.copyFromBuilder(alarms);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public ScalingPolicy build() {
            return new ScalingPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScalingPolicy> {
        public Builder policyARN(String var1);

        public Builder policyName(String var1);

        public Builder serviceNamespace(String var1);

        public Builder serviceNamespace(ServiceNamespace var1);

        public Builder resourceId(String var1);

        public Builder scalableDimension(String var1);

        public Builder scalableDimension(ScalableDimension var1);

        public Builder policyType(String var1);

        public Builder policyType(PolicyType var1);

        public Builder stepScalingPolicyConfiguration(StepScalingPolicyConfiguration var1);

        default public Builder stepScalingPolicyConfiguration(Consumer<StepScalingPolicyConfiguration.Builder> stepScalingPolicyConfiguration) {
            return this.stepScalingPolicyConfiguration((StepScalingPolicyConfiguration)((StepScalingPolicyConfiguration.Builder)StepScalingPolicyConfiguration.builder().applyMutation(stepScalingPolicyConfiguration)).build());
        }

        public Builder targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfiguration var1);

        default public Builder targetTrackingScalingPolicyConfiguration(Consumer<TargetTrackingScalingPolicyConfiguration.Builder> targetTrackingScalingPolicyConfiguration) {
            return this.targetTrackingScalingPolicyConfiguration((TargetTrackingScalingPolicyConfiguration)((TargetTrackingScalingPolicyConfiguration.Builder)TargetTrackingScalingPolicyConfiguration.builder().applyMutation(targetTrackingScalingPolicyConfiguration)).build());
        }

        public Builder alarms(Collection<Alarm> var1);

        public Builder alarms(Alarm ... var1);

        public Builder alarms(Consumer<Alarm.Builder> ... var1);

        public Builder creationTime(Instant var1);
    }
}

