/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationautoscaling.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies whether the scaling activities for a scalable target are in a suspended state.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuspendedState implements SdkPojo, Serializable, ToCopyableBuilder<SuspendedState.Builder, SuspendedState> {
    private static final SdkField<Boolean> DYNAMIC_SCALING_IN_SUSPENDED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("DynamicScalingInSuspended")
            .getter(getter(SuspendedState::dynamicScalingInSuspended)).setter(setter(Builder::dynamicScalingInSuspended))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamicScalingInSuspended").build())
            .build();

    private static final SdkField<Boolean> DYNAMIC_SCALING_OUT_SUSPENDED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DynamicScalingOutSuspended")
            .getter(getter(SuspendedState::dynamicScalingOutSuspended))
            .setter(setter(Builder::dynamicScalingOutSuspended))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamicScalingOutSuspended").build())
            .build();

    private static final SdkField<Boolean> SCHEDULED_SCALING_SUSPENDED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("ScheduledScalingSuspended")
            .getter(getter(SuspendedState::scheduledScalingSuspended)).setter(setter(Builder::scheduledScalingSuspended))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledScalingSuspended").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DYNAMIC_SCALING_IN_SUSPENDED_FIELD, DYNAMIC_SCALING_OUT_SUSPENDED_FIELD, SCHEDULED_SCALING_SUSPENDED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean dynamicScalingInSuspended;

    private final Boolean dynamicScalingOutSuspended;

    private final Boolean scheduledScalingSuspended;

    private SuspendedState(BuilderImpl builder) {
        this.dynamicScalingInSuspended = builder.dynamicScalingInSuspended;
        this.dynamicScalingOutSuspended = builder.dynamicScalingOutSuspended;
        this.scheduledScalingSuspended = builder.scheduledScalingSuspended;
    }

    /**
     * <p>
     * Whether scale in by a target tracking scaling policy or a step scaling policy is suspended. Set the value to
     * <code>true</code> if you don't want Application Auto Scaling to remove capacity when a scaling policy is
     * triggered. The default is <code>false</code>.
     * </p>
     * 
     * @return Whether scale in by a target tracking scaling policy or a step scaling policy is suspended. Set the value
     *         to <code>true</code> if you don't want Application Auto Scaling to remove capacity when a scaling policy
     *         is triggered. The default is <code>false</code>.
     */
    public final Boolean dynamicScalingInSuspended() {
        return dynamicScalingInSuspended;
    }

    /**
     * <p>
     * Whether scale out by a target tracking scaling policy or a step scaling policy is suspended. Set the value to
     * <code>true</code> if you don't want Application Auto Scaling to add capacity when a scaling policy is triggered.
     * The default is <code>false</code>.
     * </p>
     * 
     * @return Whether scale out by a target tracking scaling policy or a step scaling policy is suspended. Set the
     *         value to <code>true</code> if you don't want Application Auto Scaling to add capacity when a scaling
     *         policy is triggered. The default is <code>false</code>.
     */
    public final Boolean dynamicScalingOutSuspended() {
        return dynamicScalingOutSuspended;
    }

    /**
     * <p>
     * Whether scheduled scaling is suspended. Set the value to <code>true</code> if you don't want Application Auto
     * Scaling to add or remove capacity by initiating scheduled actions. The default is <code>false</code>.
     * </p>
     * 
     * @return Whether scheduled scaling is suspended. Set the value to <code>true</code> if you don't want Application
     *         Auto Scaling to add or remove capacity by initiating scheduled actions. The default is <code>false</code>
     *         .
     */
    public final Boolean scheduledScalingSuspended() {
        return scheduledScalingSuspended;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dynamicScalingInSuspended());
        hashCode = 31 * hashCode + Objects.hashCode(dynamicScalingOutSuspended());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledScalingSuspended());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuspendedState)) {
            return false;
        }
        SuspendedState other = (SuspendedState) obj;
        return Objects.equals(dynamicScalingInSuspended(), other.dynamicScalingInSuspended())
                && Objects.equals(dynamicScalingOutSuspended(), other.dynamicScalingOutSuspended())
                && Objects.equals(scheduledScalingSuspended(), other.scheduledScalingSuspended());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SuspendedState").add("DynamicScalingInSuspended", dynamicScalingInSuspended())
                .add("DynamicScalingOutSuspended", dynamicScalingOutSuspended())
                .add("ScheduledScalingSuspended", scheduledScalingSuspended()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DynamicScalingInSuspended":
            return Optional.ofNullable(clazz.cast(dynamicScalingInSuspended()));
        case "DynamicScalingOutSuspended":
            return Optional.ofNullable(clazz.cast(dynamicScalingOutSuspended()));
        case "ScheduledScalingSuspended":
            return Optional.ofNullable(clazz.cast(scheduledScalingSuspended()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuspendedState, T> g) {
        return obj -> g.apply((SuspendedState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SuspendedState> {
        /**
         * <p>
         * Whether scale in by a target tracking scaling policy or a step scaling policy is suspended. Set the value to
         * <code>true</code> if you don't want Application Auto Scaling to remove capacity when a scaling policy is
         * triggered. The default is <code>false</code>.
         * </p>
         * 
         * @param dynamicScalingInSuspended
         *        Whether scale in by a target tracking scaling policy or a step scaling policy is suspended. Set the
         *        value to <code>true</code> if you don't want Application Auto Scaling to remove capacity when a
         *        scaling policy is triggered. The default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamicScalingInSuspended(Boolean dynamicScalingInSuspended);

        /**
         * <p>
         * Whether scale out by a target tracking scaling policy or a step scaling policy is suspended. Set the value to
         * <code>true</code> if you don't want Application Auto Scaling to add capacity when a scaling policy is
         * triggered. The default is <code>false</code>.
         * </p>
         * 
         * @param dynamicScalingOutSuspended
         *        Whether scale out by a target tracking scaling policy or a step scaling policy is suspended. Set the
         *        value to <code>true</code> if you don't want Application Auto Scaling to add capacity when a scaling
         *        policy is triggered. The default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamicScalingOutSuspended(Boolean dynamicScalingOutSuspended);

        /**
         * <p>
         * Whether scheduled scaling is suspended. Set the value to <code>true</code> if you don't want Application Auto
         * Scaling to add or remove capacity by initiating scheduled actions. The default is <code>false</code>.
         * </p>
         * 
         * @param scheduledScalingSuspended
         *        Whether scheduled scaling is suspended. Set the value to <code>true</code> if you don't want
         *        Application Auto Scaling to add or remove capacity by initiating scheduled actions. The default is
         *        <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledScalingSuspended(Boolean scheduledScalingSuspended);
    }

    static final class BuilderImpl implements Builder {
        private Boolean dynamicScalingInSuspended;

        private Boolean dynamicScalingOutSuspended;

        private Boolean scheduledScalingSuspended;

        private BuilderImpl() {
        }

        private BuilderImpl(SuspendedState model) {
            dynamicScalingInSuspended(model.dynamicScalingInSuspended);
            dynamicScalingOutSuspended(model.dynamicScalingOutSuspended);
            scheduledScalingSuspended(model.scheduledScalingSuspended);
        }

        public final Boolean getDynamicScalingInSuspended() {
            return dynamicScalingInSuspended;
        }

        public final void setDynamicScalingInSuspended(Boolean dynamicScalingInSuspended) {
            this.dynamicScalingInSuspended = dynamicScalingInSuspended;
        }

        @Override
        @Transient
        public final Builder dynamicScalingInSuspended(Boolean dynamicScalingInSuspended) {
            this.dynamicScalingInSuspended = dynamicScalingInSuspended;
            return this;
        }

        public final Boolean getDynamicScalingOutSuspended() {
            return dynamicScalingOutSuspended;
        }

        public final void setDynamicScalingOutSuspended(Boolean dynamicScalingOutSuspended) {
            this.dynamicScalingOutSuspended = dynamicScalingOutSuspended;
        }

        @Override
        @Transient
        public final Builder dynamicScalingOutSuspended(Boolean dynamicScalingOutSuspended) {
            this.dynamicScalingOutSuspended = dynamicScalingOutSuspended;
            return this;
        }

        public final Boolean getScheduledScalingSuspended() {
            return scheduledScalingSuspended;
        }

        public final void setScheduledScalingSuspended(Boolean scheduledScalingSuspended) {
            this.scheduledScalingSuspended = scheduledScalingSuspended;
        }

        @Override
        @Transient
        public final Builder scheduledScalingSuspended(Boolean scheduledScalingSuspended) {
            this.scheduledScalingSuspended = scheduledScalingSuspended;
            return this;
        }

        @Override
        public SuspendedState build() {
            return new SuspendedState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
