/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServiceNamespace {
    ECS("ecs"),
    ELASTICMAPREDUCE("elasticmapreduce"),
    EC2("ec2"),
    APPSTREAM("appstream"),
    DYNAMODB("dynamodb"),
    RDS("rds"),
    SAGEMAKER("sagemaker"),
    CUSTOM_RESOURCE("custom-resource"),
    COMPREHEND("comprehend"),
    LAMBDA("lambda"),
    CASSANDRA("cassandra"),
    KAFKA("kafka"),
    ELASTICACHE("elasticache"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServiceNamespace> VALUE_MAP;
    private final String value;

    private ServiceNamespace(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServiceNamespace fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServiceNamespace> knownValues() {
        EnumSet<ServiceNamespace> knownValues = EnumSet.allOf(ServiceNamespace.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServiceNamespace.class, ServiceNamespace::toString);
    }
}

