/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MetricType {
    DYNAMO_DB_READ_CAPACITY_UTILIZATION("DynamoDBReadCapacityUtilization"),
    DYNAMO_DB_WRITE_CAPACITY_UTILIZATION("DynamoDBWriteCapacityUtilization"),
    ALB_REQUEST_COUNT_PER_TARGET("ALBRequestCountPerTarget"),
    RDS_READER_AVERAGE_CPU_UTILIZATION("RDSReaderAverageCPUUtilization"),
    RDS_READER_AVERAGE_DATABASE_CONNECTIONS("RDSReaderAverageDatabaseConnections"),
    EC2_SPOT_FLEET_REQUEST_AVERAGE_CPU_UTILIZATION("EC2SpotFleetRequestAverageCPUUtilization"),
    EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_IN("EC2SpotFleetRequestAverageNetworkIn"),
    EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_OUT("EC2SpotFleetRequestAverageNetworkOut"),
    SAGE_MAKER_VARIANT_INVOCATIONS_PER_INSTANCE("SageMakerVariantInvocationsPerInstance"),
    ECS_SERVICE_AVERAGE_CPU_UTILIZATION("ECSServiceAverageCPUUtilization"),
    ECS_SERVICE_AVERAGE_MEMORY_UTILIZATION("ECSServiceAverageMemoryUtilization"),
    APP_STREAM_AVERAGE_CAPACITY_UTILIZATION("AppStreamAverageCapacityUtilization"),
    COMPREHEND_INFERENCE_UTILIZATION("ComprehendInferenceUtilization"),
    LAMBDA_PROVISIONED_CONCURRENCY_UTILIZATION("LambdaProvisionedConcurrencyUtilization"),
    CASSANDRA_READ_CAPACITY_UTILIZATION("CassandraReadCapacityUtilization"),
    CASSANDRA_WRITE_CAPACITY_UTILIZATION("CassandraWriteCapacityUtilization"),
    KAFKA_BROKER_STORAGE_UTILIZATION("KafkaBrokerStorageUtilization"),
    ELASTI_CACHE_PRIMARY_ENGINE_CPU_UTILIZATION("ElastiCachePrimaryEngineCPUUtilization"),
    ELASTI_CACHE_REPLICA_ENGINE_CPU_UTILIZATION("ElastiCacheReplicaEngineCPUUtilization"),
    ELASTI_CACHE_DATABASE_MEMORY_USAGE_COUNTED_FOR_EVICT_PERCENTAGE("ElastiCacheDatabaseMemoryUsageCountedForEvictPercentage"),
    NEPTUNE_READER_AVERAGE_CPU_UTILIZATION("NeptuneReaderAverageCPUUtilization"),
    SAGE_MAKER_VARIANT_PROVISIONED_CONCURRENCY_UTILIZATION("SageMakerVariantProvisionedConcurrencyUtilization"),
    ELASTI_CACHE_DATABASE_CAPACITY_USAGE_COUNTED_FOR_EVICT_PERCENTAGE("ElastiCacheDatabaseCapacityUsageCountedForEvictPercentage"),
    SAGE_MAKER_INFERENCE_COMPONENT_INVOCATIONS_PER_COPY("SageMakerInferenceComponentInvocationsPerCopy"),
    WORK_SPACES_AVERAGE_USER_SESSIONS_CAPACITY_UTILIZATION("WorkSpacesAverageUserSessionsCapacityUtilization"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MetricType> VALUE_MAP;
    private final String value;

    private MetricType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MetricType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MetricType> knownValues() {
        EnumSet<MetricType> knownValues = EnumSet.allOf(MetricType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MetricType.class, MetricType::toString);
    }
}

