/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ScalingPoliciesCopier {
    static List<ScalingPolicy> copy(Collection<? extends ScalingPolicy> scalingPoliciesParam) {
        List<ScalingPolicy> list;
        if (scalingPoliciesParam == null || scalingPoliciesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ScalingPolicy> modifiableList = new ArrayList<>(scalingPoliciesParam.size());
            scalingPoliciesParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ScalingPolicy> copyFromBuilder(Collection<? extends ScalingPolicy.Builder> scalingPoliciesParam) {
        List<ScalingPolicy> list;
        if (scalingPoliciesParam == null || scalingPoliciesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ScalingPolicy> modifiableList = new ArrayList<>(scalingPoliciesParam.size());
            scalingPoliciesParam.forEach(entry -> {
                ScalingPolicy member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ScalingPolicy.Builder> copyToBuilder(Collection<? extends ScalingPolicy> scalingPoliciesParam) {
        List<ScalingPolicy.Builder> list;
        if (scalingPoliciesParam == null || scalingPoliciesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ScalingPolicy.Builder> modifiableList = new ArrayList<>(scalingPoliciesParam.size());
            scalingPoliciesParam.forEach(entry -> {
                ScalingPolicy.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
