/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationautoscaling.model.PredictiveScalingMetricDimension;
import software.amazon.awssdk.services.applicationautoscaling.model.PredictiveScalingMetricDimensionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PredictiveScalingMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PredictiveScalingMetric> {
    private static final SdkField<List<PredictiveScalingMetricDimension>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Dimensions").getter(PredictiveScalingMetric.getter(PredictiveScalingMetric::dimensions)).setter(PredictiveScalingMetric.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PredictiveScalingMetricDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(PredictiveScalingMetric.getter(PredictiveScalingMetric::metricName)).setter(PredictiveScalingMetric.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(PredictiveScalingMetric.getter(PredictiveScalingMetric::namespace)).setter(PredictiveScalingMetric.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD, METRIC_NAME_FIELD, NAMESPACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Dimensions", DIMENSIONS_FIELD);
            this.put("MetricName", METRIC_NAME_FIELD);
            this.put("Namespace", NAMESPACE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<PredictiveScalingMetricDimension> dimensions;
    private final String metricName;
    private final String namespace;

    private PredictiveScalingMetric(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.metricName = builder.metricName;
        this.namespace = builder.namespace;
    }

    public final boolean hasDimensions() {
        return this.dimensions != null && !(this.dimensions instanceof SdkAutoConstructList);
    }

    public final List<PredictiveScalingMetricDimension> dimensions() {
        return this.dimensions;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final String namespace() {
        return this.namespace;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensions() ? this.dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictiveScalingMetric)) {
            return false;
        }
        PredictiveScalingMetric other = (PredictiveScalingMetric)obj;
        return this.hasDimensions() == other.hasDimensions() && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.namespace(), other.namespace());
    }

    public final String toString() {
        return ToString.builder((String)"PredictiveScalingMetric").add("Dimensions", this.hasDimensions() ? this.dimensions() : null).add("MetricName", (Object)this.metricName()).add("Namespace", (Object)this.namespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PredictiveScalingMetric, T> g) {
        return obj -> g.apply((PredictiveScalingMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PredictiveScalingMetricDimension> dimensions = DefaultSdkAutoConstructList.getInstance();
        private String metricName;
        private String namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictiveScalingMetric model) {
            this.dimensions(model.dimensions);
            this.metricName(model.metricName);
            this.namespace(model.namespace);
        }

        public final List<PredictiveScalingMetricDimension.Builder> getDimensions() {
            List<PredictiveScalingMetricDimension.Builder> result = PredictiveScalingMetricDimensionsCopier.copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensions(Collection<PredictiveScalingMetricDimension.BuilderImpl> dimensions) {
            this.dimensions = PredictiveScalingMetricDimensionsCopier.copyFromBuilder(dimensions);
        }

        @Override
        public final Builder dimensions(Collection<PredictiveScalingMetricDimension> dimensions) {
            this.dimensions = PredictiveScalingMetricDimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(PredictiveScalingMetricDimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<PredictiveScalingMetricDimension.Builder> ... dimensions) {
            this.dimensions(Stream.of(dimensions).map(c -> (PredictiveScalingMetricDimension)((PredictiveScalingMetricDimension.Builder)PredictiveScalingMetricDimension.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PredictiveScalingMetric build() {
            return new PredictiveScalingMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PredictiveScalingMetric> {
        public Builder dimensions(Collection<PredictiveScalingMetricDimension> var1);

        public Builder dimensions(PredictiveScalingMetricDimension ... var1);

        public Builder dimensions(Consumer<PredictiveScalingMetricDimension.Builder> ... var1);

        public Builder metricName(String var1);

        public Builder namespace(String var1);
    }
}

