/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationautoscaling.model.Alarm;
import software.amazon.awssdk.services.applicationautoscaling.model.AlarmsCopier;
import software.amazon.awssdk.services.applicationautoscaling.model.PolicyType;
import software.amazon.awssdk.services.applicationautoscaling.model.PredictiveScalingPolicyConfiguration;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension;
import software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace;
import software.amazon.awssdk.services.applicationautoscaling.model.StepScalingPolicyConfiguration;
import software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScalingPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScalingPolicy> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyARN").getter(ScalingPolicy.getter(ScalingPolicy::policyARN)).setter(ScalingPolicy.setter(Builder::policyARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyARN").build()}).build();
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyName").getter(ScalingPolicy.getter(ScalingPolicy::policyName)).setter(ScalingPolicy.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()}).build();
    private static final SdkField<String> SERVICE_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceNamespace").getter(ScalingPolicy.getter(ScalingPolicy::serviceNamespaceAsString)).setter(ScalingPolicy.setter(Builder::serviceNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNamespace").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(ScalingPolicy.getter(ScalingPolicy::resourceId)).setter(ScalingPolicy.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> SCALABLE_DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalableDimension").getter(ScalingPolicy.getter(ScalingPolicy::scalableDimensionAsString)).setter(ScalingPolicy.setter(Builder::scalableDimension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalableDimension").build()}).build();
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyType").getter(ScalingPolicy.getter(ScalingPolicy::policyTypeAsString)).setter(ScalingPolicy.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()}).build();
    private static final SdkField<StepScalingPolicyConfiguration> STEP_SCALING_POLICY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StepScalingPolicyConfiguration").getter(ScalingPolicy.getter(ScalingPolicy::stepScalingPolicyConfiguration)).setter(ScalingPolicy.setter(Builder::stepScalingPolicyConfiguration)).constructor(StepScalingPolicyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepScalingPolicyConfiguration").build()}).build();
    private static final SdkField<TargetTrackingScalingPolicyConfiguration> TARGET_TRACKING_SCALING_POLICY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetTrackingScalingPolicyConfiguration").getter(ScalingPolicy.getter(ScalingPolicy::targetTrackingScalingPolicyConfiguration)).setter(ScalingPolicy.setter(Builder::targetTrackingScalingPolicyConfiguration)).constructor(TargetTrackingScalingPolicyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTrackingScalingPolicyConfiguration").build()}).build();
    private static final SdkField<PredictiveScalingPolicyConfiguration> PREDICTIVE_SCALING_POLICY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PredictiveScalingPolicyConfiguration").getter(ScalingPolicy.getter(ScalingPolicy::predictiveScalingPolicyConfiguration)).setter(ScalingPolicy.setter(Builder::predictiveScalingPolicyConfiguration)).constructor(PredictiveScalingPolicyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictiveScalingPolicyConfiguration").build()}).build();
    private static final SdkField<List<Alarm>> ALARMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Alarms").getter(ScalingPolicy.getter(ScalingPolicy::alarms)).setter(ScalingPolicy.setter(Builder::alarms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alarms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Alarm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ScalingPolicy.getter(ScalingPolicy::creationTime)).setter(ScalingPolicy.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD, POLICY_NAME_FIELD, SERVICE_NAMESPACE_FIELD, RESOURCE_ID_FIELD, SCALABLE_DIMENSION_FIELD, POLICY_TYPE_FIELD, STEP_SCALING_POLICY_CONFIGURATION_FIELD, TARGET_TRACKING_SCALING_POLICY_CONFIGURATION_FIELD, PREDICTIVE_SCALING_POLICY_CONFIGURATION_FIELD, ALARMS_FIELD, CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PolicyARN", POLICY_ARN_FIELD);
            this.put("PolicyName", POLICY_NAME_FIELD);
            this.put("ServiceNamespace", SERVICE_NAMESPACE_FIELD);
            this.put("ResourceId", RESOURCE_ID_FIELD);
            this.put("ScalableDimension", SCALABLE_DIMENSION_FIELD);
            this.put("PolicyType", POLICY_TYPE_FIELD);
            this.put("StepScalingPolicyConfiguration", STEP_SCALING_POLICY_CONFIGURATION_FIELD);
            this.put("TargetTrackingScalingPolicyConfiguration", TARGET_TRACKING_SCALING_POLICY_CONFIGURATION_FIELD);
            this.put("PredictiveScalingPolicyConfiguration", PREDICTIVE_SCALING_POLICY_CONFIGURATION_FIELD);
            this.put("Alarms", ALARMS_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String policyARN;
    private final String policyName;
    private final String serviceNamespace;
    private final String resourceId;
    private final String scalableDimension;
    private final String policyType;
    private final StepScalingPolicyConfiguration stepScalingPolicyConfiguration;
    private final TargetTrackingScalingPolicyConfiguration targetTrackingScalingPolicyConfiguration;
    private final PredictiveScalingPolicyConfiguration predictiveScalingPolicyConfiguration;
    private final List<Alarm> alarms;
    private final Instant creationTime;

    private ScalingPolicy(BuilderImpl builder) {
        this.policyARN = builder.policyARN;
        this.policyName = builder.policyName;
        this.serviceNamespace = builder.serviceNamespace;
        this.resourceId = builder.resourceId;
        this.scalableDimension = builder.scalableDimension;
        this.policyType = builder.policyType;
        this.stepScalingPolicyConfiguration = builder.stepScalingPolicyConfiguration;
        this.targetTrackingScalingPolicyConfiguration = builder.targetTrackingScalingPolicyConfiguration;
        this.predictiveScalingPolicyConfiguration = builder.predictiveScalingPolicyConfiguration;
        this.alarms = builder.alarms;
        this.creationTime = builder.creationTime;
    }

    public final String policyARN() {
        return this.policyARN;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final ServiceNamespace serviceNamespace() {
        return ServiceNamespace.fromValue(this.serviceNamespace);
    }

    public final String serviceNamespaceAsString() {
        return this.serviceNamespace;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final ScalableDimension scalableDimension() {
        return ScalableDimension.fromValue(this.scalableDimension);
    }

    public final String scalableDimensionAsString() {
        return this.scalableDimension;
    }

    public final PolicyType policyType() {
        return PolicyType.fromValue(this.policyType);
    }

    public final String policyTypeAsString() {
        return this.policyType;
    }

    public final StepScalingPolicyConfiguration stepScalingPolicyConfiguration() {
        return this.stepScalingPolicyConfiguration;
    }

    public final TargetTrackingScalingPolicyConfiguration targetTrackingScalingPolicyConfiguration() {
        return this.targetTrackingScalingPolicyConfiguration;
    }

    public final PredictiveScalingPolicyConfiguration predictiveScalingPolicyConfiguration() {
        return this.predictiveScalingPolicyConfiguration;
    }

    public final boolean hasAlarms() {
        return this.alarms != null && !(this.alarms instanceof SdkAutoConstructList);
    }

    public final List<Alarm> alarms() {
        return this.alarms;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNamespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalableDimensionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepScalingPolicyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTrackingScalingPolicyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictiveScalingPolicyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlarms() ? this.alarms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingPolicy)) {
            return false;
        }
        ScalingPolicy other = (ScalingPolicy)obj;
        return Objects.equals(this.policyARN(), other.policyARN()) && Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.serviceNamespaceAsString(), other.serviceNamespaceAsString()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.scalableDimensionAsString(), other.scalableDimensionAsString()) && Objects.equals(this.policyTypeAsString(), other.policyTypeAsString()) && Objects.equals(this.stepScalingPolicyConfiguration(), other.stepScalingPolicyConfiguration()) && Objects.equals(this.targetTrackingScalingPolicyConfiguration(), other.targetTrackingScalingPolicyConfiguration()) && Objects.equals(this.predictiveScalingPolicyConfiguration(), other.predictiveScalingPolicyConfiguration()) && this.hasAlarms() == other.hasAlarms() && Objects.equals(this.alarms(), other.alarms()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"ScalingPolicy").add("PolicyARN", (Object)this.policyARN()).add("PolicyName", (Object)this.policyName()).add("ServiceNamespace", (Object)this.serviceNamespaceAsString()).add("ResourceId", (Object)this.resourceId()).add("ScalableDimension", (Object)this.scalableDimensionAsString()).add("PolicyType", (Object)this.policyTypeAsString()).add("StepScalingPolicyConfiguration", (Object)this.stepScalingPolicyConfiguration()).add("TargetTrackingScalingPolicyConfiguration", (Object)this.targetTrackingScalingPolicyConfiguration()).add("PredictiveScalingPolicyConfiguration", (Object)this.predictiveScalingPolicyConfiguration()).add("Alarms", this.hasAlarms() ? this.alarms() : null).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyARN": {
                return Optional.ofNullable(clazz.cast(this.policyARN()));
            }
            case "PolicyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "ServiceNamespace": {
                return Optional.ofNullable(clazz.cast(this.serviceNamespaceAsString()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ScalableDimension": {
                return Optional.ofNullable(clazz.cast(this.scalableDimensionAsString()));
            }
            case "PolicyType": {
                return Optional.ofNullable(clazz.cast(this.policyTypeAsString()));
            }
            case "StepScalingPolicyConfiguration": {
                return Optional.ofNullable(clazz.cast(this.stepScalingPolicyConfiguration()));
            }
            case "TargetTrackingScalingPolicyConfiguration": {
                return Optional.ofNullable(clazz.cast(this.targetTrackingScalingPolicyConfiguration()));
            }
            case "PredictiveScalingPolicyConfiguration": {
                return Optional.ofNullable(clazz.cast(this.predictiveScalingPolicyConfiguration()));
            }
            case "Alarms": {
                return Optional.ofNullable(clazz.cast(this.alarms()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ScalingPolicy, T> g) {
        return obj -> g.apply((ScalingPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyARN;
        private String policyName;
        private String serviceNamespace;
        private String resourceId;
        private String scalableDimension;
        private String policyType;
        private StepScalingPolicyConfiguration stepScalingPolicyConfiguration;
        private TargetTrackingScalingPolicyConfiguration targetTrackingScalingPolicyConfiguration;
        private PredictiveScalingPolicyConfiguration predictiveScalingPolicyConfiguration;
        private List<Alarm> alarms = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingPolicy model) {
            this.policyARN(model.policyARN);
            this.policyName(model.policyName);
            this.serviceNamespace(model.serviceNamespace);
            this.resourceId(model.resourceId);
            this.scalableDimension(model.scalableDimension);
            this.policyType(model.policyType);
            this.stepScalingPolicyConfiguration(model.stepScalingPolicyConfiguration);
            this.targetTrackingScalingPolicyConfiguration(model.targetTrackingScalingPolicyConfiguration);
            this.predictiveScalingPolicyConfiguration(model.predictiveScalingPolicyConfiguration);
            this.alarms(model.alarms);
            this.creationTime(model.creationTime);
        }

        public final String getPolicyARN() {
            return this.policyARN;
        }

        public final void setPolicyARN(String policyARN) {
            this.policyARN = policyARN;
        }

        @Override
        public final Builder policyARN(String policyARN) {
            this.policyARN = policyARN;
            return this;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getServiceNamespace() {
            return this.serviceNamespace;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        @Override
        public final Builder serviceNamespace(ServiceNamespace serviceNamespace) {
            this.serviceNamespace(serviceNamespace == null ? null : serviceNamespace.toString());
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getScalableDimension() {
            return this.scalableDimension;
        }

        public final void setScalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
        }

        @Override
        public final Builder scalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
            return this;
        }

        @Override
        public final Builder scalableDimension(ScalableDimension scalableDimension) {
            this.scalableDimension(scalableDimension == null ? null : scalableDimension.toString());
            return this;
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final StepScalingPolicyConfiguration.Builder getStepScalingPolicyConfiguration() {
            return this.stepScalingPolicyConfiguration != null ? this.stepScalingPolicyConfiguration.toBuilder() : null;
        }

        public final void setStepScalingPolicyConfiguration(StepScalingPolicyConfiguration.BuilderImpl stepScalingPolicyConfiguration) {
            this.stepScalingPolicyConfiguration = stepScalingPolicyConfiguration != null ? stepScalingPolicyConfiguration.build() : null;
        }

        @Override
        public final Builder stepScalingPolicyConfiguration(StepScalingPolicyConfiguration stepScalingPolicyConfiguration) {
            this.stepScalingPolicyConfiguration = stepScalingPolicyConfiguration;
            return this;
        }

        public final TargetTrackingScalingPolicyConfiguration.Builder getTargetTrackingScalingPolicyConfiguration() {
            return this.targetTrackingScalingPolicyConfiguration != null ? this.targetTrackingScalingPolicyConfiguration.toBuilder() : null;
        }

        public final void setTargetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfiguration.BuilderImpl targetTrackingScalingPolicyConfiguration) {
            this.targetTrackingScalingPolicyConfiguration = targetTrackingScalingPolicyConfiguration != null ? targetTrackingScalingPolicyConfiguration.build() : null;
        }

        @Override
        public final Builder targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfiguration targetTrackingScalingPolicyConfiguration) {
            this.targetTrackingScalingPolicyConfiguration = targetTrackingScalingPolicyConfiguration;
            return this;
        }

        public final PredictiveScalingPolicyConfiguration.Builder getPredictiveScalingPolicyConfiguration() {
            return this.predictiveScalingPolicyConfiguration != null ? this.predictiveScalingPolicyConfiguration.toBuilder() : null;
        }

        public final void setPredictiveScalingPolicyConfiguration(PredictiveScalingPolicyConfiguration.BuilderImpl predictiveScalingPolicyConfiguration) {
            this.predictiveScalingPolicyConfiguration = predictiveScalingPolicyConfiguration != null ? predictiveScalingPolicyConfiguration.build() : null;
        }

        @Override
        public final Builder predictiveScalingPolicyConfiguration(PredictiveScalingPolicyConfiguration predictiveScalingPolicyConfiguration) {
            this.predictiveScalingPolicyConfiguration = predictiveScalingPolicyConfiguration;
            return this;
        }

        public final List<Alarm.Builder> getAlarms() {
            List<Alarm.Builder> result = AlarmsCopier.copyToBuilder(this.alarms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlarms(Collection<Alarm.BuilderImpl> alarms) {
            this.alarms = AlarmsCopier.copyFromBuilder(alarms);
        }

        @Override
        public final Builder alarms(Collection<Alarm> alarms) {
            this.alarms = AlarmsCopier.copy(alarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(Alarm ... alarms) {
            this.alarms(Arrays.asList(alarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(Consumer<Alarm.Builder> ... alarms) {
            this.alarms(Stream.of(alarms).map(c -> (Alarm)((Alarm.Builder)Alarm.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public ScalingPolicy build() {
            return new ScalingPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScalingPolicy> {
        public Builder policyARN(String var1);

        public Builder policyName(String var1);

        public Builder serviceNamespace(String var1);

        public Builder serviceNamespace(ServiceNamespace var1);

        public Builder resourceId(String var1);

        public Builder scalableDimension(String var1);

        public Builder scalableDimension(ScalableDimension var1);

        public Builder policyType(String var1);

        public Builder policyType(PolicyType var1);

        public Builder stepScalingPolicyConfiguration(StepScalingPolicyConfiguration var1);

        default public Builder stepScalingPolicyConfiguration(Consumer<StepScalingPolicyConfiguration.Builder> stepScalingPolicyConfiguration) {
            return this.stepScalingPolicyConfiguration((StepScalingPolicyConfiguration)((StepScalingPolicyConfiguration.Builder)StepScalingPolicyConfiguration.builder().applyMutation(stepScalingPolicyConfiguration)).build());
        }

        public Builder targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfiguration var1);

        default public Builder targetTrackingScalingPolicyConfiguration(Consumer<TargetTrackingScalingPolicyConfiguration.Builder> targetTrackingScalingPolicyConfiguration) {
            return this.targetTrackingScalingPolicyConfiguration((TargetTrackingScalingPolicyConfiguration)((TargetTrackingScalingPolicyConfiguration.Builder)TargetTrackingScalingPolicyConfiguration.builder().applyMutation(targetTrackingScalingPolicyConfiguration)).build());
        }

        public Builder predictiveScalingPolicyConfiguration(PredictiveScalingPolicyConfiguration var1);

        default public Builder predictiveScalingPolicyConfiguration(Consumer<PredictiveScalingPolicyConfiguration.Builder> predictiveScalingPolicyConfiguration) {
            return this.predictiveScalingPolicyConfiguration((PredictiveScalingPolicyConfiguration)((PredictiveScalingPolicyConfiguration.Builder)PredictiveScalingPolicyConfiguration.builder().applyMutation(predictiveScalingPolicyConfiguration)).build());
        }

        public Builder alarms(Collection<Alarm> var1);

        public Builder alarms(Alarm ... var1);

        public Builder alarms(Consumer<Alarm.Builder> ... var1);

        public Builder creationTime(Instant var1);
    }
}

