/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationautoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metric data to return. Also defines whether this call is returning data for one metric only, or whether it is
 * performing a math expression on the values of returned metric statistics to create a new time series. A time series
 * is a series of data points, each of which is associated with a timestamp.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredictiveScalingMetricDataQuery implements SdkPojo, Serializable,
        ToCopyableBuilder<PredictiveScalingMetricDataQuery.Builder, PredictiveScalingMetricDataQuery> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(PredictiveScalingMetricDataQuery::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Expression").getter(getter(PredictiveScalingMetricDataQuery::expression))
            .setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()).build();

    private static final SdkField<PredictiveScalingMetricStat> METRIC_STAT_FIELD = SdkField
            .<PredictiveScalingMetricStat> builder(MarshallingType.SDK_POJO).memberName("MetricStat")
            .getter(getter(PredictiveScalingMetricDataQuery::metricStat)).setter(setter(Builder::metricStat))
            .constructor(PredictiveScalingMetricStat::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricStat").build()).build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Label")
            .getter(getter(PredictiveScalingMetricDataQuery::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final SdkField<Boolean> RETURN_DATA_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReturnData").getter(getter(PredictiveScalingMetricDataQuery::returnData))
            .setter(setter(Builder::returnData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, EXPRESSION_FIELD,
            METRIC_STAT_FIELD, LABEL_FIELD, RETURN_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String expression;

    private final PredictiveScalingMetricStat metricStat;

    private final String label;

    private final Boolean returnData;

    private PredictiveScalingMetricDataQuery(BuilderImpl builder) {
        this.id = builder.id;
        this.expression = builder.expression;
        this.metricStat = builder.metricStat;
        this.label = builder.label;
        this.returnData = builder.returnData;
    }

    /**
     * <p>
     * A short name that identifies the object's results in the response. This name must be unique among all
     * <code>MetricDataQuery</code> objects specified for a single scaling policy. If you are performing math
     * expressions on this set of data, this name represents that data and can serve as a variable in the mathematical
     * expression. The valid characters are letters, numbers, and underscores. The first character must be a lowercase
     * letter.
     * </p>
     * 
     * @return A short name that identifies the object's results in the response. This name must be unique among all
     *         <code>MetricDataQuery</code> objects specified for a single scaling policy. If you are performing math
     *         expressions on this set of data, this name represents that data and can serve as a variable in the
     *         mathematical expression. The valid characters are letters, numbers, and underscores. The first character
     *         must be a lowercase letter.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The math expression to perform on the returned data, if this object is performing a math expression. This
     * expression can use the <code>Id</code> of the other metrics to refer to those metrics, and can also use the
     * <code>Id</code> of other expressions to use the result of those expressions.
     * </p>
     * <p>
     * Conditional: Within each <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or
     * <code>MetricStat</code>, but not both.
     * </p>
     * 
     * @return The math expression to perform on the returned data, if this object is performing a math expression. This
     *         expression can use the <code>Id</code> of the other metrics to refer to those metrics, and can also use
     *         the <code>Id</code> of other expressions to use the result of those expressions. </p>
     *         <p>
     *         Conditional: Within each <code>MetricDataQuery</code> object, you must specify either
     *         <code>Expression</code> or <code>MetricStat</code>, but not both.
     */
    public final String expression() {
        return expression;
    }

    /**
     * <p>
     * Information about the metric data to return.
     * </p>
     * <p>
     * Conditional: Within each <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or
     * <code>MetricStat</code>, but not both.
     * </p>
     * 
     * @return Information about the metric data to return. </p>
     *         <p>
     *         Conditional: Within each <code>MetricDataQuery</code> object, you must specify either
     *         <code>Expression</code> or <code>MetricStat</code>, but not both.
     */
    public final PredictiveScalingMetricStat metricStat() {
        return metricStat;
    }

    /**
     * <p>
     * A human-readable label for this metric or expression. This is especially useful if this is a math expression, so
     * that you know what the value represents.
     * </p>
     * 
     * @return A human-readable label for this metric or expression. This is especially useful if this is a math
     *         expression, so that you know what the value represents.
     */
    public final String label() {
        return label;
    }

    /**
     * <p>
     * Indicates whether to return the timestamps and raw data values of this metric.
     * </p>
     * <p>
     * If you use any math expressions, specify <code>true</code> for this value for only the final math expression that
     * the metric specification is based on. You must specify <code>false</code> for <code>ReturnData</code> for all the
     * other metrics and expressions used in the metric specification.
     * </p>
     * <p>
     * If you are only retrieving metrics and not performing any math expressions, do not specify anything for
     * <code>ReturnData</code>. This sets it to its default (<code>true</code>).
     * </p>
     * 
     * @return Indicates whether to return the timestamps and raw data values of this metric. </p>
     *         <p>
     *         If you use any math expressions, specify <code>true</code> for this value for only the final math
     *         expression that the metric specification is based on. You must specify <code>false</code> for
     *         <code>ReturnData</code> for all the other metrics and expressions used in the metric specification.
     *         </p>
     *         <p>
     *         If you are only retrieving metrics and not performing any math expressions, do not specify anything for
     *         <code>ReturnData</code>. This sets it to its default (<code>true</code>).
     */
    public final Boolean returnData() {
        return returnData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(metricStat());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(returnData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictiveScalingMetricDataQuery)) {
            return false;
        }
        PredictiveScalingMetricDataQuery other = (PredictiveScalingMetricDataQuery) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(expression(), other.expression())
                && Objects.equals(metricStat(), other.metricStat()) && Objects.equals(label(), other.label())
                && Objects.equals(returnData(), other.returnData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PredictiveScalingMetricDataQuery").add("Id", id()).add("Expression", expression())
                .add("MetricStat", metricStat()).add("Label", label()).add("ReturnData", returnData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "MetricStat":
            return Optional.ofNullable(clazz.cast(metricStat()));
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        case "ReturnData":
            return Optional.ofNullable(clazz.cast(returnData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Expression", EXPRESSION_FIELD);
        map.put("MetricStat", METRIC_STAT_FIELD);
        map.put("Label", LABEL_FIELD);
        map.put("ReturnData", RETURN_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PredictiveScalingMetricDataQuery, T> g) {
        return obj -> g.apply((PredictiveScalingMetricDataQuery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PredictiveScalingMetricDataQuery> {
        /**
         * <p>
         * A short name that identifies the object's results in the response. This name must be unique among all
         * <code>MetricDataQuery</code> objects specified for a single scaling policy. If you are performing math
         * expressions on this set of data, this name represents that data and can serve as a variable in the
         * mathematical expression. The valid characters are letters, numbers, and underscores. The first character must
         * be a lowercase letter.
         * </p>
         * 
         * @param id
         *        A short name that identifies the object's results in the response. This name must be unique among all
         *        <code>MetricDataQuery</code> objects specified for a single scaling policy. If you are performing math
         *        expressions on this set of data, this name represents that data and can serve as a variable in the
         *        mathematical expression. The valid characters are letters, numbers, and underscores. The first
         *        character must be a lowercase letter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The math expression to perform on the returned data, if this object is performing a math expression. This
         * expression can use the <code>Id</code> of the other metrics to refer to those metrics, and can also use the
         * <code>Id</code> of other expressions to use the result of those expressions.
         * </p>
         * <p>
         * Conditional: Within each <code>MetricDataQuery</code> object, you must specify either <code>Expression</code>
         * or <code>MetricStat</code>, but not both.
         * </p>
         * 
         * @param expression
         *        The math expression to perform on the returned data, if this object is performing a math expression.
         *        This expression can use the <code>Id</code> of the other metrics to refer to those metrics, and can
         *        also use the <code>Id</code> of other expressions to use the result of those expressions. </p>
         *        <p>
         *        Conditional: Within each <code>MetricDataQuery</code> object, you must specify either
         *        <code>Expression</code> or <code>MetricStat</code>, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * Information about the metric data to return.
         * </p>
         * <p>
         * Conditional: Within each <code>MetricDataQuery</code> object, you must specify either <code>Expression</code>
         * or <code>MetricStat</code>, but not both.
         * </p>
         * 
         * @param metricStat
         *        Information about the metric data to return. </p>
         *        <p>
         *        Conditional: Within each <code>MetricDataQuery</code> object, you must specify either
         *        <code>Expression</code> or <code>MetricStat</code>, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricStat(PredictiveScalingMetricStat metricStat);

        /**
         * <p>
         * Information about the metric data to return.
         * </p>
         * <p>
         * Conditional: Within each <code>MetricDataQuery</code> object, you must specify either <code>Expression</code>
         * or <code>MetricStat</code>, but not both.
         * </p>
         * This is a convenience method that creates an instance of the {@link PredictiveScalingMetricStat.Builder}
         * avoiding the need to create one manually via {@link PredictiveScalingMetricStat#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PredictiveScalingMetricStat.Builder#build()} is called
         * immediately and its result is passed to {@link #metricStat(PredictiveScalingMetricStat)}.
         * 
         * @param metricStat
         *        a consumer that will call methods on {@link PredictiveScalingMetricStat.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricStat(PredictiveScalingMetricStat)
         */
        default Builder metricStat(Consumer<PredictiveScalingMetricStat.Builder> metricStat) {
            return metricStat(PredictiveScalingMetricStat.builder().applyMutation(metricStat).build());
        }

        /**
         * <p>
         * A human-readable label for this metric or expression. This is especially useful if this is a math expression,
         * so that you know what the value represents.
         * </p>
         * 
         * @param label
         *        A human-readable label for this metric or expression. This is especially useful if this is a math
         *        expression, so that you know what the value represents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * Indicates whether to return the timestamps and raw data values of this metric.
         * </p>
         * <p>
         * If you use any math expressions, specify <code>true</code> for this value for only the final math expression
         * that the metric specification is based on. You must specify <code>false</code> for <code>ReturnData</code>
         * for all the other metrics and expressions used in the metric specification.
         * </p>
         * <p>
         * If you are only retrieving metrics and not performing any math expressions, do not specify anything for
         * <code>ReturnData</code>. This sets it to its default (<code>true</code>).
         * </p>
         * 
         * @param returnData
         *        Indicates whether to return the timestamps and raw data values of this metric. </p>
         *        <p>
         *        If you use any math expressions, specify <code>true</code> for this value for only the final math
         *        expression that the metric specification is based on. You must specify <code>false</code> for
         *        <code>ReturnData</code> for all the other metrics and expressions used in the metric specification.
         *        </p>
         *        <p>
         *        If you are only retrieving metrics and not performing any math expressions, do not specify anything
         *        for <code>ReturnData</code>. This sets it to its default (<code>true</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnData(Boolean returnData);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String expression;

        private PredictiveScalingMetricStat metricStat;

        private String label;

        private Boolean returnData;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictiveScalingMetricDataQuery model) {
            id(model.id);
            expression(model.expression);
            metricStat(model.metricStat);
            label(model.label);
            returnData(model.returnData);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final PredictiveScalingMetricStat.Builder getMetricStat() {
            return metricStat != null ? metricStat.toBuilder() : null;
        }

        public final void setMetricStat(PredictiveScalingMetricStat.BuilderImpl metricStat) {
            this.metricStat = metricStat != null ? metricStat.build() : null;
        }

        @Override
        public final Builder metricStat(PredictiveScalingMetricStat metricStat) {
            this.metricStat = metricStat;
            return this;
        }

        public final String getLabel() {
            return label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final Boolean getReturnData() {
            return returnData;
        }

        public final void setReturnData(Boolean returnData) {
            this.returnData = returnData;
        }

        @Override
        public final Builder returnData(Boolean returnData) {
            this.returnData = returnData;
            return this;
        }

        @Override
        public PredictiveScalingMetricDataQuery build() {
            return new PredictiveScalingMetricDataQuery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
