/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationautoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure specifies the metrics and target utilization settings for a predictive scaling policy.
 * </p>
 * <p>
 * You must specify either a metric pair, or a load metric and a scaling metric individually. Specifying a metric pair
 * instead of individual metrics provides a simpler way to configure metrics for a scaling policy. You choose the metric
 * pair, and the policy automatically knows the correct sum and average statistics to use for the load metric and the
 * scaling metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredictiveScalingMetricSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<PredictiveScalingMetricSpecification.Builder, PredictiveScalingMetricSpecification> {
    private static final SdkField<Double> TARGET_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("TargetValue").getter(getter(PredictiveScalingMetricSpecification::targetValue))
            .setter(setter(Builder::targetValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetValue").build()).build();

    private static final SdkField<PredictiveScalingPredefinedMetricPairSpecification> PREDEFINED_METRIC_PAIR_SPECIFICATION_FIELD = SdkField
            .<PredictiveScalingPredefinedMetricPairSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("PredefinedMetricPairSpecification")
            .getter(getter(PredictiveScalingMetricSpecification::predefinedMetricPairSpecification))
            .setter(setter(Builder::predefinedMetricPairSpecification))
            .constructor(PredictiveScalingPredefinedMetricPairSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredefinedMetricPairSpecification")
                    .build()).build();

    private static final SdkField<PredictiveScalingPredefinedScalingMetricSpecification> PREDEFINED_SCALING_METRIC_SPECIFICATION_FIELD = SdkField
            .<PredictiveScalingPredefinedScalingMetricSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("PredefinedScalingMetricSpecification")
            .getter(getter(PredictiveScalingMetricSpecification::predefinedScalingMetricSpecification))
            .setter(setter(Builder::predefinedScalingMetricSpecification))
            .constructor(PredictiveScalingPredefinedScalingMetricSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("PredefinedScalingMetricSpecification").build()).build();

    private static final SdkField<PredictiveScalingPredefinedLoadMetricSpecification> PREDEFINED_LOAD_METRIC_SPECIFICATION_FIELD = SdkField
            .<PredictiveScalingPredefinedLoadMetricSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("PredefinedLoadMetricSpecification")
            .getter(getter(PredictiveScalingMetricSpecification::predefinedLoadMetricSpecification))
            .setter(setter(Builder::predefinedLoadMetricSpecification))
            .constructor(PredictiveScalingPredefinedLoadMetricSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredefinedLoadMetricSpecification")
                    .build()).build();

    private static final SdkField<PredictiveScalingCustomizedMetricSpecification> CUSTOMIZED_SCALING_METRIC_SPECIFICATION_FIELD = SdkField
            .<PredictiveScalingCustomizedMetricSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("CustomizedScalingMetricSpecification")
            .getter(getter(PredictiveScalingMetricSpecification::customizedScalingMetricSpecification))
            .setter(setter(Builder::customizedScalingMetricSpecification))
            .constructor(PredictiveScalingCustomizedMetricSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CustomizedScalingMetricSpecification").build()).build();

    private static final SdkField<PredictiveScalingCustomizedMetricSpecification> CUSTOMIZED_LOAD_METRIC_SPECIFICATION_FIELD = SdkField
            .<PredictiveScalingCustomizedMetricSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("CustomizedLoadMetricSpecification")
            .getter(getter(PredictiveScalingMetricSpecification::customizedLoadMetricSpecification))
            .setter(setter(Builder::customizedLoadMetricSpecification))
            .constructor(PredictiveScalingCustomizedMetricSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomizedLoadMetricSpecification")
                    .build()).build();

    private static final SdkField<PredictiveScalingCustomizedMetricSpecification> CUSTOMIZED_CAPACITY_METRIC_SPECIFICATION_FIELD = SdkField
            .<PredictiveScalingCustomizedMetricSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("CustomizedCapacityMetricSpecification")
            .getter(getter(PredictiveScalingMetricSpecification::customizedCapacityMetricSpecification))
            .setter(setter(Builder::customizedCapacityMetricSpecification))
            .constructor(PredictiveScalingCustomizedMetricSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CustomizedCapacityMetricSpecification").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_VALUE_FIELD,
            PREDEFINED_METRIC_PAIR_SPECIFICATION_FIELD, PREDEFINED_SCALING_METRIC_SPECIFICATION_FIELD,
            PREDEFINED_LOAD_METRIC_SPECIFICATION_FIELD, CUSTOMIZED_SCALING_METRIC_SPECIFICATION_FIELD,
            CUSTOMIZED_LOAD_METRIC_SPECIFICATION_FIELD, CUSTOMIZED_CAPACITY_METRIC_SPECIFICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double targetValue;

    private final PredictiveScalingPredefinedMetricPairSpecification predefinedMetricPairSpecification;

    private final PredictiveScalingPredefinedScalingMetricSpecification predefinedScalingMetricSpecification;

    private final PredictiveScalingPredefinedLoadMetricSpecification predefinedLoadMetricSpecification;

    private final PredictiveScalingCustomizedMetricSpecification customizedScalingMetricSpecification;

    private final PredictiveScalingCustomizedMetricSpecification customizedLoadMetricSpecification;

    private final PredictiveScalingCustomizedMetricSpecification customizedCapacityMetricSpecification;

    private PredictiveScalingMetricSpecification(BuilderImpl builder) {
        this.targetValue = builder.targetValue;
        this.predefinedMetricPairSpecification = builder.predefinedMetricPairSpecification;
        this.predefinedScalingMetricSpecification = builder.predefinedScalingMetricSpecification;
        this.predefinedLoadMetricSpecification = builder.predefinedLoadMetricSpecification;
        this.customizedScalingMetricSpecification = builder.customizedScalingMetricSpecification;
        this.customizedLoadMetricSpecification = builder.customizedLoadMetricSpecification;
        this.customizedCapacityMetricSpecification = builder.customizedCapacityMetricSpecification;
    }

    /**
     * <p>
     * Specifies the target utilization.
     * </p>
     * 
     * @return Specifies the target utilization.
     */
    public final Double targetValue() {
        return targetValue;
    }

    /**
     * <p>
     * The predefined metric pair specification that determines the appropriate scaling metric and load metric to use.
     * </p>
     * 
     * @return The predefined metric pair specification that determines the appropriate scaling metric and load metric
     *         to use.
     */
    public final PredictiveScalingPredefinedMetricPairSpecification predefinedMetricPairSpecification() {
        return predefinedMetricPairSpecification;
    }

    /**
     * <p>
     * The predefined scaling metric specification.
     * </p>
     * 
     * @return The predefined scaling metric specification.
     */
    public final PredictiveScalingPredefinedScalingMetricSpecification predefinedScalingMetricSpecification() {
        return predefinedScalingMetricSpecification;
    }

    /**
     * <p>
     * The predefined load metric specification.
     * </p>
     * 
     * @return The predefined load metric specification.
     */
    public final PredictiveScalingPredefinedLoadMetricSpecification predefinedLoadMetricSpecification() {
        return predefinedLoadMetricSpecification;
    }

    /**
     * <p>
     * The customized scaling metric specification.
     * </p>
     * 
     * @return The customized scaling metric specification.
     */
    public final PredictiveScalingCustomizedMetricSpecification customizedScalingMetricSpecification() {
        return customizedScalingMetricSpecification;
    }

    /**
     * <p>
     * The customized load metric specification.
     * </p>
     * 
     * @return The customized load metric specification.
     */
    public final PredictiveScalingCustomizedMetricSpecification customizedLoadMetricSpecification() {
        return customizedLoadMetricSpecification;
    }

    /**
     * <p>
     * The customized capacity metric specification.
     * </p>
     * 
     * @return The customized capacity metric specification.
     */
    public final PredictiveScalingCustomizedMetricSpecification customizedCapacityMetricSpecification() {
        return customizedCapacityMetricSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetValue());
        hashCode = 31 * hashCode + Objects.hashCode(predefinedMetricPairSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(predefinedScalingMetricSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(predefinedLoadMetricSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(customizedScalingMetricSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(customizedLoadMetricSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(customizedCapacityMetricSpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictiveScalingMetricSpecification)) {
            return false;
        }
        PredictiveScalingMetricSpecification other = (PredictiveScalingMetricSpecification) obj;
        return Objects.equals(targetValue(), other.targetValue())
                && Objects.equals(predefinedMetricPairSpecification(), other.predefinedMetricPairSpecification())
                && Objects.equals(predefinedScalingMetricSpecification(), other.predefinedScalingMetricSpecification())
                && Objects.equals(predefinedLoadMetricSpecification(), other.predefinedLoadMetricSpecification())
                && Objects.equals(customizedScalingMetricSpecification(), other.customizedScalingMetricSpecification())
                && Objects.equals(customizedLoadMetricSpecification(), other.customizedLoadMetricSpecification())
                && Objects.equals(customizedCapacityMetricSpecification(), other.customizedCapacityMetricSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PredictiveScalingMetricSpecification").add("TargetValue", targetValue())
                .add("PredefinedMetricPairSpecification", predefinedMetricPairSpecification())
                .add("PredefinedScalingMetricSpecification", predefinedScalingMetricSpecification())
                .add("PredefinedLoadMetricSpecification", predefinedLoadMetricSpecification())
                .add("CustomizedScalingMetricSpecification", customizedScalingMetricSpecification())
                .add("CustomizedLoadMetricSpecification", customizedLoadMetricSpecification())
                .add("CustomizedCapacityMetricSpecification", customizedCapacityMetricSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetValue":
            return Optional.ofNullable(clazz.cast(targetValue()));
        case "PredefinedMetricPairSpecification":
            return Optional.ofNullable(clazz.cast(predefinedMetricPairSpecification()));
        case "PredefinedScalingMetricSpecification":
            return Optional.ofNullable(clazz.cast(predefinedScalingMetricSpecification()));
        case "PredefinedLoadMetricSpecification":
            return Optional.ofNullable(clazz.cast(predefinedLoadMetricSpecification()));
        case "CustomizedScalingMetricSpecification":
            return Optional.ofNullable(clazz.cast(customizedScalingMetricSpecification()));
        case "CustomizedLoadMetricSpecification":
            return Optional.ofNullable(clazz.cast(customizedLoadMetricSpecification()));
        case "CustomizedCapacityMetricSpecification":
            return Optional.ofNullable(clazz.cast(customizedCapacityMetricSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TargetValue", TARGET_VALUE_FIELD);
        map.put("PredefinedMetricPairSpecification", PREDEFINED_METRIC_PAIR_SPECIFICATION_FIELD);
        map.put("PredefinedScalingMetricSpecification", PREDEFINED_SCALING_METRIC_SPECIFICATION_FIELD);
        map.put("PredefinedLoadMetricSpecification", PREDEFINED_LOAD_METRIC_SPECIFICATION_FIELD);
        map.put("CustomizedScalingMetricSpecification", CUSTOMIZED_SCALING_METRIC_SPECIFICATION_FIELD);
        map.put("CustomizedLoadMetricSpecification", CUSTOMIZED_LOAD_METRIC_SPECIFICATION_FIELD);
        map.put("CustomizedCapacityMetricSpecification", CUSTOMIZED_CAPACITY_METRIC_SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PredictiveScalingMetricSpecification, T> g) {
        return obj -> g.apply((PredictiveScalingMetricSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PredictiveScalingMetricSpecification> {
        /**
         * <p>
         * Specifies the target utilization.
         * </p>
         * 
         * @param targetValue
         *        Specifies the target utilization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetValue(Double targetValue);

        /**
         * <p>
         * The predefined metric pair specification that determines the appropriate scaling metric and load metric to
         * use.
         * </p>
         * 
         * @param predefinedMetricPairSpecification
         *        The predefined metric pair specification that determines the appropriate scaling metric and load
         *        metric to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predefinedMetricPairSpecification(
                PredictiveScalingPredefinedMetricPairSpecification predefinedMetricPairSpecification);

        /**
         * <p>
         * The predefined metric pair specification that determines the appropriate scaling metric and load metric to
         * use.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PredictiveScalingPredefinedMetricPairSpecification.Builder} avoiding the need to create one manually
         * via {@link PredictiveScalingPredefinedMetricPairSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link PredictiveScalingPredefinedMetricPairSpecification.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #predefinedMetricPairSpecification(PredictiveScalingPredefinedMetricPairSpecification)}.
         * 
         * @param predefinedMetricPairSpecification
         *        a consumer that will call methods on
         *        {@link PredictiveScalingPredefinedMetricPairSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predefinedMetricPairSpecification(PredictiveScalingPredefinedMetricPairSpecification)
         */
        default Builder predefinedMetricPairSpecification(
                Consumer<PredictiveScalingPredefinedMetricPairSpecification.Builder> predefinedMetricPairSpecification) {
            return predefinedMetricPairSpecification(PredictiveScalingPredefinedMetricPairSpecification.builder()
                    .applyMutation(predefinedMetricPairSpecification).build());
        }

        /**
         * <p>
         * The predefined scaling metric specification.
         * </p>
         * 
         * @param predefinedScalingMetricSpecification
         *        The predefined scaling metric specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predefinedScalingMetricSpecification(
                PredictiveScalingPredefinedScalingMetricSpecification predefinedScalingMetricSpecification);

        /**
         * <p>
         * The predefined scaling metric specification.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PredictiveScalingPredefinedScalingMetricSpecification.Builder} avoiding the need to create one
         * manually via {@link PredictiveScalingPredefinedScalingMetricSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link PredictiveScalingPredefinedScalingMetricSpecification.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #predefinedScalingMetricSpecification(PredictiveScalingPredefinedScalingMetricSpecification)}.
         * 
         * @param predefinedScalingMetricSpecification
         *        a consumer that will call methods on
         *        {@link PredictiveScalingPredefinedScalingMetricSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predefinedScalingMetricSpecification(PredictiveScalingPredefinedScalingMetricSpecification)
         */
        default Builder predefinedScalingMetricSpecification(
                Consumer<PredictiveScalingPredefinedScalingMetricSpecification.Builder> predefinedScalingMetricSpecification) {
            return predefinedScalingMetricSpecification(PredictiveScalingPredefinedScalingMetricSpecification.builder()
                    .applyMutation(predefinedScalingMetricSpecification).build());
        }

        /**
         * <p>
         * The predefined load metric specification.
         * </p>
         * 
         * @param predefinedLoadMetricSpecification
         *        The predefined load metric specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predefinedLoadMetricSpecification(
                PredictiveScalingPredefinedLoadMetricSpecification predefinedLoadMetricSpecification);

        /**
         * <p>
         * The predefined load metric specification.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PredictiveScalingPredefinedLoadMetricSpecification.Builder} avoiding the need to create one manually
         * via {@link PredictiveScalingPredefinedLoadMetricSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link PredictiveScalingPredefinedLoadMetricSpecification.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #predefinedLoadMetricSpecification(PredictiveScalingPredefinedLoadMetricSpecification)}.
         * 
         * @param predefinedLoadMetricSpecification
         *        a consumer that will call methods on
         *        {@link PredictiveScalingPredefinedLoadMetricSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predefinedLoadMetricSpecification(PredictiveScalingPredefinedLoadMetricSpecification)
         */
        default Builder predefinedLoadMetricSpecification(
                Consumer<PredictiveScalingPredefinedLoadMetricSpecification.Builder> predefinedLoadMetricSpecification) {
            return predefinedLoadMetricSpecification(PredictiveScalingPredefinedLoadMetricSpecification.builder()
                    .applyMutation(predefinedLoadMetricSpecification).build());
        }

        /**
         * <p>
         * The customized scaling metric specification.
         * </p>
         * 
         * @param customizedScalingMetricSpecification
         *        The customized scaling metric specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customizedScalingMetricSpecification(
                PredictiveScalingCustomizedMetricSpecification customizedScalingMetricSpecification);

        /**
         * <p>
         * The customized scaling metric specification.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PredictiveScalingCustomizedMetricSpecification.Builder} avoiding the need to create one manually via
         * {@link PredictiveScalingCustomizedMetricSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PredictiveScalingCustomizedMetricSpecification.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #customizedScalingMetricSpecification(PredictiveScalingCustomizedMetricSpecification)}.
         * 
         * @param customizedScalingMetricSpecification
         *        a consumer that will call methods on {@link PredictiveScalingCustomizedMetricSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customizedScalingMetricSpecification(PredictiveScalingCustomizedMetricSpecification)
         */
        default Builder customizedScalingMetricSpecification(
                Consumer<PredictiveScalingCustomizedMetricSpecification.Builder> customizedScalingMetricSpecification) {
            return customizedScalingMetricSpecification(PredictiveScalingCustomizedMetricSpecification.builder()
                    .applyMutation(customizedScalingMetricSpecification).build());
        }

        /**
         * <p>
         * The customized load metric specification.
         * </p>
         * 
         * @param customizedLoadMetricSpecification
         *        The customized load metric specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customizedLoadMetricSpecification(PredictiveScalingCustomizedMetricSpecification customizedLoadMetricSpecification);

        /**
         * <p>
         * The customized load metric specification.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PredictiveScalingCustomizedMetricSpecification.Builder} avoiding the need to create one manually via
         * {@link PredictiveScalingCustomizedMetricSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PredictiveScalingCustomizedMetricSpecification.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #customizedLoadMetricSpecification(PredictiveScalingCustomizedMetricSpecification)}.
         * 
         * @param customizedLoadMetricSpecification
         *        a consumer that will call methods on {@link PredictiveScalingCustomizedMetricSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customizedLoadMetricSpecification(PredictiveScalingCustomizedMetricSpecification)
         */
        default Builder customizedLoadMetricSpecification(
                Consumer<PredictiveScalingCustomizedMetricSpecification.Builder> customizedLoadMetricSpecification) {
            return customizedLoadMetricSpecification(PredictiveScalingCustomizedMetricSpecification.builder()
                    .applyMutation(customizedLoadMetricSpecification).build());
        }

        /**
         * <p>
         * The customized capacity metric specification.
         * </p>
         * 
         * @param customizedCapacityMetricSpecification
         *        The customized capacity metric specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customizedCapacityMetricSpecification(
                PredictiveScalingCustomizedMetricSpecification customizedCapacityMetricSpecification);

        /**
         * <p>
         * The customized capacity metric specification.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PredictiveScalingCustomizedMetricSpecification.Builder} avoiding the need to create one manually via
         * {@link PredictiveScalingCustomizedMetricSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PredictiveScalingCustomizedMetricSpecification.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #customizedCapacityMetricSpecification(PredictiveScalingCustomizedMetricSpecification)}.
         * 
         * @param customizedCapacityMetricSpecification
         *        a consumer that will call methods on {@link PredictiveScalingCustomizedMetricSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customizedCapacityMetricSpecification(PredictiveScalingCustomizedMetricSpecification)
         */
        default Builder customizedCapacityMetricSpecification(
                Consumer<PredictiveScalingCustomizedMetricSpecification.Builder> customizedCapacityMetricSpecification) {
            return customizedCapacityMetricSpecification(PredictiveScalingCustomizedMetricSpecification.builder()
                    .applyMutation(customizedCapacityMetricSpecification).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Double targetValue;

        private PredictiveScalingPredefinedMetricPairSpecification predefinedMetricPairSpecification;

        private PredictiveScalingPredefinedScalingMetricSpecification predefinedScalingMetricSpecification;

        private PredictiveScalingPredefinedLoadMetricSpecification predefinedLoadMetricSpecification;

        private PredictiveScalingCustomizedMetricSpecification customizedScalingMetricSpecification;

        private PredictiveScalingCustomizedMetricSpecification customizedLoadMetricSpecification;

        private PredictiveScalingCustomizedMetricSpecification customizedCapacityMetricSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictiveScalingMetricSpecification model) {
            targetValue(model.targetValue);
            predefinedMetricPairSpecification(model.predefinedMetricPairSpecification);
            predefinedScalingMetricSpecification(model.predefinedScalingMetricSpecification);
            predefinedLoadMetricSpecification(model.predefinedLoadMetricSpecification);
            customizedScalingMetricSpecification(model.customizedScalingMetricSpecification);
            customizedLoadMetricSpecification(model.customizedLoadMetricSpecification);
            customizedCapacityMetricSpecification(model.customizedCapacityMetricSpecification);
        }

        public final Double getTargetValue() {
            return targetValue;
        }

        public final void setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
        }

        @Override
        public final Builder targetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        public final PredictiveScalingPredefinedMetricPairSpecification.Builder getPredefinedMetricPairSpecification() {
            return predefinedMetricPairSpecification != null ? predefinedMetricPairSpecification.toBuilder() : null;
        }

        public final void setPredefinedMetricPairSpecification(
                PredictiveScalingPredefinedMetricPairSpecification.BuilderImpl predefinedMetricPairSpecification) {
            this.predefinedMetricPairSpecification = predefinedMetricPairSpecification != null ? predefinedMetricPairSpecification
                    .build() : null;
        }

        @Override
        public final Builder predefinedMetricPairSpecification(
                PredictiveScalingPredefinedMetricPairSpecification predefinedMetricPairSpecification) {
            this.predefinedMetricPairSpecification = predefinedMetricPairSpecification;
            return this;
        }

        public final PredictiveScalingPredefinedScalingMetricSpecification.Builder getPredefinedScalingMetricSpecification() {
            return predefinedScalingMetricSpecification != null ? predefinedScalingMetricSpecification.toBuilder() : null;
        }

        public final void setPredefinedScalingMetricSpecification(
                PredictiveScalingPredefinedScalingMetricSpecification.BuilderImpl predefinedScalingMetricSpecification) {
            this.predefinedScalingMetricSpecification = predefinedScalingMetricSpecification != null ? predefinedScalingMetricSpecification
                    .build() : null;
        }

        @Override
        public final Builder predefinedScalingMetricSpecification(
                PredictiveScalingPredefinedScalingMetricSpecification predefinedScalingMetricSpecification) {
            this.predefinedScalingMetricSpecification = predefinedScalingMetricSpecification;
            return this;
        }

        public final PredictiveScalingPredefinedLoadMetricSpecification.Builder getPredefinedLoadMetricSpecification() {
            return predefinedLoadMetricSpecification != null ? predefinedLoadMetricSpecification.toBuilder() : null;
        }

        public final void setPredefinedLoadMetricSpecification(
                PredictiveScalingPredefinedLoadMetricSpecification.BuilderImpl predefinedLoadMetricSpecification) {
            this.predefinedLoadMetricSpecification = predefinedLoadMetricSpecification != null ? predefinedLoadMetricSpecification
                    .build() : null;
        }

        @Override
        public final Builder predefinedLoadMetricSpecification(
                PredictiveScalingPredefinedLoadMetricSpecification predefinedLoadMetricSpecification) {
            this.predefinedLoadMetricSpecification = predefinedLoadMetricSpecification;
            return this;
        }

        public final PredictiveScalingCustomizedMetricSpecification.Builder getCustomizedScalingMetricSpecification() {
            return customizedScalingMetricSpecification != null ? customizedScalingMetricSpecification.toBuilder() : null;
        }

        public final void setCustomizedScalingMetricSpecification(
                PredictiveScalingCustomizedMetricSpecification.BuilderImpl customizedScalingMetricSpecification) {
            this.customizedScalingMetricSpecification = customizedScalingMetricSpecification != null ? customizedScalingMetricSpecification
                    .build() : null;
        }

        @Override
        public final Builder customizedScalingMetricSpecification(
                PredictiveScalingCustomizedMetricSpecification customizedScalingMetricSpecification) {
            this.customizedScalingMetricSpecification = customizedScalingMetricSpecification;
            return this;
        }

        public final PredictiveScalingCustomizedMetricSpecification.Builder getCustomizedLoadMetricSpecification() {
            return customizedLoadMetricSpecification != null ? customizedLoadMetricSpecification.toBuilder() : null;
        }

        public final void setCustomizedLoadMetricSpecification(
                PredictiveScalingCustomizedMetricSpecification.BuilderImpl customizedLoadMetricSpecification) {
            this.customizedLoadMetricSpecification = customizedLoadMetricSpecification != null ? customizedLoadMetricSpecification
                    .build() : null;
        }

        @Override
        public final Builder customizedLoadMetricSpecification(
                PredictiveScalingCustomizedMetricSpecification customizedLoadMetricSpecification) {
            this.customizedLoadMetricSpecification = customizedLoadMetricSpecification;
            return this;
        }

        public final PredictiveScalingCustomizedMetricSpecification.Builder getCustomizedCapacityMetricSpecification() {
            return customizedCapacityMetricSpecification != null ? customizedCapacityMetricSpecification.toBuilder() : null;
        }

        public final void setCustomizedCapacityMetricSpecification(
                PredictiveScalingCustomizedMetricSpecification.BuilderImpl customizedCapacityMetricSpecification) {
            this.customizedCapacityMetricSpecification = customizedCapacityMetricSpecification != null ? customizedCapacityMetricSpecification
                    .build() : null;
        }

        @Override
        public final Builder customizedCapacityMetricSpecification(
                PredictiveScalingCustomizedMetricSpecification customizedCapacityMetricSpecification) {
            this.customizedCapacityMetricSpecification = customizedCapacityMetricSpecification;
            return this;
        }

        @Override
        public PredictiveScalingMetricSpecification build() {
            return new PredictiveScalingMetricSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
