/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationautoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure defines the CloudWatch metric to return, along with the statistic and unit.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredictiveScalingMetricStat implements SdkPojo, Serializable,
        ToCopyableBuilder<PredictiveScalingMetricStat.Builder, PredictiveScalingMetricStat> {
    private static final SdkField<PredictiveScalingMetric> METRIC_FIELD = SdkField
            .<PredictiveScalingMetric> builder(MarshallingType.SDK_POJO).memberName("Metric")
            .getter(getter(PredictiveScalingMetricStat::metric)).setter(setter(Builder::metric))
            .constructor(PredictiveScalingMetric::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").build()).build();

    private static final SdkField<String> STAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Stat")
            .getter(getter(PredictiveScalingMetricStat::stat)).setter(setter(Builder::stat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stat").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(PredictiveScalingMetricStat::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_FIELD, STAT_FIELD,
            UNIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PredictiveScalingMetric metric;

    private final String stat;

    private final String unit;

    private PredictiveScalingMetricStat(BuilderImpl builder) {
        this.metric = builder.metric;
        this.stat = builder.stat;
        this.unit = builder.unit;
    }

    /**
     * <p>
     * The CloudWatch metric to return, including the metric name, namespace, and dimensions. To get the exact metric
     * name, namespace, and dimensions, inspect the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html">Metric</a> object that is
     * returned by a call to <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html">ListMetrics</a>.
     * </p>
     * 
     * @return The CloudWatch metric to return, including the metric name, namespace, and dimensions. To get the exact
     *         metric name, namespace, and dimensions, inspect the <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html">Metric</a> object
     *         that is returned by a call to <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html"
     *         >ListMetrics</a>.
     */
    public final PredictiveScalingMetric metric() {
        return metric;
    }

    /**
     * <p>
     * The statistic to return. It can include any CloudWatch statistic or extended statistic. For a list of valid
     * values, see the table in <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic"
     * >Statistics</a> in the <i>Amazon CloudWatch User Guide</i>.
     * </p>
     * <p>
     * The most commonly used metrics for predictive scaling are <code>Average</code> and <code>Sum</code>.
     * </p>
     * 
     * @return The statistic to return. It can include any CloudWatch statistic or extended statistic. For a list of
     *         valid values, see the table in <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic"
     *         >Statistics</a> in the <i>Amazon CloudWatch User Guide</i>. </p>
     *         <p>
     *         The most commonly used metrics for predictive scaling are <code>Average</code> and <code>Sum</code>.
     */
    public final String stat() {
        return stat;
    }

    /**
     * <p>
     * The unit to use for the returned data points. For a complete list of the units that CloudWatch supports, see the
     * <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">MetricDatum</a>
     * data type in the <i>Amazon CloudWatch API Reference</i>.
     * </p>
     * 
     * @return The unit to use for the returned data points. For a complete list of the units that CloudWatch supports,
     *         see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">
     *         MetricDatum</a> data type in the <i>Amazon CloudWatch API Reference</i>.
     */
    public final String unit() {
        return unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metric());
        hashCode = 31 * hashCode + Objects.hashCode(stat());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictiveScalingMetricStat)) {
            return false;
        }
        PredictiveScalingMetricStat other = (PredictiveScalingMetricStat) obj;
        return Objects.equals(metric(), other.metric()) && Objects.equals(stat(), other.stat())
                && Objects.equals(unit(), other.unit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PredictiveScalingMetricStat").add("Metric", metric()).add("Stat", stat()).add("Unit", unit())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Metric":
            return Optional.ofNullable(clazz.cast(metric()));
        case "Stat":
            return Optional.ofNullable(clazz.cast(stat()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Metric", METRIC_FIELD);
        map.put("Stat", STAT_FIELD);
        map.put("Unit", UNIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PredictiveScalingMetricStat, T> g) {
        return obj -> g.apply((PredictiveScalingMetricStat) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PredictiveScalingMetricStat> {
        /**
         * <p>
         * The CloudWatch metric to return, including the metric name, namespace, and dimensions. To get the exact
         * metric name, namespace, and dimensions, inspect the <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html">Metric</a> object
         * that is returned by a call to <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html">ListMetrics</a>.
         * </p>
         * 
         * @param metric
         *        The CloudWatch metric to return, including the metric name, namespace, and dimensions. To get the
         *        exact metric name, namespace, and dimensions, inspect the <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html">Metric</a>
         *        object that is returned by a call to <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html"
         *        >ListMetrics</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metric(PredictiveScalingMetric metric);

        /**
         * <p>
         * The CloudWatch metric to return, including the metric name, namespace, and dimensions. To get the exact
         * metric name, namespace, and dimensions, inspect the <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html">Metric</a> object
         * that is returned by a call to <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html">ListMetrics</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link PredictiveScalingMetric.Builder} avoiding
         * the need to create one manually via {@link PredictiveScalingMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PredictiveScalingMetric.Builder#build()} is called immediately
         * and its result is passed to {@link #metric(PredictiveScalingMetric)}.
         * 
         * @param metric
         *        a consumer that will call methods on {@link PredictiveScalingMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metric(PredictiveScalingMetric)
         */
        default Builder metric(Consumer<PredictiveScalingMetric.Builder> metric) {
            return metric(PredictiveScalingMetric.builder().applyMutation(metric).build());
        }

        /**
         * <p>
         * The statistic to return. It can include any CloudWatch statistic or extended statistic. For a list of valid
         * values, see the table in <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic"
         * >Statistics</a> in the <i>Amazon CloudWatch User Guide</i>.
         * </p>
         * <p>
         * The most commonly used metrics for predictive scaling are <code>Average</code> and <code>Sum</code>.
         * </p>
         * 
         * @param stat
         *        The statistic to return. It can include any CloudWatch statistic or extended statistic. For a list of
         *        valid values, see the table in <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic"
         *        >Statistics</a> in the <i>Amazon CloudWatch User Guide</i>. </p>
         *        <p>
         *        The most commonly used metrics for predictive scaling are <code>Average</code> and <code>Sum</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stat(String stat);

        /**
         * <p>
         * The unit to use for the returned data points. For a complete list of the units that CloudWatch supports, see
         * the <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">MetricDatum</a>
         * data type in the <i>Amazon CloudWatch API Reference</i>.
         * </p>
         * 
         * @param unit
         *        The unit to use for the returned data points. For a complete list of the units that CloudWatch
         *        supports, see the <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html"
         *        >MetricDatum</a> data type in the <i>Amazon CloudWatch API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);
    }

    static final class BuilderImpl implements Builder {
        private PredictiveScalingMetric metric;

        private String stat;

        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictiveScalingMetricStat model) {
            metric(model.metric);
            stat(model.stat);
            unit(model.unit);
        }

        public final PredictiveScalingMetric.Builder getMetric() {
            return metric != null ? metric.toBuilder() : null;
        }

        public final void setMetric(PredictiveScalingMetric.BuilderImpl metric) {
            this.metric = metric != null ? metric.build() : null;
        }

        @Override
        public final Builder metric(PredictiveScalingMetric metric) {
            this.metric = metric;
            return this;
        }

        public final String getStat() {
            return stat;
        }

        public final void setStat(String stat) {
            this.stat = stat;
        }

        @Override
        public final Builder stat(String stat) {
            this.stat = stat;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public PredictiveScalingMetricStat build() {
            return new PredictiveScalingMetricStat(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
