/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationautoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the scaling metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredictiveScalingMetric implements SdkPojo, Serializable,
        ToCopyableBuilder<PredictiveScalingMetric.Builder, PredictiveScalingMetric> {
    private static final SdkField<List<PredictiveScalingMetricDimension>> DIMENSIONS_FIELD = SdkField
            .<List<PredictiveScalingMetricDimension>> builder(MarshallingType.LIST)
            .memberName("Dimensions")
            .getter(getter(PredictiveScalingMetric::dimensions))
            .setter(setter(Builder::dimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PredictiveScalingMetricDimension> builder(MarshallingType.SDK_POJO)
                                            .constructor(PredictiveScalingMetricDimension::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(PredictiveScalingMetric::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(PredictiveScalingMetric::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD,
            METRIC_NAME_FIELD, NAMESPACE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<PredictiveScalingMetricDimension> dimensions;

    private final String metricName;

    private final String namespace;

    private PredictiveScalingMetric(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.metricName = builder.metricName;
        this.namespace = builder.namespace;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dimensions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDimensions() {
        return dimensions != null && !(dimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the dimensions of the metric.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensions} method.
     * </p>
     * 
     * @return Describes the dimensions of the metric.
     */
    public final List<PredictiveScalingMetricDimension> dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * The name of the metric.
     * </p>
     * 
     * @return The name of the metric.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The namespace of the metric.
     * </p>
     * 
     * @return The namespace of the metric.
     */
    public final String namespace() {
        return namespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensions() ? dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictiveScalingMetric)) {
            return false;
        }
        PredictiveScalingMetric other = (PredictiveScalingMetric) obj;
        return hasDimensions() == other.hasDimensions() && Objects.equals(dimensions(), other.dimensions())
                && Objects.equals(metricName(), other.metricName()) && Objects.equals(namespace(), other.namespace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PredictiveScalingMetric").add("Dimensions", hasDimensions() ? dimensions() : null)
                .add("MetricName", metricName()).add("Namespace", namespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Dimensions", DIMENSIONS_FIELD);
        map.put("MetricName", METRIC_NAME_FIELD);
        map.put("Namespace", NAMESPACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PredictiveScalingMetric, T> g) {
        return obj -> g.apply((PredictiveScalingMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PredictiveScalingMetric> {
        /**
         * <p>
         * Describes the dimensions of the metric.
         * </p>
         * 
         * @param dimensions
         *        Describes the dimensions of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Collection<PredictiveScalingMetricDimension> dimensions);

        /**
         * <p>
         * Describes the dimensions of the metric.
         * </p>
         * 
         * @param dimensions
         *        Describes the dimensions of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(PredictiveScalingMetricDimension... dimensions);

        /**
         * <p>
         * Describes the dimensions of the metric.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationautoscaling.model.PredictiveScalingMetricDimension.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.applicationautoscaling.model.PredictiveScalingMetricDimension#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationautoscaling.model.PredictiveScalingMetricDimension.Builder#build()}
         * is called immediately and its result is passed to {@link #dimensions(List<PredictiveScalingMetricDimension>)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationautoscaling.model.PredictiveScalingMetricDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(java.util.Collection<PredictiveScalingMetricDimension>)
         */
        Builder dimensions(Consumer<PredictiveScalingMetricDimension.Builder>... dimensions);

        /**
         * <p>
         * The name of the metric.
         * </p>
         * 
         * @param metricName
         *        The name of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The namespace of the metric.
         * </p>
         * 
         * @param namespace
         *        The namespace of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);
    }

    static final class BuilderImpl implements Builder {
        private List<PredictiveScalingMetricDimension> dimensions = DefaultSdkAutoConstructList.getInstance();

        private String metricName;

        private String namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictiveScalingMetric model) {
            dimensions(model.dimensions);
            metricName(model.metricName);
            namespace(model.namespace);
        }

        public final List<PredictiveScalingMetricDimension.Builder> getDimensions() {
            List<PredictiveScalingMetricDimension.Builder> result = PredictiveScalingMetricDimensionsCopier
                    .copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensions(Collection<PredictiveScalingMetricDimension.BuilderImpl> dimensions) {
            this.dimensions = PredictiveScalingMetricDimensionsCopier.copyFromBuilder(dimensions);
        }

        @Override
        public final Builder dimensions(Collection<PredictiveScalingMetricDimension> dimensions) {
            this.dimensions = PredictiveScalingMetricDimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(PredictiveScalingMetricDimension... dimensions) {
            dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<PredictiveScalingMetricDimension.Builder>... dimensions) {
            dimensions(Stream.of(dimensions).map(c -> PredictiveScalingMetricDimension.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public PredictiveScalingMetric build() {
            return new PredictiveScalingMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
