/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutScalingPolicyResponse extends ApplicationAutoScalingResponse implements
        ToCopyableBuilder<PutScalingPolicyResponse.Builder, PutScalingPolicyResponse> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyARN").getter(getter(PutScalingPolicyResponse::policyARN)).setter(setter(Builder::policyARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyARN").build()).build();

    private static final SdkField<List<Alarm>> ALARMS_FIELD = SdkField
            .<List<Alarm>> builder(MarshallingType.LIST)
            .memberName("Alarms")
            .getter(getter(PutScalingPolicyResponse::alarms))
            .setter(setter(Builder::alarms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alarms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Alarm> builder(MarshallingType.SDK_POJO)
                                            .constructor(Alarm::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(POLICY_ARN_FIELD, ALARMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyARN;

    private final List<Alarm> alarms;

    private PutScalingPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policyARN = builder.policyARN;
        this.alarms = builder.alarms;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resulting scaling policy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resulting scaling policy.
     */
    public final String policyARN() {
        return policyARN;
    }

    /**
     * For responses, this returns true if the service returned a value for the Alarms property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAlarms() {
        return alarms != null && !(alarms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The CloudWatch alarms created for the target tracking scaling policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAlarms} method.
     * </p>
     * 
     * @return The CloudWatch alarms created for the target tracking scaling policy.
     */
    public final List<Alarm> alarms() {
        return alarms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyARN());
        hashCode = 31 * hashCode + Objects.hashCode(hasAlarms() ? alarms() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutScalingPolicyResponse)) {
            return false;
        }
        PutScalingPolicyResponse other = (PutScalingPolicyResponse) obj;
        return Objects.equals(policyARN(), other.policyARN()) && hasAlarms() == other.hasAlarms()
                && Objects.equals(alarms(), other.alarms());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutScalingPolicyResponse").add("PolicyARN", policyARN())
                .add("Alarms", hasAlarms() ? alarms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyARN":
            return Optional.ofNullable(clazz.cast(policyARN()));
        case "Alarms":
            return Optional.ofNullable(clazz.cast(alarms()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PolicyARN", POLICY_ARN_FIELD);
        map.put("Alarms", ALARMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutScalingPolicyResponse, T> g) {
        return obj -> g.apply((PutScalingPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApplicationAutoScalingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutScalingPolicyResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resulting scaling policy.
         * </p>
         * 
         * @param policyARN
         *        The Amazon Resource Name (ARN) of the resulting scaling policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyARN(String policyARN);

        /**
         * <p>
         * The CloudWatch alarms created for the target tracking scaling policy.
         * </p>
         * 
         * @param alarms
         *        The CloudWatch alarms created for the target tracking scaling policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarms(Collection<Alarm> alarms);

        /**
         * <p>
         * The CloudWatch alarms created for the target tracking scaling policy.
         * </p>
         * 
         * @param alarms
         *        The CloudWatch alarms created for the target tracking scaling policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarms(Alarm... alarms);

        /**
         * <p>
         * The CloudWatch alarms created for the target tracking scaling policy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationautoscaling.model.Alarm.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.applicationautoscaling.model.Alarm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationautoscaling.model.Alarm.Builder#build()} is called
         * immediately and its result is passed to {@link #alarms(List<Alarm>)}.
         * 
         * @param alarms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationautoscaling.model.Alarm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarms(java.util.Collection<Alarm>)
         */
        Builder alarms(Consumer<Alarm.Builder>... alarms);
    }

    static final class BuilderImpl extends ApplicationAutoScalingResponse.BuilderImpl implements Builder {
        private String policyARN;

        private List<Alarm> alarms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutScalingPolicyResponse model) {
            super(model);
            policyARN(model.policyARN);
            alarms(model.alarms);
        }

        public final String getPolicyARN() {
            return policyARN;
        }

        public final void setPolicyARN(String policyARN) {
            this.policyARN = policyARN;
        }

        @Override
        public final Builder policyARN(String policyARN) {
            this.policyARN = policyARN;
            return this;
        }

        public final List<Alarm.Builder> getAlarms() {
            List<Alarm.Builder> result = AlarmsCopier.copyToBuilder(this.alarms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlarms(Collection<Alarm.BuilderImpl> alarms) {
            this.alarms = AlarmsCopier.copyFromBuilder(alarms);
        }

        @Override
        public final Builder alarms(Collection<Alarm> alarms) {
            this.alarms = AlarmsCopier.copy(alarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(Alarm... alarms) {
            alarms(Arrays.asList(alarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(Consumer<Alarm.Builder>... alarms) {
            alarms(Stream.of(alarms).map(c -> Alarm.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PutScalingPolicyResponse build() {
            return new PutScalingPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
