/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationautoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the minimum and maximum capacity for a scheduled action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScalableTargetAction implements SdkPojo, Serializable,
        ToCopyableBuilder<ScalableTargetAction.Builder, ScalableTargetAction> {
    private static final SdkField<Integer> MIN_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinCapacity").getter(getter(ScalableTargetAction::minCapacity)).setter(setter(Builder::minCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinCapacity").build()).build();

    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxCapacity").getter(getter(ScalableTargetAction::maxCapacity)).setter(setter(Builder::maxCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_CAPACITY_FIELD,
            MAX_CAPACITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer minCapacity;

    private final Integer maxCapacity;

    private ScalableTargetAction(BuilderImpl builder) {
        this.minCapacity = builder.minCapacity;
        this.maxCapacity = builder.maxCapacity;
    }

    /**
     * <p>
     * The minimum capacity.
     * </p>
     * <p>
     * When the scheduled action runs, the resource will have at least this much capacity, but it might have more
     * depending on other settings, such as the target utilization level of a target tracking scaling policy.
     * </p>
     * 
     * @return The minimum capacity.</p>
     *         <p>
     *         When the scheduled action runs, the resource will have at least this much capacity, but it might have
     *         more depending on other settings, such as the target utilization level of a target tracking scaling
     *         policy.
     */
    public final Integer minCapacity() {
        return minCapacity;
    }

    /**
     * <p>
     * The maximum capacity.
     * </p>
     * <p>
     * Although you can specify a large maximum capacity, note that service quotas may impose lower limits. Each service
     * has its own default quotas for the maximum capacity of the resource. If you want to specify a higher limit, you
     * can request an increase. For more information, consult the documentation for that service. For information about
     * the default quotas for each service, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-service-information.html">Service endpoints and
     * quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return The maximum capacity.</p>
     *         <p>
     *         Although you can specify a large maximum capacity, note that service quotas may impose lower limits. Each
     *         service has its own default quotas for the maximum capacity of the resource. If you want to specify a
     *         higher limit, you can request an increase. For more information, consult the documentation for that
     *         service. For information about the default quotas for each service, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-service-information.html">Service endpoints and
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final Integer maxCapacity() {
        return maxCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(maxCapacity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalableTargetAction)) {
            return false;
        }
        ScalableTargetAction other = (ScalableTargetAction) obj;
        return Objects.equals(minCapacity(), other.minCapacity()) && Objects.equals(maxCapacity(), other.maxCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScalableTargetAction").add("MinCapacity", minCapacity()).add("MaxCapacity", maxCapacity())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinCapacity":
            return Optional.ofNullable(clazz.cast(minCapacity()));
        case "MaxCapacity":
            return Optional.ofNullable(clazz.cast(maxCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MinCapacity", MIN_CAPACITY_FIELD);
        map.put("MaxCapacity", MAX_CAPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScalableTargetAction, T> g) {
        return obj -> g.apply((ScalableTargetAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScalableTargetAction> {
        /**
         * <p>
         * The minimum capacity.
         * </p>
         * <p>
         * When the scheduled action runs, the resource will have at least this much capacity, but it might have more
         * depending on other settings, such as the target utilization level of a target tracking scaling policy.
         * </p>
         * 
         * @param minCapacity
         *        The minimum capacity.</p>
         *        <p>
         *        When the scheduled action runs, the resource will have at least this much capacity, but it might have
         *        more depending on other settings, such as the target utilization level of a target tracking scaling
         *        policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minCapacity(Integer minCapacity);

        /**
         * <p>
         * The maximum capacity.
         * </p>
         * <p>
         * Although you can specify a large maximum capacity, note that service quotas may impose lower limits. Each
         * service has its own default quotas for the maximum capacity of the resource. If you want to specify a higher
         * limit, you can request an increase. For more information, consult the documentation for that service. For
         * information about the default quotas for each service, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-service-information.html">Service endpoints and
         * quotas</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param maxCapacity
         *        The maximum capacity.</p>
         *        <p>
         *        Although you can specify a large maximum capacity, note that service quotas may impose lower limits.
         *        Each service has its own default quotas for the maximum capacity of the resource. If you want to
         *        specify a higher limit, you can request an increase. For more information, consult the documentation
         *        for that service. For information about the default quotas for each service, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-service-information.html">Service endpoints
         *        and quotas</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCapacity(Integer maxCapacity);
    }

    static final class BuilderImpl implements Builder {
        private Integer minCapacity;

        private Integer maxCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalableTargetAction model) {
            minCapacity(model.minCapacity);
            maxCapacity(model.maxCapacity);
        }

        public final Integer getMinCapacity() {
            return minCapacity;
        }

        public final void setMinCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
        }

        @Override
        public final Builder minCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        public final Integer getMaxCapacity() {
            return maxCapacity;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        @Override
        public ScalableTargetAction build() {
            return new ScalableTargetAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
