/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationcostprofiler.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportApplicationUsageRequest extends ApplicationCostProfilerRequest implements
        ToCopyableBuilder<ImportApplicationUsageRequest.Builder, ImportApplicationUsageRequest> {
    private static final SdkField<SourceS3Location> SOURCE_S3_LOCATION_FIELD = SdkField
            .<SourceS3Location> builder(MarshallingType.SDK_POJO).memberName("sourceS3Location")
            .getter(getter(ImportApplicationUsageRequest::sourceS3Location)).setter(setter(Builder::sourceS3Location))
            .constructor(SourceS3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceS3Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_S3_LOCATION_FIELD));

    private final SourceS3Location sourceS3Location;

    private ImportApplicationUsageRequest(BuilderImpl builder) {
        super(builder);
        this.sourceS3Location = builder.sourceS3Location;
    }

    /**
     * <p>
     * Amazon S3 location to import application usage data from.
     * </p>
     * 
     * @return Amazon S3 location to import application usage data from.
     */
    public final SourceS3Location sourceS3Location() {
        return sourceS3Location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceS3Location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportApplicationUsageRequest)) {
            return false;
        }
        ImportApplicationUsageRequest other = (ImportApplicationUsageRequest) obj;
        return Objects.equals(sourceS3Location(), other.sourceS3Location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportApplicationUsageRequest").add("SourceS3Location", sourceS3Location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceS3Location":
            return Optional.ofNullable(clazz.cast(sourceS3Location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportApplicationUsageRequest, T> g) {
        return obj -> g.apply((ImportApplicationUsageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationCostProfilerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ImportApplicationUsageRequest> {
        /**
         * <p>
         * Amazon S3 location to import application usage data from.
         * </p>
         * 
         * @param sourceS3Location
         *        Amazon S3 location to import application usage data from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceS3Location(SourceS3Location sourceS3Location);

        /**
         * <p>
         * Amazon S3 location to import application usage data from.
         * </p>
         * This is a convenience that creates an instance of the {@link SourceS3Location.Builder} avoiding the need to
         * create one manually via {@link SourceS3Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceS3Location.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceS3Location(SourceS3Location)}.
         * 
         * @param sourceS3Location
         *        a consumer that will call methods on {@link SourceS3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceS3Location(SourceS3Location)
         */
        default Builder sourceS3Location(Consumer<SourceS3Location.Builder> sourceS3Location) {
            return sourceS3Location(SourceS3Location.builder().applyMutation(sourceS3Location).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationCostProfilerRequest.BuilderImpl implements Builder {
        private SourceS3Location sourceS3Location;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportApplicationUsageRequest model) {
            super(model);
            sourceS3Location(model.sourceS3Location);
        }

        public final SourceS3Location.Builder getSourceS3Location() {
            return sourceS3Location != null ? sourceS3Location.toBuilder() : null;
        }

        @Override
        public final Builder sourceS3Location(SourceS3Location sourceS3Location) {
            this.sourceS3Location = sourceS3Location;
            return this;
        }

        public final void setSourceS3Location(SourceS3Location.BuilderImpl sourceS3Location) {
            this.sourceS3Location = sourceS3Location != null ? sourceS3Location.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportApplicationUsageRequest build() {
            return new ImportApplicationUsageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
