/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationcostprofiler.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportApplicationUsageResponse extends ApplicationCostProfilerResponse implements
        ToCopyableBuilder<ImportApplicationUsageResponse.Builder, ImportApplicationUsageResponse> {
    private static final SdkField<String> IMPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importId").getter(getter(ImportApplicationUsageResponse::importId)).setter(setter(Builder::importId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_ID_FIELD));

    private final String importId;

    private ImportApplicationUsageResponse(BuilderImpl builder) {
        super(builder);
        this.importId = builder.importId;
    }

    /**
     * <p>
     * ID of the import request.
     * </p>
     * 
     * @return ID of the import request.
     */
    public final String importId() {
        return importId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(importId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportApplicationUsageResponse)) {
            return false;
        }
        ImportApplicationUsageResponse other = (ImportApplicationUsageResponse) obj;
        return Objects.equals(importId(), other.importId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportApplicationUsageResponse").add("ImportId", importId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "importId":
            return Optional.ofNullable(clazz.cast(importId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportApplicationUsageResponse, T> g) {
        return obj -> g.apply((ImportApplicationUsageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationCostProfilerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ImportApplicationUsageResponse> {
        /**
         * <p>
         * ID of the import request.
         * </p>
         * 
         * @param importId
         *        ID of the import request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importId(String importId);
    }

    static final class BuilderImpl extends ApplicationCostProfilerResponse.BuilderImpl implements Builder {
        private String importId;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportApplicationUsageResponse model) {
            super(model);
            importId(model.importId);
        }

        public final String getImportId() {
            return importId;
        }

        @Override
        public final Builder importId(String importId) {
            this.importId = importId;
            return this;
        }

        public final void setImportId(String importId) {
            this.importId = importId;
        }

        @Override
        public ImportApplicationUsageResponse build() {
            return new ImportApplicationUsageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
