/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationcostprofiler.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReportDefinitionsResponse extends ApplicationCostProfilerResponse implements
        ToCopyableBuilder<ListReportDefinitionsResponse.Builder, ListReportDefinitionsResponse> {
    private static final SdkField<List<ReportDefinition>> REPORT_DEFINITIONS_FIELD = SdkField
            .<List<ReportDefinition>> builder(MarshallingType.LIST)
            .memberName("reportDefinitions")
            .getter(getter(ListReportDefinitionsResponse::reportDefinitions))
            .setter(setter(Builder::reportDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReportDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReportDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListReportDefinitionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_DEFINITIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ReportDefinition> reportDefinitions;

    private final String nextToken;

    private ListReportDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.reportDefinitions = builder.reportDefinitions;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ReportDefinitions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasReportDefinitions() {
        return reportDefinitions != null && !(reportDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The retrieved reports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReportDefinitions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The retrieved reports.
     */
    public final List<ReportDefinition> reportDefinitions() {
        return reportDefinitions;
    }

    /**
     * <p>
     * The value of the next token, if it exists. Null if there are no more results.
     * </p>
     * 
     * @return The value of the next token, if it exists. Null if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasReportDefinitions() ? reportDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReportDefinitionsResponse)) {
            return false;
        }
        ListReportDefinitionsResponse other = (ListReportDefinitionsResponse) obj;
        return hasReportDefinitions() == other.hasReportDefinitions()
                && Objects.equals(reportDefinitions(), other.reportDefinitions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListReportDefinitionsResponse")
                .add("ReportDefinitions", hasReportDefinitions() ? reportDefinitions() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reportDefinitions":
            return Optional.ofNullable(clazz.cast(reportDefinitions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListReportDefinitionsResponse, T> g) {
        return obj -> g.apply((ListReportDefinitionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationCostProfilerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListReportDefinitionsResponse> {
        /**
         * <p>
         * The retrieved reports.
         * </p>
         * 
         * @param reportDefinitions
         *        The retrieved reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportDefinitions(Collection<ReportDefinition> reportDefinitions);

        /**
         * <p>
         * The retrieved reports.
         * </p>
         * 
         * @param reportDefinitions
         *        The retrieved reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportDefinitions(ReportDefinition... reportDefinitions);

        /**
         * <p>
         * The retrieved reports.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReportDefinition>.Builder} avoiding the
         * need to create one manually via {@link List<ReportDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReportDefinition>.Builder#build()} is called immediately and
         * its result is passed to {@link #reportDefinitions(List<ReportDefinition>)}.
         * 
         * @param reportDefinitions
         *        a consumer that will call methods on {@link List<ReportDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportDefinitions(List<ReportDefinition>)
         */
        Builder reportDefinitions(Consumer<ReportDefinition.Builder>... reportDefinitions);

        /**
         * <p>
         * The value of the next token, if it exists. Null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The value of the next token, if it exists. Null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ApplicationCostProfilerResponse.BuilderImpl implements Builder {
        private List<ReportDefinition> reportDefinitions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReportDefinitionsResponse model) {
            super(model);
            reportDefinitions(model.reportDefinitions);
            nextToken(model.nextToken);
        }

        public final List<ReportDefinition.Builder> getReportDefinitions() {
            List<ReportDefinition.Builder> result = ReportDefinitionListCopier.copyToBuilder(this.reportDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder reportDefinitions(Collection<ReportDefinition> reportDefinitions) {
            this.reportDefinitions = ReportDefinitionListCopier.copy(reportDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportDefinitions(ReportDefinition... reportDefinitions) {
            reportDefinitions(Arrays.asList(reportDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportDefinitions(Consumer<ReportDefinition.Builder>... reportDefinitions) {
            reportDefinitions(Stream.of(reportDefinitions).map(c -> ReportDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setReportDefinitions(Collection<ReportDefinition.BuilderImpl> reportDefinitions) {
            this.reportDefinitions = ReportDefinitionListCopier.copyFromBuilder(reportDefinitions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListReportDefinitionsResponse build() {
            return new ListReportDefinitionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
