/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationcostprofiler.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of a report in AWS Application Cost Profiler.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<ReportDefinition.Builder, ReportDefinition> {
    private static final SdkField<String> REPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reportId").getter(getter(ReportDefinition::reportId)).setter(setter(Builder::reportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportId").build()).build();

    private static final SdkField<String> REPORT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reportDescription").getter(getter(ReportDefinition::reportDescription))
            .setter(setter(Builder::reportDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportDescription").build()).build();

    private static final SdkField<String> REPORT_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reportFrequency").getter(getter(ReportDefinition::reportFrequencyAsString))
            .setter(setter(Builder::reportFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportFrequency").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(ReportDefinition::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<S3Location> DESTINATION_S3_LOCATION_FIELD = SdkField
            .<S3Location> builder(MarshallingType.SDK_POJO).memberName("destinationS3Location")
            .getter(getter(ReportDefinition::destinationS3Location)).setter(setter(Builder::destinationS3Location))
            .constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationS3Location").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(ReportDefinition::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(ReportDefinition::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_ID_FIELD,
            REPORT_DESCRIPTION_FIELD, REPORT_FREQUENCY_FIELD, FORMAT_FIELD, DESTINATION_S3_LOCATION_FIELD, CREATED_AT_FIELD,
            LAST_UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String reportId;

    private final String reportDescription;

    private final String reportFrequency;

    private final String format;

    private final S3Location destinationS3Location;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private ReportDefinition(BuilderImpl builder) {
        this.reportId = builder.reportId;
        this.reportDescription = builder.reportDescription;
        this.reportFrequency = builder.reportFrequency;
        this.format = builder.format;
        this.destinationS3Location = builder.destinationS3Location;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    /**
     * <p>
     * The ID of the report.
     * </p>
     * 
     * @return The ID of the report.
     */
    public final String reportId() {
        return reportId;
    }

    /**
     * <p>
     * Description of the report
     * </p>
     * 
     * @return Description of the report
     */
    public final String reportDescription() {
        return reportDescription;
    }

    /**
     * <p>
     * The cadence at which the report is generated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reportFrequency}
     * will return {@link ReportFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reportFrequencyAsString}.
     * </p>
     * 
     * @return The cadence at which the report is generated.
     * @see ReportFrequency
     */
    public final ReportFrequency reportFrequency() {
        return ReportFrequency.fromValue(reportFrequency);
    }

    /**
     * <p>
     * The cadence at which the report is generated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reportFrequency}
     * will return {@link ReportFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reportFrequencyAsString}.
     * </p>
     * 
     * @return The cadence at which the report is generated.
     * @see ReportFrequency
     */
    public final String reportFrequencyAsString() {
        return reportFrequency;
    }

    /**
     * <p>
     * The format used for the generated reports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format used for the generated reports.
     * @see Format
     */
    public final Format format() {
        return Format.fromValue(format);
    }

    /**
     * <p>
     * The format used for the generated reports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format used for the generated reports.
     * @see Format
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The location in Amazon Simple Storage Service (Amazon S3) the reports should be saved to.
     * </p>
     * 
     * @return The location in Amazon Simple Storage Service (Amazon S3) the reports should be saved to.
     */
    public final S3Location destinationS3Location() {
        return destinationS3Location;
    }

    /**
     * <p>
     * Timestamp (milliseconds) when this report definition was created.
     * </p>
     * 
     * @return Timestamp (milliseconds) when this report definition was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Timestamp (milliseconds) when this report definition was last updated.
     * </p>
     * 
     * @return Timestamp (milliseconds) when this report definition was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reportId());
        hashCode = 31 * hashCode + Objects.hashCode(reportDescription());
        hashCode = 31 * hashCode + Objects.hashCode(reportFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportDefinition)) {
            return false;
        }
        ReportDefinition other = (ReportDefinition) obj;
        return Objects.equals(reportId(), other.reportId()) && Objects.equals(reportDescription(), other.reportDescription())
                && Objects.equals(reportFrequencyAsString(), other.reportFrequencyAsString())
                && Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(destinationS3Location(), other.destinationS3Location())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReportDefinition").add("ReportId", reportId()).add("ReportDescription", reportDescription())
                .add("ReportFrequency", reportFrequencyAsString()).add("Format", formatAsString())
                .add("DestinationS3Location", destinationS3Location()).add("CreatedAt", createdAt())
                .add("LastUpdatedAt", lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reportId":
            return Optional.ofNullable(clazz.cast(reportId()));
        case "reportDescription":
            return Optional.ofNullable(clazz.cast(reportDescription()));
        case "reportFrequency":
            return Optional.ofNullable(clazz.cast(reportFrequencyAsString()));
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "destinationS3Location":
            return Optional.ofNullable(clazz.cast(destinationS3Location()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportDefinition, T> g) {
        return obj -> g.apply((ReportDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReportDefinition> {
        /**
         * <p>
         * The ID of the report.
         * </p>
         * 
         * @param reportId
         *        The ID of the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportId(String reportId);

        /**
         * <p>
         * Description of the report
         * </p>
         * 
         * @param reportDescription
         *        Description of the report
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportDescription(String reportDescription);

        /**
         * <p>
         * The cadence at which the report is generated.
         * </p>
         * 
         * @param reportFrequency
         *        The cadence at which the report is generated.
         * @see ReportFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportFrequency
         */
        Builder reportFrequency(String reportFrequency);

        /**
         * <p>
         * The cadence at which the report is generated.
         * </p>
         * 
         * @param reportFrequency
         *        The cadence at which the report is generated.
         * @see ReportFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportFrequency
         */
        Builder reportFrequency(ReportFrequency reportFrequency);

        /**
         * <p>
         * The format used for the generated reports.
         * </p>
         * 
         * @param format
         *        The format used for the generated reports.
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(String format);

        /**
         * <p>
         * The format used for the generated reports.
         * </p>
         * 
         * @param format
         *        The format used for the generated reports.
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(Format format);

        /**
         * <p>
         * The location in Amazon Simple Storage Service (Amazon S3) the reports should be saved to.
         * </p>
         * 
         * @param destinationS3Location
         *        The location in Amazon Simple Storage Service (Amazon S3) the reports should be saved to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationS3Location(S3Location destinationS3Location);

        /**
         * <p>
         * The location in Amazon Simple Storage Service (Amazon S3) the reports should be saved to.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Location.Builder} avoiding the need to create
         * one manually via {@link S3Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #destinationS3Location(S3Location)}.
         * 
         * @param destinationS3Location
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationS3Location(S3Location)
         */
        default Builder destinationS3Location(Consumer<S3Location.Builder> destinationS3Location) {
            return destinationS3Location(S3Location.builder().applyMutation(destinationS3Location).build());
        }

        /**
         * <p>
         * Timestamp (milliseconds) when this report definition was created.
         * </p>
         * 
         * @param createdAt
         *        Timestamp (milliseconds) when this report definition was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Timestamp (milliseconds) when this report definition was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        Timestamp (milliseconds) when this report definition was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String reportId;

        private String reportDescription;

        private String reportFrequency;

        private String format;

        private S3Location destinationS3Location;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportDefinition model) {
            reportId(model.reportId);
            reportDescription(model.reportDescription);
            reportFrequency(model.reportFrequency);
            format(model.format);
            destinationS3Location(model.destinationS3Location);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getReportId() {
            return reportId;
        }

        public final void setReportId(String reportId) {
            this.reportId = reportId;
        }

        @Override
        @Transient
        public final Builder reportId(String reportId) {
            this.reportId = reportId;
            return this;
        }

        public final String getReportDescription() {
            return reportDescription;
        }

        public final void setReportDescription(String reportDescription) {
            this.reportDescription = reportDescription;
        }

        @Override
        @Transient
        public final Builder reportDescription(String reportDescription) {
            this.reportDescription = reportDescription;
            return this;
        }

        public final String getReportFrequency() {
            return reportFrequency;
        }

        public final void setReportFrequency(String reportFrequency) {
            this.reportFrequency = reportFrequency;
        }

        @Override
        @Transient
        public final Builder reportFrequency(String reportFrequency) {
            this.reportFrequency = reportFrequency;
            return this;
        }

        @Override
        @Transient
        public final Builder reportFrequency(ReportFrequency reportFrequency) {
            this.reportFrequency(reportFrequency == null ? null : reportFrequency.toString());
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        @Transient
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        @Transient
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final S3Location.Builder getDestinationS3Location() {
            return destinationS3Location != null ? destinationS3Location.toBuilder() : null;
        }

        public final void setDestinationS3Location(S3Location.BuilderImpl destinationS3Location) {
            this.destinationS3Location = destinationS3Location != null ? destinationS3Location.build() : null;
        }

        @Override
        @Transient
        public final Builder destinationS3Location(S3Location destinationS3Location) {
            this.destinationS3Location = destinationS3Location;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        @Transient
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public ReportDefinition build() {
            return new ReportDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
