/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Tags for a configuration item. Tags are metadata that help you categorize IT assets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationTag implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationTag.Builder, ConfigurationTag> {
    private static final SdkField<String> CONFIGURATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configurationType").getter(getter(ConfigurationTag::configurationTypeAsString))
            .setter(setter(Builder::configurationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationType").build()).build();

    private static final SdkField<String> CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configurationId").getter(getter(ConfigurationTag::configurationId))
            .setter(setter(Builder::configurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationId").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(ConfigurationTag::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(ConfigurationTag::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<Instant> TIME_OF_CREATION_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("timeOfCreation").getter(getter(ConfigurationTag::timeOfCreation))
            .setter(setter(Builder::timeOfCreation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeOfCreation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_TYPE_FIELD,
            CONFIGURATION_ID_FIELD, KEY_FIELD, VALUE_FIELD, TIME_OF_CREATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String configurationType;

    private final String configurationId;

    private final String key;

    private final String value;

    private final Instant timeOfCreation;

    private ConfigurationTag(BuilderImpl builder) {
        this.configurationType = builder.configurationType;
        this.configurationId = builder.configurationId;
        this.key = builder.key;
        this.value = builder.value;
        this.timeOfCreation = builder.timeOfCreation;
    }

    /**
     * <p>
     * A type of IT asset to tag.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configurationType}
     * will return {@link ConfigurationItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #configurationTypeAsString}.
     * </p>
     * 
     * @return A type of IT asset to tag.
     * @see ConfigurationItemType
     */
    public ConfigurationItemType configurationType() {
        return ConfigurationItemType.fromValue(configurationType);
    }

    /**
     * <p>
     * A type of IT asset to tag.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configurationType}
     * will return {@link ConfigurationItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #configurationTypeAsString}.
     * </p>
     * 
     * @return A type of IT asset to tag.
     * @see ConfigurationItemType
     */
    public String configurationTypeAsString() {
        return configurationType;
    }

    /**
     * <p>
     * The configuration ID for the item to tag. You can specify a list of keys and values.
     * </p>
     * 
     * @return The configuration ID for the item to tag. You can specify a list of keys and values.
     */
    public String configurationId() {
        return configurationId;
    }

    /**
     * <p>
     * A type of tag on which to filter. For example, <i>serverType</i>.
     * </p>
     * 
     * @return A type of tag on which to filter. For example, <i>serverType</i>.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * A value on which to filter. For example <i>key = serverType</i> and <i>value = web server</i>.
     * </p>
     * 
     * @return A value on which to filter. For example <i>key = serverType</i> and <i>value = web server</i>.
     */
    public String value() {
        return value;
    }

    /**
     * <p>
     * The time the configuration tag was created in Coordinated Universal Time (UTC).
     * </p>
     * 
     * @return The time the configuration tag was created in Coordinated Universal Time (UTC).
     */
    public Instant timeOfCreation() {
        return timeOfCreation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configurationId());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(timeOfCreation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationTag)) {
            return false;
        }
        ConfigurationTag other = (ConfigurationTag) obj;
        return Objects.equals(configurationTypeAsString(), other.configurationTypeAsString())
                && Objects.equals(configurationId(), other.configurationId()) && Objects.equals(key(), other.key())
                && Objects.equals(value(), other.value()) && Objects.equals(timeOfCreation(), other.timeOfCreation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConfigurationTag").add("ConfigurationType", configurationTypeAsString())
                .add("ConfigurationId", configurationId()).add("Key", key()).add("Value", value())
                .add("TimeOfCreation", timeOfCreation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configurationType":
            return Optional.ofNullable(clazz.cast(configurationTypeAsString()));
        case "configurationId":
            return Optional.ofNullable(clazz.cast(configurationId()));
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "timeOfCreation":
            return Optional.ofNullable(clazz.cast(timeOfCreation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationTag, T> g) {
        return obj -> g.apply((ConfigurationTag) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationTag> {
        /**
         * <p>
         * A type of IT asset to tag.
         * </p>
         * 
         * @param configurationType
         *        A type of IT asset to tag.
         * @see ConfigurationItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationItemType
         */
        Builder configurationType(String configurationType);

        /**
         * <p>
         * A type of IT asset to tag.
         * </p>
         * 
         * @param configurationType
         *        A type of IT asset to tag.
         * @see ConfigurationItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationItemType
         */
        Builder configurationType(ConfigurationItemType configurationType);

        /**
         * <p>
         * The configuration ID for the item to tag. You can specify a list of keys and values.
         * </p>
         * 
         * @param configurationId
         *        The configuration ID for the item to tag. You can specify a list of keys and values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationId(String configurationId);

        /**
         * <p>
         * A type of tag on which to filter. For example, <i>serverType</i>.
         * </p>
         * 
         * @param key
         *        A type of tag on which to filter. For example, <i>serverType</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * A value on which to filter. For example <i>key = serverType</i> and <i>value = web server</i>.
         * </p>
         * 
         * @param value
         *        A value on which to filter. For example <i>key = serverType</i> and <i>value = web server</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The time the configuration tag was created in Coordinated Universal Time (UTC).
         * </p>
         * 
         * @param timeOfCreation
         *        The time the configuration tag was created in Coordinated Universal Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeOfCreation(Instant timeOfCreation);
    }

    static final class BuilderImpl implements Builder {
        private String configurationType;

        private String configurationId;

        private String key;

        private String value;

        private Instant timeOfCreation;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationTag model) {
            configurationType(model.configurationType);
            configurationId(model.configurationId);
            key(model.key);
            value(model.value);
            timeOfCreation(model.timeOfCreation);
        }

        public final String getConfigurationType() {
            return configurationType;
        }

        @Override
        public final Builder configurationType(String configurationType) {
            this.configurationType = configurationType;
            return this;
        }

        @Override
        public final Builder configurationType(ConfigurationItemType configurationType) {
            this.configurationType(configurationType == null ? null : configurationType.toString());
            return this;
        }

        public final void setConfigurationType(String configurationType) {
            this.configurationType = configurationType;
        }

        public final String getConfigurationId() {
            return configurationId;
        }

        @Override
        public final Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public final void setConfigurationId(String configurationId) {
            this.configurationId = configurationId;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Instant getTimeOfCreation() {
            return timeOfCreation;
        }

        @Override
        public final Builder timeOfCreation(Instant timeOfCreation) {
            this.timeOfCreation = timeOfCreation;
            return this;
        }

        public final void setTimeOfCreation(Instant timeOfCreation) {
            this.timeOfCreation = timeOfCreation;
        }

        @Override
        public ConfigurationTag build() {
            return new ConfigurationTag(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
