/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteApplicationsRequest extends ApplicationDiscoveryRequest implements
        ToCopyableBuilder<DeleteApplicationsRequest.Builder, DeleteApplicationsRequest> {
    private static final SdkField<List<String>> CONFIGURATION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("configurationIds")
            .getter(getter(DeleteApplicationsRequest::configurationIds))
            .setter(setter(Builder::configurationIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_IDS_FIELD));

    private final List<String> configurationIds;

    private DeleteApplicationsRequest(BuilderImpl builder) {
        super(builder);
        this.configurationIds = builder.configurationIds;
    }

    /**
     * Returns true if the ConfigurationIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasConfigurationIds() {
        return configurationIds != null && !(configurationIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configuration ID of an application to be deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConfigurationIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Configuration ID of an application to be deleted.
     */
    public List<String> configurationIds() {
        return configurationIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurationIds() ? configurationIds() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApplicationsRequest)) {
            return false;
        }
        DeleteApplicationsRequest other = (DeleteApplicationsRequest) obj;
        return hasConfigurationIds() == other.hasConfigurationIds()
                && Objects.equals(configurationIds(), other.configurationIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteApplicationsRequest")
                .add("ConfigurationIds", hasConfigurationIds() ? configurationIds() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configurationIds":
            return Optional.ofNullable(clazz.cast(configurationIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteApplicationsRequest, T> g) {
        return obj -> g.apply((DeleteApplicationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationDiscoveryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteApplicationsRequest> {
        /**
         * <p>
         * Configuration ID of an application to be deleted.
         * </p>
         * 
         * @param configurationIds
         *        Configuration ID of an application to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationIds(Collection<String> configurationIds);

        /**
         * <p>
         * Configuration ID of an application to be deleted.
         * </p>
         * 
         * @param configurationIds
         *        Configuration ID of an application to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationIds(String... configurationIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationDiscoveryRequest.BuilderImpl implements Builder {
        private List<String> configurationIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApplicationsRequest model) {
            super(model);
            configurationIds(model.configurationIds);
        }

        public final Collection<String> getConfigurationIds() {
            if (configurationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return configurationIds;
        }

        @Override
        public final Builder configurationIds(Collection<String> configurationIds) {
            this.configurationIds = ApplicationIdsListCopier.copy(configurationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationIds(String... configurationIds) {
            configurationIds(Arrays.asList(configurationIds));
            return this;
        }

        public final void setConfigurationIds(Collection<String> configurationIds) {
            this.configurationIds = ApplicationIdsListCopier.copy(configurationIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteApplicationsRequest build() {
            return new DeleteApplicationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
