/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeExportTasksRequest extends ApplicationDiscoveryRequest implements
        ToCopyableBuilder<DescribeExportTasksRequest.Builder, DescribeExportTasksRequest> {
    private static final SdkField<List<String>> EXPORT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("exportIds")
            .getter(getter(DescribeExportTasksRequest::exportIds))
            .setter(setter(Builder::exportIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ExportFilter>> FILTERS_FIELD = SdkField
            .<List<ExportFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(DescribeExportTasksRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExportFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExportFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribeExportTasksRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeExportTasksRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_IDS_FIELD,
            FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> exportIds;

    private final List<ExportFilter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeExportTasksRequest(BuilderImpl builder) {
        super(builder);
        this.exportIds = builder.exportIds;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ExportIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasExportIds() {
        return exportIds != null && !(exportIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more unique identifiers used to query the status of an export request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExportIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more unique identifiers used to query the status of an export request.
     */
    public List<String> exportIds() {
        return exportIds;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AgentId</code> - ID of the agent whose collected data will be exported
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AgentId</code> - ID of the agent whose collected data will be exported
     *         </p>
     *         </li>
     */
    public List<ExportFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of volume results returned by <code>DescribeExportTasks</code> in paginated output. When this
     * parameter is used, <code>DescribeExportTasks</code> only returns <code>maxResults</code> results in a single page
     * along with a <code>nextToken</code> response element.
     * </p>
     * 
     * @return The maximum number of volume results returned by <code>DescribeExportTasks</code> in paginated output.
     *         When this parameter is used, <code>DescribeExportTasks</code> only returns <code>maxResults</code>
     *         results in a single page along with a <code>nextToken</code> response element.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>DescribeExportTasks</code> request
     * where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues
     * from the end of the previous results that returned the <code>nextToken</code> value. This value is null when
     * there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated <code>DescribeExportTasks</code>
     *         request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
     *         Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.
     *         This value is null when there are no more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasExportIds() ? exportIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExportTasksRequest)) {
            return false;
        }
        DescribeExportTasksRequest other = (DescribeExportTasksRequest) obj;
        return hasExportIds() == other.hasExportIds() && Objects.equals(exportIds(), other.exportIds())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeExportTasksRequest").add("ExportIds", hasExportIds() ? exportIds() : null)
                .add("Filters", hasFilters() ? filters() : null).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exportIds":
            return Optional.ofNullable(clazz.cast(exportIds()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeExportTasksRequest, T> g) {
        return obj -> g.apply((DescribeExportTasksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationDiscoveryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeExportTasksRequest> {
        /**
         * <p>
         * One or more unique identifiers used to query the status of an export request.
         * </p>
         * 
         * @param exportIds
         *        One or more unique identifiers used to query the status of an export request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportIds(Collection<String> exportIds);

        /**
         * <p>
         * One or more unique identifiers used to query the status of an export request.
         * </p>
         * 
         * @param exportIds
         *        One or more unique identifiers used to query the status of an export request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportIds(String... exportIds);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AgentId</code> - ID of the agent whose collected data will be exported
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AgentId</code> - ID of the agent whose collected data will be exported
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<ExportFilter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AgentId</code> - ID of the agent whose collected data will be exported
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AgentId</code> - ID of the agent whose collected data will be exported
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ExportFilter... filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AgentId</code> - ID of the agent whose collected data will be exported
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<ExportFilter>.Builder} avoiding the need to
         * create one manually via {@link List<ExportFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExportFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<ExportFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<ExportFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<ExportFilter>)
         */
        Builder filters(Consumer<ExportFilter.Builder>... filters);

        /**
         * <p>
         * The maximum number of volume results returned by <code>DescribeExportTasks</code> in paginated output. When
         * this parameter is used, <code>DescribeExportTasks</code> only returns <code>maxResults</code> results in a
         * single page along with a <code>nextToken</code> response element.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of volume results returned by <code>DescribeExportTasks</code> in paginated output.
         *        When this parameter is used, <code>DescribeExportTasks</code> only returns <code>maxResults</code>
         *        results in a single page along with a <code>nextToken</code> response element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>DescribeExportTasks</code> request
         * where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
         * continues from the end of the previous results that returned the <code>nextToken</code> value. This value is
         * null when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated <code>DescribeExportTasks</code>
         *        request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
         *        Pagination continues from the end of the previous results that returned the <code>nextToken</code>
         *        value. This value is null when there are no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationDiscoveryRequest.BuilderImpl implements Builder {
        private List<String> exportIds = DefaultSdkAutoConstructList.getInstance();

        private List<ExportFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExportTasksRequest model) {
            super(model);
            exportIds(model.exportIds);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getExportIds() {
            if (exportIds instanceof SdkAutoConstructList) {
                return null;
            }
            return exportIds;
        }

        @Override
        public final Builder exportIds(Collection<String> exportIds) {
            this.exportIds = ExportIdsCopier.copy(exportIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportIds(String... exportIds) {
            exportIds(Arrays.asList(exportIds));
            return this;
        }

        public final void setExportIds(Collection<String> exportIds) {
            this.exportIds = ExportIdsCopier.copy(exportIds);
        }

        public final Collection<ExportFilter.Builder> getFilters() {
            if (filters instanceof SdkAutoConstructList) {
                return null;
            }
            return filters != null ? filters.stream().map(ExportFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<ExportFilter> filters) {
            this.filters = ExportFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ExportFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ExportFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> ExportFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<ExportFilter.BuilderImpl> filters) {
            this.filters = ExportFiltersCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeExportTasksRequest build() {
            return new DescribeExportTasksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
