/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTagsResponse extends ApplicationDiscoveryResponse implements
        ToCopyableBuilder<DescribeTagsResponse.Builder, DescribeTagsResponse> {
    private static final SdkField<List<ConfigurationTag>> TAGS_FIELD = SdkField
            .<List<ConfigurationTag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(DescribeTagsResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurationTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeTagsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGS_FIELD, NEXT_TOKEN_FIELD));

    private final List<ConfigurationTag> tags;

    private final String nextToken;

    private DescribeTagsResponse(BuilderImpl builder) {
        super(builder);
        this.tags = builder.tags;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Depending on the input, this is a list of configuration items tagged with a specific tag, or a list of tags for a
     * specific configuration item.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Depending on the input, this is a list of configuration items tagged with a specific tag, or a list of
     *         tags for a specific configuration item.
     */
    public List<ConfigurationTag> tags() {
        return tags;
    }

    /**
     * <p>
     * The call returns a token. Use this token to get the next set of results.
     * </p>
     * 
     * @return The call returns a token. Use this token to get the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsResponse)) {
            return false;
        }
        DescribeTagsResponse other = (DescribeTagsResponse) obj;
        return hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeTagsResponse").add("Tags", hasTags() ? tags() : null).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTagsResponse, T> g) {
        return obj -> g.apply((DescribeTagsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationDiscoveryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTagsResponse> {
        /**
         * <p>
         * Depending on the input, this is a list of configuration items tagged with a specific tag, or a list of tags
         * for a specific configuration item.
         * </p>
         * 
         * @param tags
         *        Depending on the input, this is a list of configuration items tagged with a specific tag, or a list of
         *        tags for a specific configuration item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<ConfigurationTag> tags);

        /**
         * <p>
         * Depending on the input, this is a list of configuration items tagged with a specific tag, or a list of tags
         * for a specific configuration item.
         * </p>
         * 
         * @param tags
         *        Depending on the input, this is a list of configuration items tagged with a specific tag, or a list of
         *        tags for a specific configuration item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(ConfigurationTag... tags);

        /**
         * <p>
         * Depending on the input, this is a list of configuration items tagged with a specific tag, or a list of tags
         * for a specific configuration item.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConfigurationTag>.Builder} avoiding the
         * need to create one manually via {@link List<ConfigurationTag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConfigurationTag>.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<ConfigurationTag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<ConfigurationTag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<ConfigurationTag>)
         */
        Builder tags(Consumer<ConfigurationTag.Builder>... tags);

        /**
         * <p>
         * The call returns a token. Use this token to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The call returns a token. Use this token to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ApplicationDiscoveryResponse.BuilderImpl implements Builder {
        private List<ConfigurationTag> tags = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTagsResponse model) {
            super(model);
            tags(model.tags);
            nextToken(model.nextToken);
        }

        public final Collection<ConfigurationTag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(ConfigurationTag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<ConfigurationTag> tags) {
            this.tags = ConfigurationTagSetCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(ConfigurationTag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<ConfigurationTag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> ConfigurationTag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<ConfigurationTag.BuilderImpl> tags) {
            this.tags = ConfigurationTagSetCopier.copyFromBuilder(tags);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeTagsResponse build() {
            return new DescribeTagsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
