/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An array of information related to the import task request that includes status information, times, IDs, the Amazon
 * S3 Object URL for the import file, and more.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportTask implements SdkPojo, Serializable, ToCopyableBuilder<ImportTask.Builder, ImportTask> {
    private static final SdkField<String> IMPORT_TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importTaskId").getter(getter(ImportTask::importTaskId)).setter(setter(Builder::importTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importTaskId").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken").getter(getter(ImportTask::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ImportTask::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> IMPORT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importUrl").getter(getter(ImportTask::importUrl)).setter(setter(Builder::importUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importUrl").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ImportTask::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> IMPORT_REQUEST_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("importRequestTime").getter(getter(ImportTask::importRequestTime))
            .setter(setter(Builder::importRequestTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importRequestTime").build()).build();

    private static final SdkField<Instant> IMPORT_COMPLETION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("importCompletionTime").getter(getter(ImportTask::importCompletionTime))
            .setter(setter(Builder::importCompletionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importCompletionTime").build())
            .build();

    private static final SdkField<Instant> IMPORT_DELETED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("importDeletedTime").getter(getter(ImportTask::importDeletedTime))
            .setter(setter(Builder::importDeletedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importDeletedTime").build()).build();

    private static final SdkField<Integer> SERVER_IMPORT_SUCCESS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("serverImportSuccess").getter(getter(ImportTask::serverImportSuccess))
            .setter(setter(Builder::serverImportSuccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverImportSuccess").build())
            .build();

    private static final SdkField<Integer> SERVER_IMPORT_FAILURE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("serverImportFailure").getter(getter(ImportTask::serverImportFailure))
            .setter(setter(Builder::serverImportFailure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverImportFailure").build())
            .build();

    private static final SdkField<Integer> APPLICATION_IMPORT_SUCCESS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("applicationImportSuccess").getter(getter(ImportTask::applicationImportSuccess))
            .setter(setter(Builder::applicationImportSuccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationImportSuccess").build())
            .build();

    private static final SdkField<Integer> APPLICATION_IMPORT_FAILURE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("applicationImportFailure").getter(getter(ImportTask::applicationImportFailure))
            .setter(setter(Builder::applicationImportFailure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationImportFailure").build())
            .build();

    private static final SdkField<String> ERRORS_AND_FAILED_ENTRIES_ZIP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorsAndFailedEntriesZip").getter(getter(ImportTask::errorsAndFailedEntriesZip))
            .setter(setter(Builder::errorsAndFailedEntriesZip))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorsAndFailedEntriesZip").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_TASK_ID_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, NAME_FIELD, IMPORT_URL_FIELD, STATUS_FIELD, IMPORT_REQUEST_TIME_FIELD,
            IMPORT_COMPLETION_TIME_FIELD, IMPORT_DELETED_TIME_FIELD, SERVER_IMPORT_SUCCESS_FIELD, SERVER_IMPORT_FAILURE_FIELD,
            APPLICATION_IMPORT_SUCCESS_FIELD, APPLICATION_IMPORT_FAILURE_FIELD, ERRORS_AND_FAILED_ENTRIES_ZIP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String importTaskId;

    private final String clientRequestToken;

    private final String name;

    private final String importUrl;

    private final String status;

    private final Instant importRequestTime;

    private final Instant importCompletionTime;

    private final Instant importDeletedTime;

    private final Integer serverImportSuccess;

    private final Integer serverImportFailure;

    private final Integer applicationImportSuccess;

    private final Integer applicationImportFailure;

    private final String errorsAndFailedEntriesZip;

    private ImportTask(BuilderImpl builder) {
        this.importTaskId = builder.importTaskId;
        this.clientRequestToken = builder.clientRequestToken;
        this.name = builder.name;
        this.importUrl = builder.importUrl;
        this.status = builder.status;
        this.importRequestTime = builder.importRequestTime;
        this.importCompletionTime = builder.importCompletionTime;
        this.importDeletedTime = builder.importDeletedTime;
        this.serverImportSuccess = builder.serverImportSuccess;
        this.serverImportFailure = builder.serverImportFailure;
        this.applicationImportSuccess = builder.applicationImportSuccess;
        this.applicationImportFailure = builder.applicationImportFailure;
        this.errorsAndFailedEntriesZip = builder.errorsAndFailedEntriesZip;
    }

    /**
     * <p>
     * The unique ID for a specific import task. These IDs aren't globally unique, but they are unique within an AWS
     * account.
     * </p>
     * 
     * @return The unique ID for a specific import task. These IDs aren't globally unique, but they are unique within an
     *         AWS account.
     */
    public String importTaskId() {
        return importTaskId;
    }

    /**
     * <p>
     * A unique token used to prevent the same import request from occurring more than once. If you didn't provide a
     * token, a token was automatically generated when the import task request was sent.
     * </p>
     * 
     * @return A unique token used to prevent the same import request from occurring more than once. If you didn't
     *         provide a token, a token was automatically generated when the import task request was sent.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * A descriptive name for an import task. You can use this name to filter future requests related to this import
     * task, such as identifying applications and servers that were included in this import task. We recommend that you
     * use a meaningful name for each import task.
     * </p>
     * 
     * @return A descriptive name for an import task. You can use this name to filter future requests related to this
     *         import task, such as identifying applications and servers that were included in this import task. We
     *         recommend that you use a meaningful name for each import task.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The URL for your import file that you've uploaded to Amazon S3.
     * </p>
     * 
     * @return The URL for your import file that you've uploaded to Amazon S3.
     */
    public String importUrl() {
        return importUrl;
    }

    /**
     * <p>
     * The status of the import task. An import can have the status of <code>IMPORT_COMPLETE</code> and still have some
     * records fail to import from the overall request. More information can be found in the downloadable archive
     * defined in the <code>errorsAndFailedEntriesZip</code> field, or in the Migration Hub management console.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ImportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the import task. An import can have the status of <code>IMPORT_COMPLETE</code> and still
     *         have some records fail to import from the overall request. More information can be found in the
     *         downloadable archive defined in the <code>errorsAndFailedEntriesZip</code> field, or in the Migration Hub
     *         management console.
     * @see ImportStatus
     */
    public ImportStatus status() {
        return ImportStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the import task. An import can have the status of <code>IMPORT_COMPLETE</code> and still have some
     * records fail to import from the overall request. More information can be found in the downloadable archive
     * defined in the <code>errorsAndFailedEntriesZip</code> field, or in the Migration Hub management console.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ImportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the import task. An import can have the status of <code>IMPORT_COMPLETE</code> and still
     *         have some records fail to import from the overall request. More information can be found in the
     *         downloadable archive defined in the <code>errorsAndFailedEntriesZip</code> field, or in the Migration Hub
     *         management console.
     * @see ImportStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time that the import task request was made, presented in the Unix time stamp format.
     * </p>
     * 
     * @return The time that the import task request was made, presented in the Unix time stamp format.
     */
    public Instant importRequestTime() {
        return importRequestTime;
    }

    /**
     * <p>
     * The time that the import task request finished, presented in the Unix time stamp format.
     * </p>
     * 
     * @return The time that the import task request finished, presented in the Unix time stamp format.
     */
    public Instant importCompletionTime() {
        return importCompletionTime;
    }

    /**
     * <p>
     * The time that the import task request was deleted, presented in the Unix time stamp format.
     * </p>
     * 
     * @return The time that the import task request was deleted, presented in the Unix time stamp format.
     */
    public Instant importDeletedTime() {
        return importDeletedTime;
    }

    /**
     * <p>
     * The total number of server records in the import file that were successfully imported.
     * </p>
     * 
     * @return The total number of server records in the import file that were successfully imported.
     */
    public Integer serverImportSuccess() {
        return serverImportSuccess;
    }

    /**
     * <p>
     * The total number of server records in the import file that failed to be imported.
     * </p>
     * 
     * @return The total number of server records in the import file that failed to be imported.
     */
    public Integer serverImportFailure() {
        return serverImportFailure;
    }

    /**
     * <p>
     * The total number of application records in the import file that were successfully imported.
     * </p>
     * 
     * @return The total number of application records in the import file that were successfully imported.
     */
    public Integer applicationImportSuccess() {
        return applicationImportSuccess;
    }

    /**
     * <p>
     * The total number of application records in the import file that failed to be imported.
     * </p>
     * 
     * @return The total number of application records in the import file that failed to be imported.
     */
    public Integer applicationImportFailure() {
        return applicationImportFailure;
    }

    /**
     * <p>
     * A link to a compressed archive folder (in the ZIP format) that contains an error log and a file of failed
     * records. You can use these two files to quickly identify records that failed, why they failed, and correct those
     * records. Afterward, you can upload the corrected file to your Amazon S3 bucket and create another import task
     * request.
     * </p>
     * <p>
     * This field also includes authorization information so you can confirm the authenticity of the compressed archive
     * before you download it.
     * </p>
     * <p>
     * If some records failed to be imported we recommend that you correct the records in the failed entries file and
     * then imports that failed entries file. This prevents you from having to correct and update the larger original
     * file and attempt importing it again.
     * </p>
     * 
     * @return A link to a compressed archive folder (in the ZIP format) that contains an error log and a file of failed
     *         records. You can use these two files to quickly identify records that failed, why they failed, and
     *         correct those records. Afterward, you can upload the corrected file to your Amazon S3 bucket and create
     *         another import task request.</p>
     *         <p>
     *         This field also includes authorization information so you can confirm the authenticity of the compressed
     *         archive before you download it.
     *         </p>
     *         <p>
     *         If some records failed to be imported we recommend that you correct the records in the failed entries
     *         file and then imports that failed entries file. This prevents you from having to correct and update the
     *         larger original file and attempt importing it again.
     */
    public String errorsAndFailedEntriesZip() {
        return errorsAndFailedEntriesZip;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(importTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(importUrl());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(importRequestTime());
        hashCode = 31 * hashCode + Objects.hashCode(importCompletionTime());
        hashCode = 31 * hashCode + Objects.hashCode(importDeletedTime());
        hashCode = 31 * hashCode + Objects.hashCode(serverImportSuccess());
        hashCode = 31 * hashCode + Objects.hashCode(serverImportFailure());
        hashCode = 31 * hashCode + Objects.hashCode(applicationImportSuccess());
        hashCode = 31 * hashCode + Objects.hashCode(applicationImportFailure());
        hashCode = 31 * hashCode + Objects.hashCode(errorsAndFailedEntriesZip());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportTask)) {
            return false;
        }
        ImportTask other = (ImportTask) obj;
        return Objects.equals(importTaskId(), other.importTaskId())
                && Objects.equals(clientRequestToken(), other.clientRequestToken()) && Objects.equals(name(), other.name())
                && Objects.equals(importUrl(), other.importUrl()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(importRequestTime(), other.importRequestTime())
                && Objects.equals(importCompletionTime(), other.importCompletionTime())
                && Objects.equals(importDeletedTime(), other.importDeletedTime())
                && Objects.equals(serverImportSuccess(), other.serverImportSuccess())
                && Objects.equals(serverImportFailure(), other.serverImportFailure())
                && Objects.equals(applicationImportSuccess(), other.applicationImportSuccess())
                && Objects.equals(applicationImportFailure(), other.applicationImportFailure())
                && Objects.equals(errorsAndFailedEntriesZip(), other.errorsAndFailedEntriesZip());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ImportTask").add("ImportTaskId", importTaskId()).add("ClientRequestToken", clientRequestToken())
                .add("Name", name()).add("ImportUrl", importUrl()).add("Status", statusAsString())
                .add("ImportRequestTime", importRequestTime()).add("ImportCompletionTime", importCompletionTime())
                .add("ImportDeletedTime", importDeletedTime()).add("ServerImportSuccess", serverImportSuccess())
                .add("ServerImportFailure", serverImportFailure()).add("ApplicationImportSuccess", applicationImportSuccess())
                .add("ApplicationImportFailure", applicationImportFailure())
                .add("ErrorsAndFailedEntriesZip", errorsAndFailedEntriesZip()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "importTaskId":
            return Optional.ofNullable(clazz.cast(importTaskId()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "importUrl":
            return Optional.ofNullable(clazz.cast(importUrl()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "importRequestTime":
            return Optional.ofNullable(clazz.cast(importRequestTime()));
        case "importCompletionTime":
            return Optional.ofNullable(clazz.cast(importCompletionTime()));
        case "importDeletedTime":
            return Optional.ofNullable(clazz.cast(importDeletedTime()));
        case "serverImportSuccess":
            return Optional.ofNullable(clazz.cast(serverImportSuccess()));
        case "serverImportFailure":
            return Optional.ofNullable(clazz.cast(serverImportFailure()));
        case "applicationImportSuccess":
            return Optional.ofNullable(clazz.cast(applicationImportSuccess()));
        case "applicationImportFailure":
            return Optional.ofNullable(clazz.cast(applicationImportFailure()));
        case "errorsAndFailedEntriesZip":
            return Optional.ofNullable(clazz.cast(errorsAndFailedEntriesZip()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportTask, T> g) {
        return obj -> g.apply((ImportTask) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportTask> {
        /**
         * <p>
         * The unique ID for a specific import task. These IDs aren't globally unique, but they are unique within an AWS
         * account.
         * </p>
         * 
         * @param importTaskId
         *        The unique ID for a specific import task. These IDs aren't globally unique, but they are unique within
         *        an AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importTaskId(String importTaskId);

        /**
         * <p>
         * A unique token used to prevent the same import request from occurring more than once. If you didn't provide a
         * token, a token was automatically generated when the import task request was sent.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique token used to prevent the same import request from occurring more than once. If you didn't
         *        provide a token, a token was automatically generated when the import task request was sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * A descriptive name for an import task. You can use this name to filter future requests related to this import
         * task, such as identifying applications and servers that were included in this import task. We recommend that
         * you use a meaningful name for each import task.
         * </p>
         * 
         * @param name
         *        A descriptive name for an import task. You can use this name to filter future requests related to this
         *        import task, such as identifying applications and servers that were included in this import task. We
         *        recommend that you use a meaningful name for each import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The URL for your import file that you've uploaded to Amazon S3.
         * </p>
         * 
         * @param importUrl
         *        The URL for your import file that you've uploaded to Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importUrl(String importUrl);

        /**
         * <p>
         * The status of the import task. An import can have the status of <code>IMPORT_COMPLETE</code> and still have
         * some records fail to import from the overall request. More information can be found in the downloadable
         * archive defined in the <code>errorsAndFailedEntriesZip</code> field, or in the Migration Hub management
         * console.
         * </p>
         * 
         * @param status
         *        The status of the import task. An import can have the status of <code>IMPORT_COMPLETE</code> and still
         *        have some records fail to import from the overall request. More information can be found in the
         *        downloadable archive defined in the <code>errorsAndFailedEntriesZip</code> field, or in the Migration
         *        Hub management console.
         * @see ImportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the import task. An import can have the status of <code>IMPORT_COMPLETE</code> and still have
         * some records fail to import from the overall request. More information can be found in the downloadable
         * archive defined in the <code>errorsAndFailedEntriesZip</code> field, or in the Migration Hub management
         * console.
         * </p>
         * 
         * @param status
         *        The status of the import task. An import can have the status of <code>IMPORT_COMPLETE</code> and still
         *        have some records fail to import from the overall request. More information can be found in the
         *        downloadable archive defined in the <code>errorsAndFailedEntriesZip</code> field, or in the Migration
         *        Hub management console.
         * @see ImportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportStatus
         */
        Builder status(ImportStatus status);

        /**
         * <p>
         * The time that the import task request was made, presented in the Unix time stamp format.
         * </p>
         * 
         * @param importRequestTime
         *        The time that the import task request was made, presented in the Unix time stamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importRequestTime(Instant importRequestTime);

        /**
         * <p>
         * The time that the import task request finished, presented in the Unix time stamp format.
         * </p>
         * 
         * @param importCompletionTime
         *        The time that the import task request finished, presented in the Unix time stamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importCompletionTime(Instant importCompletionTime);

        /**
         * <p>
         * The time that the import task request was deleted, presented in the Unix time stamp format.
         * </p>
         * 
         * @param importDeletedTime
         *        The time that the import task request was deleted, presented in the Unix time stamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importDeletedTime(Instant importDeletedTime);

        /**
         * <p>
         * The total number of server records in the import file that were successfully imported.
         * </p>
         * 
         * @param serverImportSuccess
         *        The total number of server records in the import file that were successfully imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverImportSuccess(Integer serverImportSuccess);

        /**
         * <p>
         * The total number of server records in the import file that failed to be imported.
         * </p>
         * 
         * @param serverImportFailure
         *        The total number of server records in the import file that failed to be imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverImportFailure(Integer serverImportFailure);

        /**
         * <p>
         * The total number of application records in the import file that were successfully imported.
         * </p>
         * 
         * @param applicationImportSuccess
         *        The total number of application records in the import file that were successfully imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationImportSuccess(Integer applicationImportSuccess);

        /**
         * <p>
         * The total number of application records in the import file that failed to be imported.
         * </p>
         * 
         * @param applicationImportFailure
         *        The total number of application records in the import file that failed to be imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationImportFailure(Integer applicationImportFailure);

        /**
         * <p>
         * A link to a compressed archive folder (in the ZIP format) that contains an error log and a file of failed
         * records. You can use these two files to quickly identify records that failed, why they failed, and correct
         * those records. Afterward, you can upload the corrected file to your Amazon S3 bucket and create another
         * import task request.
         * </p>
         * <p>
         * This field also includes authorization information so you can confirm the authenticity of the compressed
         * archive before you download it.
         * </p>
         * <p>
         * If some records failed to be imported we recommend that you correct the records in the failed entries file
         * and then imports that failed entries file. This prevents you from having to correct and update the larger
         * original file and attempt importing it again.
         * </p>
         * 
         * @param errorsAndFailedEntriesZip
         *        A link to a compressed archive folder (in the ZIP format) that contains an error log and a file of
         *        failed records. You can use these two files to quickly identify records that failed, why they failed,
         *        and correct those records. Afterward, you can upload the corrected file to your Amazon S3 bucket and
         *        create another import task request.</p>
         *        <p>
         *        This field also includes authorization information so you can confirm the authenticity of the
         *        compressed archive before you download it.
         *        </p>
         *        <p>
         *        If some records failed to be imported we recommend that you correct the records in the failed entries
         *        file and then imports that failed entries file. This prevents you from having to correct and update
         *        the larger original file and attempt importing it again.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorsAndFailedEntriesZip(String errorsAndFailedEntriesZip);
    }

    static final class BuilderImpl implements Builder {
        private String importTaskId;

        private String clientRequestToken;

        private String name;

        private String importUrl;

        private String status;

        private Instant importRequestTime;

        private Instant importCompletionTime;

        private Instant importDeletedTime;

        private Integer serverImportSuccess;

        private Integer serverImportFailure;

        private Integer applicationImportSuccess;

        private Integer applicationImportFailure;

        private String errorsAndFailedEntriesZip;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportTask model) {
            importTaskId(model.importTaskId);
            clientRequestToken(model.clientRequestToken);
            name(model.name);
            importUrl(model.importUrl);
            status(model.status);
            importRequestTime(model.importRequestTime);
            importCompletionTime(model.importCompletionTime);
            importDeletedTime(model.importDeletedTime);
            serverImportSuccess(model.serverImportSuccess);
            serverImportFailure(model.serverImportFailure);
            applicationImportSuccess(model.applicationImportSuccess);
            applicationImportFailure(model.applicationImportFailure);
            errorsAndFailedEntriesZip(model.errorsAndFailedEntriesZip);
        }

        public final String getImportTaskId() {
            return importTaskId;
        }

        @Override
        public final Builder importTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
            return this;
        }

        public final void setImportTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getImportUrl() {
            return importUrl;
        }

        @Override
        public final Builder importUrl(String importUrl) {
            this.importUrl = importUrl;
            return this;
        }

        public final void setImportUrl(String importUrl) {
            this.importUrl = importUrl;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ImportStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getImportRequestTime() {
            return importRequestTime;
        }

        @Override
        public final Builder importRequestTime(Instant importRequestTime) {
            this.importRequestTime = importRequestTime;
            return this;
        }

        public final void setImportRequestTime(Instant importRequestTime) {
            this.importRequestTime = importRequestTime;
        }

        public final Instant getImportCompletionTime() {
            return importCompletionTime;
        }

        @Override
        public final Builder importCompletionTime(Instant importCompletionTime) {
            this.importCompletionTime = importCompletionTime;
            return this;
        }

        public final void setImportCompletionTime(Instant importCompletionTime) {
            this.importCompletionTime = importCompletionTime;
        }

        public final Instant getImportDeletedTime() {
            return importDeletedTime;
        }

        @Override
        public final Builder importDeletedTime(Instant importDeletedTime) {
            this.importDeletedTime = importDeletedTime;
            return this;
        }

        public final void setImportDeletedTime(Instant importDeletedTime) {
            this.importDeletedTime = importDeletedTime;
        }

        public final Integer getServerImportSuccess() {
            return serverImportSuccess;
        }

        @Override
        public final Builder serverImportSuccess(Integer serverImportSuccess) {
            this.serverImportSuccess = serverImportSuccess;
            return this;
        }

        public final void setServerImportSuccess(Integer serverImportSuccess) {
            this.serverImportSuccess = serverImportSuccess;
        }

        public final Integer getServerImportFailure() {
            return serverImportFailure;
        }

        @Override
        public final Builder serverImportFailure(Integer serverImportFailure) {
            this.serverImportFailure = serverImportFailure;
            return this;
        }

        public final void setServerImportFailure(Integer serverImportFailure) {
            this.serverImportFailure = serverImportFailure;
        }

        public final Integer getApplicationImportSuccess() {
            return applicationImportSuccess;
        }

        @Override
        public final Builder applicationImportSuccess(Integer applicationImportSuccess) {
            this.applicationImportSuccess = applicationImportSuccess;
            return this;
        }

        public final void setApplicationImportSuccess(Integer applicationImportSuccess) {
            this.applicationImportSuccess = applicationImportSuccess;
        }

        public final Integer getApplicationImportFailure() {
            return applicationImportFailure;
        }

        @Override
        public final Builder applicationImportFailure(Integer applicationImportFailure) {
            this.applicationImportFailure = applicationImportFailure;
            return this;
        }

        public final void setApplicationImportFailure(Integer applicationImportFailure) {
            this.applicationImportFailure = applicationImportFailure;
        }

        public final String getErrorsAndFailedEntriesZip() {
            return errorsAndFailedEntriesZip;
        }

        @Override
        public final Builder errorsAndFailedEntriesZip(String errorsAndFailedEntriesZip) {
            this.errorsAndFailedEntriesZip = errorsAndFailedEntriesZip;
            return this;
        }

        public final void setErrorsAndFailedEntriesZip(String errorsAndFailedEntriesZip) {
            this.errorsAndFailedEntriesZip = errorsAndFailedEntriesZip;
        }

        @Override
        public ImportTask build() {
            return new ImportTask(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
