/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Inventory data for installed discovery connectors.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomerConnectorInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomerConnectorInfo.Builder, CustomerConnectorInfo> {
    private static final SdkField<Integer> ACTIVE_CONNECTORS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("activeConnectors").getter(getter(CustomerConnectorInfo::activeConnectors))
            .setter(setter(Builder::activeConnectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeConnectors").build()).build();

    private static final SdkField<Integer> HEALTHY_CONNECTORS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("healthyConnectors").getter(getter(CustomerConnectorInfo::healthyConnectors))
            .setter(setter(Builder::healthyConnectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthyConnectors").build()).build();

    private static final SdkField<Integer> BLACK_LISTED_CONNECTORS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("blackListedConnectors").getter(getter(CustomerConnectorInfo::blackListedConnectors))
            .setter(setter(Builder::blackListedConnectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blackListedConnectors").build())
            .build();

    private static final SdkField<Integer> SHUTDOWN_CONNECTORS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("shutdownConnectors").getter(getter(CustomerConnectorInfo::shutdownConnectors))
            .setter(setter(Builder::shutdownConnectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shutdownConnectors").build())
            .build();

    private static final SdkField<Integer> UNHEALTHY_CONNECTORS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("unhealthyConnectors").getter(getter(CustomerConnectorInfo::unhealthyConnectors))
            .setter(setter(Builder::unhealthyConnectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unhealthyConnectors").build())
            .build();

    private static final SdkField<Integer> TOTAL_CONNECTORS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalConnectors").getter(getter(CustomerConnectorInfo::totalConnectors))
            .setter(setter(Builder::totalConnectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalConnectors").build()).build();

    private static final SdkField<Integer> UNKNOWN_CONNECTORS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("unknownConnectors").getter(getter(CustomerConnectorInfo::unknownConnectors))
            .setter(setter(Builder::unknownConnectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unknownConnectors").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_CONNECTORS_FIELD,
            HEALTHY_CONNECTORS_FIELD, BLACK_LISTED_CONNECTORS_FIELD, SHUTDOWN_CONNECTORS_FIELD, UNHEALTHY_CONNECTORS_FIELD,
            TOTAL_CONNECTORS_FIELD, UNKNOWN_CONNECTORS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer activeConnectors;

    private final Integer healthyConnectors;

    private final Integer blackListedConnectors;

    private final Integer shutdownConnectors;

    private final Integer unhealthyConnectors;

    private final Integer totalConnectors;

    private final Integer unknownConnectors;

    private CustomerConnectorInfo(BuilderImpl builder) {
        this.activeConnectors = builder.activeConnectors;
        this.healthyConnectors = builder.healthyConnectors;
        this.blackListedConnectors = builder.blackListedConnectors;
        this.shutdownConnectors = builder.shutdownConnectors;
        this.unhealthyConnectors = builder.unhealthyConnectors;
        this.totalConnectors = builder.totalConnectors;
        this.unknownConnectors = builder.unknownConnectors;
    }

    /**
     * <p>
     * Number of active discovery connectors.
     * </p>
     * 
     * @return Number of active discovery connectors.
     */
    public final Integer activeConnectors() {
        return activeConnectors;
    }

    /**
     * <p>
     * Number of healthy discovery connectors.
     * </p>
     * 
     * @return Number of healthy discovery connectors.
     */
    public final Integer healthyConnectors() {
        return healthyConnectors;
    }

    /**
     * <p>
     * Number of blacklisted discovery connectors.
     * </p>
     * 
     * @return Number of blacklisted discovery connectors.
     */
    public final Integer blackListedConnectors() {
        return blackListedConnectors;
    }

    /**
     * <p>
     * Number of discovery connectors with status SHUTDOWN,
     * </p>
     * 
     * @return Number of discovery connectors with status SHUTDOWN,
     */
    public final Integer shutdownConnectors() {
        return shutdownConnectors;
    }

    /**
     * <p>
     * Number of unhealthy discovery connectors.
     * </p>
     * 
     * @return Number of unhealthy discovery connectors.
     */
    public final Integer unhealthyConnectors() {
        return unhealthyConnectors;
    }

    /**
     * <p>
     * Total number of discovery connectors.
     * </p>
     * 
     * @return Total number of discovery connectors.
     */
    public final Integer totalConnectors() {
        return totalConnectors;
    }

    /**
     * <p>
     * Number of unknown discovery connectors.
     * </p>
     * 
     * @return Number of unknown discovery connectors.
     */
    public final Integer unknownConnectors() {
        return unknownConnectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activeConnectors());
        hashCode = 31 * hashCode + Objects.hashCode(healthyConnectors());
        hashCode = 31 * hashCode + Objects.hashCode(blackListedConnectors());
        hashCode = 31 * hashCode + Objects.hashCode(shutdownConnectors());
        hashCode = 31 * hashCode + Objects.hashCode(unhealthyConnectors());
        hashCode = 31 * hashCode + Objects.hashCode(totalConnectors());
        hashCode = 31 * hashCode + Objects.hashCode(unknownConnectors());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerConnectorInfo)) {
            return false;
        }
        CustomerConnectorInfo other = (CustomerConnectorInfo) obj;
        return Objects.equals(activeConnectors(), other.activeConnectors())
                && Objects.equals(healthyConnectors(), other.healthyConnectors())
                && Objects.equals(blackListedConnectors(), other.blackListedConnectors())
                && Objects.equals(shutdownConnectors(), other.shutdownConnectors())
                && Objects.equals(unhealthyConnectors(), other.unhealthyConnectors())
                && Objects.equals(totalConnectors(), other.totalConnectors())
                && Objects.equals(unknownConnectors(), other.unknownConnectors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomerConnectorInfo").add("ActiveConnectors", activeConnectors())
                .add("HealthyConnectors", healthyConnectors()).add("BlackListedConnectors", blackListedConnectors())
                .add("ShutdownConnectors", shutdownConnectors()).add("UnhealthyConnectors", unhealthyConnectors())
                .add("TotalConnectors", totalConnectors()).add("UnknownConnectors", unknownConnectors()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "activeConnectors":
            return Optional.ofNullable(clazz.cast(activeConnectors()));
        case "healthyConnectors":
            return Optional.ofNullable(clazz.cast(healthyConnectors()));
        case "blackListedConnectors":
            return Optional.ofNullable(clazz.cast(blackListedConnectors()));
        case "shutdownConnectors":
            return Optional.ofNullable(clazz.cast(shutdownConnectors()));
        case "unhealthyConnectors":
            return Optional.ofNullable(clazz.cast(unhealthyConnectors()));
        case "totalConnectors":
            return Optional.ofNullable(clazz.cast(totalConnectors()));
        case "unknownConnectors":
            return Optional.ofNullable(clazz.cast(unknownConnectors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomerConnectorInfo, T> g) {
        return obj -> g.apply((CustomerConnectorInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomerConnectorInfo> {
        /**
         * <p>
         * Number of active discovery connectors.
         * </p>
         * 
         * @param activeConnectors
         *        Number of active discovery connectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeConnectors(Integer activeConnectors);

        /**
         * <p>
         * Number of healthy discovery connectors.
         * </p>
         * 
         * @param healthyConnectors
         *        Number of healthy discovery connectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthyConnectors(Integer healthyConnectors);

        /**
         * <p>
         * Number of blacklisted discovery connectors.
         * </p>
         * 
         * @param blackListedConnectors
         *        Number of blacklisted discovery connectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blackListedConnectors(Integer blackListedConnectors);

        /**
         * <p>
         * Number of discovery connectors with status SHUTDOWN,
         * </p>
         * 
         * @param shutdownConnectors
         *        Number of discovery connectors with status SHUTDOWN,
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shutdownConnectors(Integer shutdownConnectors);

        /**
         * <p>
         * Number of unhealthy discovery connectors.
         * </p>
         * 
         * @param unhealthyConnectors
         *        Number of unhealthy discovery connectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unhealthyConnectors(Integer unhealthyConnectors);

        /**
         * <p>
         * Total number of discovery connectors.
         * </p>
         * 
         * @param totalConnectors
         *        Total number of discovery connectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalConnectors(Integer totalConnectors);

        /**
         * <p>
         * Number of unknown discovery connectors.
         * </p>
         * 
         * @param unknownConnectors
         *        Number of unknown discovery connectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unknownConnectors(Integer unknownConnectors);
    }

    static final class BuilderImpl implements Builder {
        private Integer activeConnectors;

        private Integer healthyConnectors;

        private Integer blackListedConnectors;

        private Integer shutdownConnectors;

        private Integer unhealthyConnectors;

        private Integer totalConnectors;

        private Integer unknownConnectors;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerConnectorInfo model) {
            activeConnectors(model.activeConnectors);
            healthyConnectors(model.healthyConnectors);
            blackListedConnectors(model.blackListedConnectors);
            shutdownConnectors(model.shutdownConnectors);
            unhealthyConnectors(model.unhealthyConnectors);
            totalConnectors(model.totalConnectors);
            unknownConnectors(model.unknownConnectors);
        }

        public final Integer getActiveConnectors() {
            return activeConnectors;
        }

        @Override
        public final Builder activeConnectors(Integer activeConnectors) {
            this.activeConnectors = activeConnectors;
            return this;
        }

        public final void setActiveConnectors(Integer activeConnectors) {
            this.activeConnectors = activeConnectors;
        }

        public final Integer getHealthyConnectors() {
            return healthyConnectors;
        }

        @Override
        public final Builder healthyConnectors(Integer healthyConnectors) {
            this.healthyConnectors = healthyConnectors;
            return this;
        }

        public final void setHealthyConnectors(Integer healthyConnectors) {
            this.healthyConnectors = healthyConnectors;
        }

        public final Integer getBlackListedConnectors() {
            return blackListedConnectors;
        }

        @Override
        public final Builder blackListedConnectors(Integer blackListedConnectors) {
            this.blackListedConnectors = blackListedConnectors;
            return this;
        }

        public final void setBlackListedConnectors(Integer blackListedConnectors) {
            this.blackListedConnectors = blackListedConnectors;
        }

        public final Integer getShutdownConnectors() {
            return shutdownConnectors;
        }

        @Override
        public final Builder shutdownConnectors(Integer shutdownConnectors) {
            this.shutdownConnectors = shutdownConnectors;
            return this;
        }

        public final void setShutdownConnectors(Integer shutdownConnectors) {
            this.shutdownConnectors = shutdownConnectors;
        }

        public final Integer getUnhealthyConnectors() {
            return unhealthyConnectors;
        }

        @Override
        public final Builder unhealthyConnectors(Integer unhealthyConnectors) {
            this.unhealthyConnectors = unhealthyConnectors;
            return this;
        }

        public final void setUnhealthyConnectors(Integer unhealthyConnectors) {
            this.unhealthyConnectors = unhealthyConnectors;
        }

        public final Integer getTotalConnectors() {
            return totalConnectors;
        }

        @Override
        public final Builder totalConnectors(Integer totalConnectors) {
            this.totalConnectors = totalConnectors;
            return this;
        }

        public final void setTotalConnectors(Integer totalConnectors) {
            this.totalConnectors = totalConnectors;
        }

        public final Integer getUnknownConnectors() {
            return unknownConnectors;
        }

        @Override
        public final Builder unknownConnectors(Integer unknownConnectors) {
            this.unknownConnectors = unknownConnectors;
            return this;
        }

        public final void setUnknownConnectors(Integer unknownConnectors) {
            this.unknownConnectors = unknownConnectors;
        }

        @Override
        public CustomerConnectorInfo build() {
            return new CustomerConnectorInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
