/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAgentsRequest extends ApplicationDiscoveryRequest implements
        ToCopyableBuilder<DescribeAgentsRequest.Builder, DescribeAgentsRequest> {
    private static final SdkField<List<String>> AGENT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("agentIds")
            .getter(getter(DescribeAgentsRequest::agentIds))
            .setter(setter(Builder::agentIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(DescribeAgentsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribeAgentsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeAgentsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_IDS_FIELD,
            FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> agentIds;

    private final List<Filter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeAgentsRequest(BuilderImpl builder) {
        super(builder);
        this.agentIds = builder.agentIds;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the AgentIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAgentIds() {
        return agentIds != null && !(agentIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The agent or the Connector IDs for which you want information. If you specify no IDs, the system returns
     * information about all agents/Connectors associated with your AWS user account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAgentIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The agent or the Connector IDs for which you want information. If you specify no IDs, the system returns
     *         information about all agents/Connectors associated with your AWS user account.
     */
    public final List<String> agentIds() {
        return agentIds;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * You can filter the request using various logical operators and a <i>key</i>-<i>value</i> format. For example:
     * </p>
     * <p>
     * <code>{"key": "collectionStatus", "value": "STARTED"}</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return You can filter the request using various logical operators and a <i>key</i>-<i>value</i> format. For
     *         example: </p>
     *         <p>
     *         <code>{"key": "collectionStatus", "value": "STARTED"}</code>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The total number of agents/Connectors to return in a single page of output. The maximum value is 100.
     * </p>
     * 
     * @return The total number of agents/Connectors to return in a single page of output. The maximum value is 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Token to retrieve the next set of results. For example, if you previously specified 100 IDs for
     * <code>DescribeAgentsRequest$agentIds</code> but set <code>DescribeAgentsRequest$maxResults</code> to 10, you
     * received a set of 10 results along with a token. Use that token in this query to get the next set of 10.
     * </p>
     * 
     * @return Token to retrieve the next set of results. For example, if you previously specified 100 IDs for
     *         <code>DescribeAgentsRequest$agentIds</code> but set <code>DescribeAgentsRequest$maxResults</code> to 10,
     *         you received a set of 10 results along with a token. Use that token in this query to get the next set of
     *         10.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAgentIds() ? agentIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAgentsRequest)) {
            return false;
        }
        DescribeAgentsRequest other = (DescribeAgentsRequest) obj;
        return hasAgentIds() == other.hasAgentIds() && Objects.equals(agentIds(), other.agentIds())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAgentsRequest").add("AgentIds", hasAgentIds() ? agentIds() : null)
                .add("Filters", hasFilters() ? filters() : null).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentIds":
            return Optional.ofNullable(clazz.cast(agentIds()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAgentsRequest, T> g) {
        return obj -> g.apply((DescribeAgentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationDiscoveryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAgentsRequest> {
        /**
         * <p>
         * The agent or the Connector IDs for which you want information. If you specify no IDs, the system returns
         * information about all agents/Connectors associated with your AWS user account.
         * </p>
         * 
         * @param agentIds
         *        The agent or the Connector IDs for which you want information. If you specify no IDs, the system
         *        returns information about all agents/Connectors associated with your AWS user account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentIds(Collection<String> agentIds);

        /**
         * <p>
         * The agent or the Connector IDs for which you want information. If you specify no IDs, the system returns
         * information about all agents/Connectors associated with your AWS user account.
         * </p>
         * 
         * @param agentIds
         *        The agent or the Connector IDs for which you want information. If you specify no IDs, the system
         *        returns information about all agents/Connectors associated with your AWS user account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentIds(String... agentIds);

        /**
         * <p>
         * You can filter the request using various logical operators and a <i>key</i>-<i>value</i> format. For example:
         * </p>
         * <p>
         * <code>{"key": "collectionStatus", "value": "STARTED"}</code>
         * </p>
         * 
         * @param filters
         *        You can filter the request using various logical operators and a <i>key</i>-<i>value</i> format. For
         *        example: </p>
         *        <p>
         *        <code>{"key": "collectionStatus", "value": "STARTED"}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * You can filter the request using various logical operators and a <i>key</i>-<i>value</i> format. For example:
         * </p>
         * <p>
         * <code>{"key": "collectionStatus", "value": "STARTED"}</code>
         * </p>
         * 
         * @param filters
         *        You can filter the request using various logical operators and a <i>key</i>-<i>value</i> format. For
         *        example: </p>
         *        <p>
         *        <code>{"key": "collectionStatus", "value": "STARTED"}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * You can filter the request using various logical operators and a <i>key</i>-<i>value</i> format. For example:
         * </p>
         * <p>
         * <code>{"key": "collectionStatus", "value": "STARTED"}</code>
         * </p>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The total number of agents/Connectors to return in a single page of output. The maximum value is 100.
         * </p>
         * 
         * @param maxResults
         *        The total number of agents/Connectors to return in a single page of output. The maximum value is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Token to retrieve the next set of results. For example, if you previously specified 100 IDs for
         * <code>DescribeAgentsRequest$agentIds</code> but set <code>DescribeAgentsRequest$maxResults</code> to 10, you
         * received a set of 10 results along with a token. Use that token in this query to get the next set of 10.
         * </p>
         * 
         * @param nextToken
         *        Token to retrieve the next set of results. For example, if you previously specified 100 IDs for
         *        <code>DescribeAgentsRequest$agentIds</code> but set <code>DescribeAgentsRequest$maxResults</code> to
         *        10, you received a set of 10 results along with a token. Use that token in this query to get the next
         *        set of 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationDiscoveryRequest.BuilderImpl implements Builder {
        private List<String> agentIds = DefaultSdkAutoConstructList.getInstance();

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAgentsRequest model) {
            super(model);
            agentIds(model.agentIds);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getAgentIds() {
            if (agentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return agentIds;
        }

        @Override
        public final Builder agentIds(Collection<String> agentIds) {
            this.agentIds = AgentIdsCopier.copy(agentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentIds(String... agentIds) {
            agentIds(Arrays.asList(agentIds));
            return this;
        }

        public final void setAgentIds(Collection<String> agentIds) {
            this.agentIds = AgentIdsCopier.copy(agentIds);
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FiltersCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAgentsRequest build() {
            return new DescribeAgentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
