/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteImportDataResponse extends ApplicationDiscoveryResponse implements
        ToCopyableBuilder<BatchDeleteImportDataResponse.Builder, BatchDeleteImportDataResponse> {
    private static final SdkField<List<BatchDeleteImportDataError>> ERRORS_FIELD = SdkField
            .<List<BatchDeleteImportDataError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchDeleteImportDataResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchDeleteImportDataError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchDeleteImportDataError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD));

    private final List<BatchDeleteImportDataError> errors;

    private BatchDeleteImportDataResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Error messages returned for each import task that you deleted as a response for this command.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return Error messages returned for each import task that you deleted as a response for this command.
     */
    public final List<BatchDeleteImportDataError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteImportDataResponse)) {
            return false;
        }
        BatchDeleteImportDataResponse other = (BatchDeleteImportDataResponse) obj;
        return hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteImportDataResponse").add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteImportDataResponse, T> g) {
        return obj -> g.apply((BatchDeleteImportDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationDiscoveryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchDeleteImportDataResponse> {
        /**
         * <p>
         * Error messages returned for each import task that you deleted as a response for this command.
         * </p>
         * 
         * @param errors
         *        Error messages returned for each import task that you deleted as a response for this command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchDeleteImportDataError> errors);

        /**
         * <p>
         * Error messages returned for each import task that you deleted as a response for this command.
         * </p>
         * 
         * @param errors
         *        Error messages returned for each import task that you deleted as a response for this command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchDeleteImportDataError... errors);

        /**
         * <p>
         * Error messages returned for each import task that you deleted as a response for this command.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<BatchDeleteImportDataError>.Builder}
         * avoiding the need to create one manually via {@link List<BatchDeleteImportDataError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchDeleteImportDataError>.Builder#build()} is called
         * immediately and its result is passed to {@link #errors(List<BatchDeleteImportDataError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on {@link List<BatchDeleteImportDataError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(List<BatchDeleteImportDataError>)
         */
        Builder errors(Consumer<BatchDeleteImportDataError.Builder>... errors);
    }

    static final class BuilderImpl extends ApplicationDiscoveryResponse.BuilderImpl implements Builder {
        private List<BatchDeleteImportDataError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteImportDataResponse model) {
            super(model);
            errors(model.errors);
        }

        public final List<BatchDeleteImportDataError.Builder> getErrors() {
            List<BatchDeleteImportDataError.Builder> result = BatchDeleteImportDataErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchDeleteImportDataError.BuilderImpl> errors) {
            this.errors = BatchDeleteImportDataErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchDeleteImportDataError> errors) {
            this.errors = BatchDeleteImportDataErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchDeleteImportDataError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchDeleteImportDataError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchDeleteImportDataError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchDeleteImportDataResponse build() {
            return new BatchDeleteImportDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
