/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAgentsResponse extends ApplicationDiscoveryResponse implements
        ToCopyableBuilder<DescribeAgentsResponse.Builder, DescribeAgentsResponse> {
    private static final SdkField<List<AgentInfo>> AGENTS_INFO_FIELD = SdkField
            .<List<AgentInfo>> builder(MarshallingType.LIST)
            .memberName("agentsInfo")
            .getter(getter(DescribeAgentsResponse::agentsInfo))
            .setter(setter(Builder::agentsInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentsInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AgentInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(AgentInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeAgentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENTS_INFO_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AgentInfo> agentsInfo;

    private final String nextToken;

    private DescribeAgentsResponse(BuilderImpl builder) {
        super(builder);
        this.agentsInfo = builder.agentsInfo;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AgentsInfo property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAgentsInfo() {
        return agentsInfo != null && !(agentsInfo instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists agents or the Connector by ID or lists all agents/Connectors associated with your user account if you did
     * not specify an agent/Connector ID. The output includes agent/Connector IDs, IP addresses, media access control
     * (MAC) addresses, agent/Connector health, host name where the agent/Connector resides, and the version number of
     * each agent/Connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgentsInfo} method.
     * </p>
     * 
     * @return Lists agents or the Connector by ID or lists all agents/Connectors associated with your user account if
     *         you did not specify an agent/Connector ID. The output includes agent/Connector IDs, IP addresses, media
     *         access control (MAC) addresses, agent/Connector health, host name where the agent/Connector resides, and
     *         the version number of each agent/Connector.
     */
    public final List<AgentInfo> agentsInfo() {
        return agentsInfo;
    }

    /**
     * <p>
     * Token to retrieve the next set of results. For example, if you specified 100 IDs for
     * <code>DescribeAgentsRequest$agentIds</code> but set <code>DescribeAgentsRequest$maxResults</code> to 10, you
     * received a set of 10 results along with this token. Use this token in the next query to retrieve the next set of
     * 10.
     * </p>
     * 
     * @return Token to retrieve the next set of results. For example, if you specified 100 IDs for
     *         <code>DescribeAgentsRequest$agentIds</code> but set <code>DescribeAgentsRequest$maxResults</code> to 10,
     *         you received a set of 10 results along with this token. Use this token in the next query to retrieve the
     *         next set of 10.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAgentsInfo() ? agentsInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAgentsResponse)) {
            return false;
        }
        DescribeAgentsResponse other = (DescribeAgentsResponse) obj;
        return hasAgentsInfo() == other.hasAgentsInfo() && Objects.equals(agentsInfo(), other.agentsInfo())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAgentsResponse").add("AgentsInfo", hasAgentsInfo() ? agentsInfo() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentsInfo":
            return Optional.ofNullable(clazz.cast(agentsInfo()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAgentsResponse, T> g) {
        return obj -> g.apply((DescribeAgentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationDiscoveryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAgentsResponse> {
        /**
         * <p>
         * Lists agents or the Connector by ID or lists all agents/Connectors associated with your user account if you
         * did not specify an agent/Connector ID. The output includes agent/Connector IDs, IP addresses, media access
         * control (MAC) addresses, agent/Connector health, host name where the agent/Connector resides, and the version
         * number of each agent/Connector.
         * </p>
         * 
         * @param agentsInfo
         *        Lists agents or the Connector by ID or lists all agents/Connectors associated with your user account
         *        if you did not specify an agent/Connector ID. The output includes agent/Connector IDs, IP addresses,
         *        media access control (MAC) addresses, agent/Connector health, host name where the agent/Connector
         *        resides, and the version number of each agent/Connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentsInfo(Collection<AgentInfo> agentsInfo);

        /**
         * <p>
         * Lists agents or the Connector by ID or lists all agents/Connectors associated with your user account if you
         * did not specify an agent/Connector ID. The output includes agent/Connector IDs, IP addresses, media access
         * control (MAC) addresses, agent/Connector health, host name where the agent/Connector resides, and the version
         * number of each agent/Connector.
         * </p>
         * 
         * @param agentsInfo
         *        Lists agents or the Connector by ID or lists all agents/Connectors associated with your user account
         *        if you did not specify an agent/Connector ID. The output includes agent/Connector IDs, IP addresses,
         *        media access control (MAC) addresses, agent/Connector health, host name where the agent/Connector
         *        resides, and the version number of each agent/Connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentsInfo(AgentInfo... agentsInfo);

        /**
         * <p>
         * Lists agents or the Connector by ID or lists all agents/Connectors associated with your user account if you
         * did not specify an agent/Connector ID. The output includes agent/Connector IDs, IP addresses, media access
         * control (MAC) addresses, agent/Connector health, host name where the agent/Connector resides, and the version
         * number of each agent/Connector.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AgentInfo>.Builder} avoiding the need to
         * create one manually via {@link List<AgentInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AgentInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #agentsInfo(List<AgentInfo>)}.
         * 
         * @param agentsInfo
         *        a consumer that will call methods on {@link List<AgentInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentsInfo(List<AgentInfo>)
         */
        Builder agentsInfo(Consumer<AgentInfo.Builder>... agentsInfo);

        /**
         * <p>
         * Token to retrieve the next set of results. For example, if you specified 100 IDs for
         * <code>DescribeAgentsRequest$agentIds</code> but set <code>DescribeAgentsRequest$maxResults</code> to 10, you
         * received a set of 10 results along with this token. Use this token in the next query to retrieve the next set
         * of 10.
         * </p>
         * 
         * @param nextToken
         *        Token to retrieve the next set of results. For example, if you specified 100 IDs for
         *        <code>DescribeAgentsRequest$agentIds</code> but set <code>DescribeAgentsRequest$maxResults</code> to
         *        10, you received a set of 10 results along with this token. Use this token in the next query to
         *        retrieve the next set of 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ApplicationDiscoveryResponse.BuilderImpl implements Builder {
        private List<AgentInfo> agentsInfo = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAgentsResponse model) {
            super(model);
            agentsInfo(model.agentsInfo);
            nextToken(model.nextToken);
        }

        public final List<AgentInfo.Builder> getAgentsInfo() {
            List<AgentInfo.Builder> result = AgentsInfoCopier.copyToBuilder(this.agentsInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAgentsInfo(Collection<AgentInfo.BuilderImpl> agentsInfo) {
            this.agentsInfo = AgentsInfoCopier.copyFromBuilder(agentsInfo);
        }

        @Override
        @Transient
        public final Builder agentsInfo(Collection<AgentInfo> agentsInfo) {
            this.agentsInfo = AgentsInfoCopier.copy(agentsInfo);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder agentsInfo(AgentInfo... agentsInfo) {
            agentsInfo(Arrays.asList(agentsInfo));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder agentsInfo(Consumer<AgentInfo.Builder>... agentsInfo) {
            agentsInfo(Stream.of(agentsInfo).map(c -> AgentInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeAgentsResponse build() {
            return new DescribeAgentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
