/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information regarding the export status of discovered data. The value is an array of objects.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportInfo implements SdkPojo, Serializable, ToCopyableBuilder<ExportInfo.Builder, ExportInfo> {
    private static final SdkField<String> EXPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("exportId").getter(getter(ExportInfo::exportId)).setter(setter(Builder::exportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportId").build()).build();

    private static final SdkField<String> EXPORT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("exportStatus").getter(getter(ExportInfo::exportStatusAsString)).setter(setter(Builder::exportStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportStatus").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(ExportInfo::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<String> CONFIGURATIONS_DOWNLOAD_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configurationsDownloadUrl").getter(getter(ExportInfo::configurationsDownloadUrl))
            .setter(setter(Builder::configurationsDownloadUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationsDownloadUrl").build())
            .build();

    private static final SdkField<Instant> EXPORT_REQUEST_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("exportRequestTime").getter(getter(ExportInfo::exportRequestTime))
            .setter(setter(Builder::exportRequestTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportRequestTime").build()).build();

    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isTruncated").getter(getter(ExportInfo::isTruncated)).setter(setter(Builder::isTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isTruncated").build()).build();

    private static final SdkField<Instant> REQUESTED_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("requestedStartTime").getter(getter(ExportInfo::requestedStartTime))
            .setter(setter(Builder::requestedStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestedStartTime").build())
            .build();

    private static final SdkField<Instant> REQUESTED_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("requestedEndTime").getter(getter(ExportInfo::requestedEndTime))
            .setter(setter(Builder::requestedEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestedEndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_ID_FIELD,
            EXPORT_STATUS_FIELD, STATUS_MESSAGE_FIELD, CONFIGURATIONS_DOWNLOAD_URL_FIELD, EXPORT_REQUEST_TIME_FIELD,
            IS_TRUNCATED_FIELD, REQUESTED_START_TIME_FIELD, REQUESTED_END_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String exportId;

    private final String exportStatus;

    private final String statusMessage;

    private final String configurationsDownloadUrl;

    private final Instant exportRequestTime;

    private final Boolean isTruncated;

    private final Instant requestedStartTime;

    private final Instant requestedEndTime;

    private ExportInfo(BuilderImpl builder) {
        this.exportId = builder.exportId;
        this.exportStatus = builder.exportStatus;
        this.statusMessage = builder.statusMessage;
        this.configurationsDownloadUrl = builder.configurationsDownloadUrl;
        this.exportRequestTime = builder.exportRequestTime;
        this.isTruncated = builder.isTruncated;
        this.requestedStartTime = builder.requestedStartTime;
        this.requestedEndTime = builder.requestedEndTime;
    }

    /**
     * <p>
     * A unique identifier used to query an export.
     * </p>
     * 
     * @return A unique identifier used to query an export.
     */
    public final String exportId() {
        return exportId;
    }

    /**
     * <p>
     * The status of the data export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportStatus} will
     * return {@link ExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportStatusAsString}.
     * </p>
     * 
     * @return The status of the data export job.
     * @see ExportStatus
     */
    public final ExportStatus exportStatus() {
        return ExportStatus.fromValue(exportStatus);
    }

    /**
     * <p>
     * The status of the data export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportStatus} will
     * return {@link ExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportStatusAsString}.
     * </p>
     * 
     * @return The status of the data export job.
     * @see ExportStatus
     */
    public final String exportStatusAsString() {
        return exportStatus;
    }

    /**
     * <p>
     * A status message provided for API callers.
     * </p>
     * 
     * @return A status message provided for API callers.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * A URL for an Amazon S3 bucket where you can review the exported data. The URL is displayed only if the export
     * succeeded.
     * </p>
     * 
     * @return A URL for an Amazon S3 bucket where you can review the exported data. The URL is displayed only if the
     *         export succeeded.
     */
    public final String configurationsDownloadUrl() {
        return configurationsDownloadUrl;
    }

    /**
     * <p>
     * The time that the data export was initiated.
     * </p>
     * 
     * @return The time that the data export was initiated.
     */
    public final Instant exportRequestTime() {
        return exportRequestTime;
    }

    /**
     * <p>
     * If true, the export of agent information exceeded the size limit for a single export and the exported data is
     * incomplete for the requested time range. To address this, select a smaller time range for the export by using
     * <code>startDate</code> and <code>endDate</code>.
     * </p>
     * 
     * @return If true, the export of agent information exceeded the size limit for a single export and the exported
     *         data is incomplete for the requested time range. To address this, select a smaller time range for the
     *         export by using <code>startDate</code> and <code>endDate</code>.
     */
    public final Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * The value of <code>startTime</code> parameter in the <code>StartExportTask</code> request. If no
     * <code>startTime</code> was requested, this result does not appear in <code>ExportInfo</code>.
     * </p>
     * 
     * @return The value of <code>startTime</code> parameter in the <code>StartExportTask</code> request. If no
     *         <code>startTime</code> was requested, this result does not appear in <code>ExportInfo</code>.
     */
    public final Instant requestedStartTime() {
        return requestedStartTime;
    }

    /**
     * <p>
     * The <code>endTime</code> used in the <code>StartExportTask</code> request. If no <code>endTime</code> was
     * requested, this result does not appear in <code>ExportInfo</code>.
     * </p>
     * 
     * @return The <code>endTime</code> used in the <code>StartExportTask</code> request. If no <code>endTime</code> was
     *         requested, this result does not appear in <code>ExportInfo</code>.
     */
    public final Instant requestedEndTime() {
        return requestedEndTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exportId());
        hashCode = 31 * hashCode + Objects.hashCode(exportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(configurationsDownloadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(exportRequestTime());
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(requestedStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(requestedEndTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportInfo)) {
            return false;
        }
        ExportInfo other = (ExportInfo) obj;
        return Objects.equals(exportId(), other.exportId())
                && Objects.equals(exportStatusAsString(), other.exportStatusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(configurationsDownloadUrl(), other.configurationsDownloadUrl())
                && Objects.equals(exportRequestTime(), other.exportRequestTime())
                && Objects.equals(isTruncated(), other.isTruncated())
                && Objects.equals(requestedStartTime(), other.requestedStartTime())
                && Objects.equals(requestedEndTime(), other.requestedEndTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportInfo").add("ExportId", exportId()).add("ExportStatus", exportStatusAsString())
                .add("StatusMessage", statusMessage()).add("ConfigurationsDownloadUrl", configurationsDownloadUrl())
                .add("ExportRequestTime", exportRequestTime()).add("IsTruncated", isTruncated())
                .add("RequestedStartTime", requestedStartTime()).add("RequestedEndTime", requestedEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exportId":
            return Optional.ofNullable(clazz.cast(exportId()));
        case "exportStatus":
            return Optional.ofNullable(clazz.cast(exportStatusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "configurationsDownloadUrl":
            return Optional.ofNullable(clazz.cast(configurationsDownloadUrl()));
        case "exportRequestTime":
            return Optional.ofNullable(clazz.cast(exportRequestTime()));
        case "isTruncated":
            return Optional.ofNullable(clazz.cast(isTruncated()));
        case "requestedStartTime":
            return Optional.ofNullable(clazz.cast(requestedStartTime()));
        case "requestedEndTime":
            return Optional.ofNullable(clazz.cast(requestedEndTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportInfo, T> g) {
        return obj -> g.apply((ExportInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportInfo> {
        /**
         * <p>
         * A unique identifier used to query an export.
         * </p>
         * 
         * @param exportId
         *        A unique identifier used to query an export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportId(String exportId);

        /**
         * <p>
         * The status of the data export job.
         * </p>
         * 
         * @param exportStatus
         *        The status of the data export job.
         * @see ExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportStatus
         */
        Builder exportStatus(String exportStatus);

        /**
         * <p>
         * The status of the data export job.
         * </p>
         * 
         * @param exportStatus
         *        The status of the data export job.
         * @see ExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportStatus
         */
        Builder exportStatus(ExportStatus exportStatus);

        /**
         * <p>
         * A status message provided for API callers.
         * </p>
         * 
         * @param statusMessage
         *        A status message provided for API callers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * A URL for an Amazon S3 bucket where you can review the exported data. The URL is displayed only if the export
         * succeeded.
         * </p>
         * 
         * @param configurationsDownloadUrl
         *        A URL for an Amazon S3 bucket where you can review the exported data. The URL is displayed only if the
         *        export succeeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationsDownloadUrl(String configurationsDownloadUrl);

        /**
         * <p>
         * The time that the data export was initiated.
         * </p>
         * 
         * @param exportRequestTime
         *        The time that the data export was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportRequestTime(Instant exportRequestTime);

        /**
         * <p>
         * If true, the export of agent information exceeded the size limit for a single export and the exported data is
         * incomplete for the requested time range. To address this, select a smaller time range for the export by using
         * <code>startDate</code> and <code>endDate</code>.
         * </p>
         * 
         * @param isTruncated
         *        If true, the export of agent information exceeded the size limit for a single export and the exported
         *        data is incomplete for the requested time range. To address this, select a smaller time range for the
         *        export by using <code>startDate</code> and <code>endDate</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * The value of <code>startTime</code> parameter in the <code>StartExportTask</code> request. If no
         * <code>startTime</code> was requested, this result does not appear in <code>ExportInfo</code>.
         * </p>
         * 
         * @param requestedStartTime
         *        The value of <code>startTime</code> parameter in the <code>StartExportTask</code> request. If no
         *        <code>startTime</code> was requested, this result does not appear in <code>ExportInfo</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedStartTime(Instant requestedStartTime);

        /**
         * <p>
         * The <code>endTime</code> used in the <code>StartExportTask</code> request. If no <code>endTime</code> was
         * requested, this result does not appear in <code>ExportInfo</code>.
         * </p>
         * 
         * @param requestedEndTime
         *        The <code>endTime</code> used in the <code>StartExportTask</code> request. If no <code>endTime</code>
         *        was requested, this result does not appear in <code>ExportInfo</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedEndTime(Instant requestedEndTime);
    }

    static final class BuilderImpl implements Builder {
        private String exportId;

        private String exportStatus;

        private String statusMessage;

        private String configurationsDownloadUrl;

        private Instant exportRequestTime;

        private Boolean isTruncated;

        private Instant requestedStartTime;

        private Instant requestedEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportInfo model) {
            exportId(model.exportId);
            exportStatus(model.exportStatus);
            statusMessage(model.statusMessage);
            configurationsDownloadUrl(model.configurationsDownloadUrl);
            exportRequestTime(model.exportRequestTime);
            isTruncated(model.isTruncated);
            requestedStartTime(model.requestedStartTime);
            requestedEndTime(model.requestedEndTime);
        }

        public final String getExportId() {
            return exportId;
        }

        public final void setExportId(String exportId) {
            this.exportId = exportId;
        }

        @Override
        @Transient
        public final Builder exportId(String exportId) {
            this.exportId = exportId;
            return this;
        }

        public final String getExportStatus() {
            return exportStatus;
        }

        public final void setExportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
        }

        @Override
        @Transient
        public final Builder exportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder exportStatus(ExportStatus exportStatus) {
            this.exportStatus(exportStatus == null ? null : exportStatus.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getConfigurationsDownloadUrl() {
            return configurationsDownloadUrl;
        }

        public final void setConfigurationsDownloadUrl(String configurationsDownloadUrl) {
            this.configurationsDownloadUrl = configurationsDownloadUrl;
        }

        @Override
        @Transient
        public final Builder configurationsDownloadUrl(String configurationsDownloadUrl) {
            this.configurationsDownloadUrl = configurationsDownloadUrl;
            return this;
        }

        public final Instant getExportRequestTime() {
            return exportRequestTime;
        }

        public final void setExportRequestTime(Instant exportRequestTime) {
            this.exportRequestTime = exportRequestTime;
        }

        @Override
        @Transient
        public final Builder exportRequestTime(Instant exportRequestTime) {
            this.exportRequestTime = exportRequestTime;
            return this;
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        @Override
        @Transient
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final Instant getRequestedStartTime() {
            return requestedStartTime;
        }

        public final void setRequestedStartTime(Instant requestedStartTime) {
            this.requestedStartTime = requestedStartTime;
        }

        @Override
        @Transient
        public final Builder requestedStartTime(Instant requestedStartTime) {
            this.requestedStartTime = requestedStartTime;
            return this;
        }

        public final Instant getRequestedEndTime() {
            return requestedEndTime;
        }

        public final void setRequestedEndTime(Instant requestedEndTime) {
            this.requestedEndTime = requestedEndTime;
        }

        @Override
        @Transient
        public final Builder requestedEndTime(Instant requestedEndTime) {
            this.requestedEndTime = requestedEndTime;
            return this;
        }

        @Override
        public ExportInfo build() {
            return new ExportInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
