/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartContinuousExportResponse extends ApplicationDiscoveryResponse implements
        ToCopyableBuilder<StartContinuousExportResponse.Builder, StartContinuousExportResponse> {
    private static final SdkField<String> EXPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("exportId").getter(getter(StartContinuousExportResponse::exportId)).setter(setter(Builder::exportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportId").build()).build();

    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3Bucket").getter(getter(StartContinuousExportResponse::s3Bucket)).setter(setter(Builder::s3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(StartContinuousExportResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSource").getter(getter(StartContinuousExportResponse::dataSourceAsString))
            .setter(setter(Builder::dataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()).build();

    private static final SdkField<Map<String, String>> SCHEMA_STORAGE_CONFIG_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("schemaStorageConfig")
            .getter(getter(StartContinuousExportResponse::schemaStorageConfig))
            .setter(setter(Builder::schemaStorageConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaStorageConfig").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_ID_FIELD,
            S3_BUCKET_FIELD, START_TIME_FIELD, DATA_SOURCE_FIELD, SCHEMA_STORAGE_CONFIG_FIELD));

    private final String exportId;

    private final String s3Bucket;

    private final Instant startTime;

    private final String dataSource;

    private final Map<String, String> schemaStorageConfig;

    private StartContinuousExportResponse(BuilderImpl builder) {
        super(builder);
        this.exportId = builder.exportId;
        this.s3Bucket = builder.s3Bucket;
        this.startTime = builder.startTime;
        this.dataSource = builder.dataSource;
        this.schemaStorageConfig = builder.schemaStorageConfig;
    }

    /**
     * <p>
     * The unique ID assigned to this export.
     * </p>
     * 
     * @return The unique ID assigned to this export.
     */
    public final String exportId() {
        return exportId;
    }

    /**
     * <p>
     * The name of the s3 bucket where the export data parquet files are stored.
     * </p>
     * 
     * @return The name of the s3 bucket where the export data parquet files are stored.
     */
    public final String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * The timestamp representing when the continuous export was started.
     * </p>
     * 
     * @return The timestamp representing when the continuous export was started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The type of data collector used to gather this data (currently only offered for AGENT).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataSource} will
     * return {@link DataSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataSourceAsString}.
     * </p>
     * 
     * @return The type of data collector used to gather this data (currently only offered for AGENT).
     * @see DataSource
     */
    public final DataSource dataSource() {
        return DataSource.fromValue(dataSource);
    }

    /**
     * <p>
     * The type of data collector used to gather this data (currently only offered for AGENT).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataSource} will
     * return {@link DataSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataSourceAsString}.
     * </p>
     * 
     * @return The type of data collector used to gather this data (currently only offered for AGENT).
     * @see DataSource
     */
    public final String dataSourceAsString() {
        return dataSource;
    }

    /**
     * For responses, this returns true if the service returned a value for the SchemaStorageConfig property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSchemaStorageConfig() {
        return schemaStorageConfig != null && !(schemaStorageConfig instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A dictionary which describes how the data is stored.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>databaseName</code> - the name of the Glue database used to store the schema.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSchemaStorageConfig} method.
     * </p>
     * 
     * @return A dictionary which describes how the data is stored.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>databaseName</code> - the name of the Glue database used to store the schema.
     *         </p>
     *         </li>
     */
    public final Map<String, String> schemaStorageConfig() {
        return schemaStorageConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(exportId());
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSchemaStorageConfig() ? schemaStorageConfig() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartContinuousExportResponse)) {
            return false;
        }
        StartContinuousExportResponse other = (StartContinuousExportResponse) obj;
        return Objects.equals(exportId(), other.exportId()) && Objects.equals(s3Bucket(), other.s3Bucket())
                && Objects.equals(startTime(), other.startTime())
                && Objects.equals(dataSourceAsString(), other.dataSourceAsString())
                && hasSchemaStorageConfig() == other.hasSchemaStorageConfig()
                && Objects.equals(schemaStorageConfig(), other.schemaStorageConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartContinuousExportResponse").add("ExportId", exportId()).add("S3Bucket", s3Bucket())
                .add("StartTime", startTime()).add("DataSource", dataSourceAsString())
                .add("SchemaStorageConfig", hasSchemaStorageConfig() ? schemaStorageConfig() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exportId":
            return Optional.ofNullable(clazz.cast(exportId()));
        case "s3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "dataSource":
            return Optional.ofNullable(clazz.cast(dataSourceAsString()));
        case "schemaStorageConfig":
            return Optional.ofNullable(clazz.cast(schemaStorageConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartContinuousExportResponse, T> g) {
        return obj -> g.apply((StartContinuousExportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationDiscoveryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartContinuousExportResponse> {
        /**
         * <p>
         * The unique ID assigned to this export.
         * </p>
         * 
         * @param exportId
         *        The unique ID assigned to this export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportId(String exportId);

        /**
         * <p>
         * The name of the s3 bucket where the export data parquet files are stored.
         * </p>
         * 
         * @param s3Bucket
         *        The name of the s3 bucket where the export data parquet files are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * The timestamp representing when the continuous export was started.
         * </p>
         * 
         * @param startTime
         *        The timestamp representing when the continuous export was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The type of data collector used to gather this data (currently only offered for AGENT).
         * </p>
         * 
         * @param dataSource
         *        The type of data collector used to gather this data (currently only offered for AGENT).
         * @see DataSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSource
         */
        Builder dataSource(String dataSource);

        /**
         * <p>
         * The type of data collector used to gather this data (currently only offered for AGENT).
         * </p>
         * 
         * @param dataSource
         *        The type of data collector used to gather this data (currently only offered for AGENT).
         * @see DataSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSource
         */
        Builder dataSource(DataSource dataSource);

        /**
         * <p>
         * A dictionary which describes how the data is stored.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>databaseName</code> - the name of the Glue database used to store the schema.
         * </p>
         * </li>
         * </ul>
         * 
         * @param schemaStorageConfig
         *        A dictionary which describes how the data is stored.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>databaseName</code> - the name of the Glue database used to store the schema.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaStorageConfig(Map<String, String> schemaStorageConfig);
    }

    static final class BuilderImpl extends ApplicationDiscoveryResponse.BuilderImpl implements Builder {
        private String exportId;

        private String s3Bucket;

        private Instant startTime;

        private String dataSource;

        private Map<String, String> schemaStorageConfig = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartContinuousExportResponse model) {
            super(model);
            exportId(model.exportId);
            s3Bucket(model.s3Bucket);
            startTime(model.startTime);
            dataSource(model.dataSource);
            schemaStorageConfig(model.schemaStorageConfig);
        }

        public final String getExportId() {
            return exportId;
        }

        public final void setExportId(String exportId) {
            this.exportId = exportId;
        }

        @Override
        @Transient
        public final Builder exportId(String exportId) {
            this.exportId = exportId;
            return this;
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        @Transient
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getDataSource() {
            return dataSource;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        @Transient
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        @Override
        @Transient
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource(dataSource == null ? null : dataSource.toString());
            return this;
        }

        public final Map<String, String> getSchemaStorageConfig() {
            if (schemaStorageConfig instanceof SdkAutoConstructMap) {
                return null;
            }
            return schemaStorageConfig;
        }

        public final void setSchemaStorageConfig(Map<String, String> schemaStorageConfig) {
            this.schemaStorageConfig = SchemaStorageConfigCopier.copy(schemaStorageConfig);
        }

        @Override
        @Transient
        public final Builder schemaStorageConfig(Map<String, String> schemaStorageConfig) {
            this.schemaStorageConfig = SchemaStorageConfigCopier.copy(schemaStorageConfig);
            return this;
        }

        @Override
        public StartContinuousExportResponse build() {
            return new StartContinuousExportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
