/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about agents associated with the user’s Amazon Web Services account. Information includes agent IDs, IP
 * addresses, media access control (MAC) addresses, agent or collector status, hostname where the agent resides, and
 * agent version for each agent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentInfo implements SdkPojo, Serializable, ToCopyableBuilder<AgentInfo.Builder, AgentInfo> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(AgentInfo::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()).build();

    private static final SdkField<String> HOST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostName").getter(getter(AgentInfo::hostName)).setter(setter(Builder::hostName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostName").build()).build();

    private static final SdkField<List<AgentNetworkInfo>> AGENT_NETWORK_INFO_LIST_FIELD = SdkField
            .<List<AgentNetworkInfo>> builder(MarshallingType.LIST)
            .memberName("agentNetworkInfoList")
            .getter(getter(AgentInfo::agentNetworkInfoList))
            .setter(setter(Builder::agentNetworkInfoList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentNetworkInfoList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AgentNetworkInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(AgentNetworkInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorId").getter(getter(AgentInfo::connectorId)).setter(setter(Builder::connectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorId").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(AgentInfo::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> HEALTH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("health")
            .getter(getter(AgentInfo::healthAsString)).setter(setter(Builder::health))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("health").build()).build();

    private static final SdkField<String> LAST_HEALTH_PING_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastHealthPingTime").getter(getter(AgentInfo::lastHealthPingTime))
            .setter(setter(Builder::lastHealthPingTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastHealthPingTime").build())
            .build();

    private static final SdkField<String> COLLECTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collectionStatus").getter(getter(AgentInfo::collectionStatus)).setter(setter(Builder::collectionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectionStatus").build()).build();

    private static final SdkField<String> AGENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentType").getter(getter(AgentInfo::agentType)).setter(setter(Builder::agentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentType").build()).build();

    private static final SdkField<String> REGISTERED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registeredTime").getter(getter(AgentInfo::registeredTime)).setter(setter(Builder::registeredTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registeredTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD,
            HOST_NAME_FIELD, AGENT_NETWORK_INFO_LIST_FIELD, CONNECTOR_ID_FIELD, VERSION_FIELD, HEALTH_FIELD,
            LAST_HEALTH_PING_TIME_FIELD, COLLECTION_STATUS_FIELD, AGENT_TYPE_FIELD, REGISTERED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String agentId;

    private final String hostName;

    private final List<AgentNetworkInfo> agentNetworkInfoList;

    private final String connectorId;

    private final String version;

    private final String health;

    private final String lastHealthPingTime;

    private final String collectionStatus;

    private final String agentType;

    private final String registeredTime;

    private AgentInfo(BuilderImpl builder) {
        this.agentId = builder.agentId;
        this.hostName = builder.hostName;
        this.agentNetworkInfoList = builder.agentNetworkInfoList;
        this.connectorId = builder.connectorId;
        this.version = builder.version;
        this.health = builder.health;
        this.lastHealthPingTime = builder.lastHealthPingTime;
        this.collectionStatus = builder.collectionStatus;
        this.agentType = builder.agentType;
        this.registeredTime = builder.registeredTime;
    }

    /**
     * <p>
     * The agent or collector ID.
     * </p>
     * 
     * @return The agent or collector ID.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * The name of the host where the agent or collector resides. The host can be a server or virtual machine.
     * </p>
     * 
     * @return The name of the host where the agent or collector resides. The host can be a server or virtual machine.
     */
    public final String hostName() {
        return hostName;
    }

    /**
     * For responses, this returns true if the service returned a value for the AgentNetworkInfoList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAgentNetworkInfoList() {
        return agentNetworkInfoList != null && !(agentNetworkInfoList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Network details about the host where the agent or collector resides.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgentNetworkInfoList} method.
     * </p>
     * 
     * @return Network details about the host where the agent or collector resides.
     */
    public final List<AgentNetworkInfo> agentNetworkInfoList() {
        return agentNetworkInfoList;
    }

    /**
     * <p>
     * The ID of the connector.
     * </p>
     * 
     * @return The ID of the connector.
     */
    public final String connectorId() {
        return connectorId;
    }

    /**
     * <p>
     * The agent or collector version.
     * </p>
     * 
     * @return The agent or collector version.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The health of the agent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #health} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #healthAsString}.
     * </p>
     * 
     * @return The health of the agent.
     * @see AgentStatus
     */
    public final AgentStatus health() {
        return AgentStatus.fromValue(health);
    }

    /**
     * <p>
     * The health of the agent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #health} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #healthAsString}.
     * </p>
     * 
     * @return The health of the agent.
     * @see AgentStatus
     */
    public final String healthAsString() {
        return health;
    }

    /**
     * <p>
     * Time since agent health was reported.
     * </p>
     * 
     * @return Time since agent health was reported.
     */
    public final String lastHealthPingTime() {
        return lastHealthPingTime;
    }

    /**
     * <p>
     * Status of the collection process for an agent.
     * </p>
     * 
     * @return Status of the collection process for an agent.
     */
    public final String collectionStatus() {
        return collectionStatus;
    }

    /**
     * <p>
     * Type of agent.
     * </p>
     * 
     * @return Type of agent.
     */
    public final String agentType() {
        return agentType;
    }

    /**
     * <p>
     * Agent's first registration timestamp in UTC.
     * </p>
     * 
     * @return Agent's first registration timestamp in UTC.
     */
    public final String registeredTime() {
        return registeredTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(hostName());
        hashCode = 31 * hashCode + Objects.hashCode(hasAgentNetworkInfoList() ? agentNetworkInfoList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectorId());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(healthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastHealthPingTime());
        hashCode = 31 * hashCode + Objects.hashCode(collectionStatus());
        hashCode = 31 * hashCode + Objects.hashCode(agentType());
        hashCode = 31 * hashCode + Objects.hashCode(registeredTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentInfo)) {
            return false;
        }
        AgentInfo other = (AgentInfo) obj;
        return Objects.equals(agentId(), other.agentId()) && Objects.equals(hostName(), other.hostName())
                && hasAgentNetworkInfoList() == other.hasAgentNetworkInfoList()
                && Objects.equals(agentNetworkInfoList(), other.agentNetworkInfoList())
                && Objects.equals(connectorId(), other.connectorId()) && Objects.equals(version(), other.version())
                && Objects.equals(healthAsString(), other.healthAsString())
                && Objects.equals(lastHealthPingTime(), other.lastHealthPingTime())
                && Objects.equals(collectionStatus(), other.collectionStatus()) && Objects.equals(agentType(), other.agentType())
                && Objects.equals(registeredTime(), other.registeredTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentInfo").add("AgentId", agentId()).add("HostName", hostName())
                .add("AgentNetworkInfoList", hasAgentNetworkInfoList() ? agentNetworkInfoList() : null)
                .add("ConnectorId", connectorId()).add("Version", version()).add("Health", healthAsString())
                .add("LastHealthPingTime", lastHealthPingTime()).add("CollectionStatus", collectionStatus())
                .add("AgentType", agentType()).add("RegisteredTime", registeredTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "hostName":
            return Optional.ofNullable(clazz.cast(hostName()));
        case "agentNetworkInfoList":
            return Optional.ofNullable(clazz.cast(agentNetworkInfoList()));
        case "connectorId":
            return Optional.ofNullable(clazz.cast(connectorId()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "health":
            return Optional.ofNullable(clazz.cast(healthAsString()));
        case "lastHealthPingTime":
            return Optional.ofNullable(clazz.cast(lastHealthPingTime()));
        case "collectionStatus":
            return Optional.ofNullable(clazz.cast(collectionStatus()));
        case "agentType":
            return Optional.ofNullable(clazz.cast(agentType()));
        case "registeredTime":
            return Optional.ofNullable(clazz.cast(registeredTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentInfo, T> g) {
        return obj -> g.apply((AgentInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentInfo> {
        /**
         * <p>
         * The agent or collector ID.
         * </p>
         * 
         * @param agentId
         *        The agent or collector ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * The name of the host where the agent or collector resides. The host can be a server or virtual machine.
         * </p>
         * 
         * @param hostName
         *        The name of the host where the agent or collector resides. The host can be a server or virtual
         *        machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostName(String hostName);

        /**
         * <p>
         * Network details about the host where the agent or collector resides.
         * </p>
         * 
         * @param agentNetworkInfoList
         *        Network details about the host where the agent or collector resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentNetworkInfoList(Collection<AgentNetworkInfo> agentNetworkInfoList);

        /**
         * <p>
         * Network details about the host where the agent or collector resides.
         * </p>
         * 
         * @param agentNetworkInfoList
         *        Network details about the host where the agent or collector resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentNetworkInfoList(AgentNetworkInfo... agentNetworkInfoList);

        /**
         * <p>
         * Network details about the host where the agent or collector resides.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationdiscovery.model.AgentNetworkInfo.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.applicationdiscovery.model.AgentNetworkInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationdiscovery.model.AgentNetworkInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #agentNetworkInfoList(List<AgentNetworkInfo>)}.
         * 
         * @param agentNetworkInfoList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationdiscovery.model.AgentNetworkInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentNetworkInfoList(java.util.Collection<AgentNetworkInfo>)
         */
        Builder agentNetworkInfoList(Consumer<AgentNetworkInfo.Builder>... agentNetworkInfoList);

        /**
         * <p>
         * The ID of the connector.
         * </p>
         * 
         * @param connectorId
         *        The ID of the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorId(String connectorId);

        /**
         * <p>
         * The agent or collector version.
         * </p>
         * 
         * @param version
         *        The agent or collector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The health of the agent.
         * </p>
         * 
         * @param health
         *        The health of the agent.
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder health(String health);

        /**
         * <p>
         * The health of the agent.
         * </p>
         * 
         * @param health
         *        The health of the agent.
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder health(AgentStatus health);

        /**
         * <p>
         * Time since agent health was reported.
         * </p>
         * 
         * @param lastHealthPingTime
         *        Time since agent health was reported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastHealthPingTime(String lastHealthPingTime);

        /**
         * <p>
         * Status of the collection process for an agent.
         * </p>
         * 
         * @param collectionStatus
         *        Status of the collection process for an agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionStatus(String collectionStatus);

        /**
         * <p>
         * Type of agent.
         * </p>
         * 
         * @param agentType
         *        Type of agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentType(String agentType);

        /**
         * <p>
         * Agent's first registration timestamp in UTC.
         * </p>
         * 
         * @param registeredTime
         *        Agent's first registration timestamp in UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredTime(String registeredTime);
    }

    static final class BuilderImpl implements Builder {
        private String agentId;

        private String hostName;

        private List<AgentNetworkInfo> agentNetworkInfoList = DefaultSdkAutoConstructList.getInstance();

        private String connectorId;

        private String version;

        private String health;

        private String lastHealthPingTime;

        private String collectionStatus;

        private String agentType;

        private String registeredTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentInfo model) {
            agentId(model.agentId);
            hostName(model.hostName);
            agentNetworkInfoList(model.agentNetworkInfoList);
            connectorId(model.connectorId);
            version(model.version);
            health(model.health);
            lastHealthPingTime(model.lastHealthPingTime);
            collectionStatus(model.collectionStatus);
            agentType(model.agentType);
            registeredTime(model.registeredTime);
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getHostName() {
            return hostName;
        }

        public final void setHostName(String hostName) {
            this.hostName = hostName;
        }

        @Override
        public final Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public final List<AgentNetworkInfo.Builder> getAgentNetworkInfoList() {
            List<AgentNetworkInfo.Builder> result = AgentNetworkInfoListCopier.copyToBuilder(this.agentNetworkInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAgentNetworkInfoList(Collection<AgentNetworkInfo.BuilderImpl> agentNetworkInfoList) {
            this.agentNetworkInfoList = AgentNetworkInfoListCopier.copyFromBuilder(agentNetworkInfoList);
        }

        @Override
        public final Builder agentNetworkInfoList(Collection<AgentNetworkInfo> agentNetworkInfoList) {
            this.agentNetworkInfoList = AgentNetworkInfoListCopier.copy(agentNetworkInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentNetworkInfoList(AgentNetworkInfo... agentNetworkInfoList) {
            agentNetworkInfoList(Arrays.asList(agentNetworkInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentNetworkInfoList(Consumer<AgentNetworkInfo.Builder>... agentNetworkInfoList) {
            agentNetworkInfoList(Stream.of(agentNetworkInfoList).map(c -> AgentNetworkInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getConnectorId() {
            return connectorId;
        }

        public final void setConnectorId(String connectorId) {
            this.connectorId = connectorId;
        }

        @Override
        public final Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getHealth() {
            return health;
        }

        public final void setHealth(String health) {
            this.health = health;
        }

        @Override
        public final Builder health(String health) {
            this.health = health;
            return this;
        }

        @Override
        public final Builder health(AgentStatus health) {
            this.health(health == null ? null : health.toString());
            return this;
        }

        public final String getLastHealthPingTime() {
            return lastHealthPingTime;
        }

        public final void setLastHealthPingTime(String lastHealthPingTime) {
            this.lastHealthPingTime = lastHealthPingTime;
        }

        @Override
        public final Builder lastHealthPingTime(String lastHealthPingTime) {
            this.lastHealthPingTime = lastHealthPingTime;
            return this;
        }

        public final String getCollectionStatus() {
            return collectionStatus;
        }

        public final void setCollectionStatus(String collectionStatus) {
            this.collectionStatus = collectionStatus;
        }

        @Override
        public final Builder collectionStatus(String collectionStatus) {
            this.collectionStatus = collectionStatus;
            return this;
        }

        public final String getAgentType() {
            return agentType;
        }

        public final void setAgentType(String agentType) {
            this.agentType = agentType;
        }

        @Override
        public final Builder agentType(String agentType) {
            this.agentType = agentType;
            return this;
        }

        public final String getRegisteredTime() {
            return registeredTime;
        }

        public final void setRegisteredTime(String registeredTime) {
            this.registeredTime = registeredTime;
        }

        @Override
        public final Builder registeredTime(String registeredTime) {
            this.registeredTime = registeredTime;
            return this;
        }

        @Override
        public AgentInfo build() {
            return new AgentInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
