/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomerAgentlessCollectorInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomerAgentlessCollectorInfo.Builder, CustomerAgentlessCollectorInfo> {
    private static final SdkField<Integer> ACTIVE_AGENTLESS_COLLECTORS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("activeAgentlessCollectors")
            .getter(getter(CustomerAgentlessCollectorInfo::activeAgentlessCollectors))
            .setter(setter(Builder::activeAgentlessCollectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeAgentlessCollectors").build())
            .build();

    private static final SdkField<Integer> HEALTHY_AGENTLESS_COLLECTORS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("healthyAgentlessCollectors")
            .getter(getter(CustomerAgentlessCollectorInfo::healthyAgentlessCollectors))
            .setter(setter(Builder::healthyAgentlessCollectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthyAgentlessCollectors").build())
            .build();

    private static final SdkField<Integer> DENY_LISTED_AGENTLESS_COLLECTORS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("denyListedAgentlessCollectors")
            .getter(getter(CustomerAgentlessCollectorInfo::denyListedAgentlessCollectors))
            .setter(setter(Builder::denyListedAgentlessCollectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("denyListedAgentlessCollectors")
                    .build()).build();

    private static final SdkField<Integer> SHUTDOWN_AGENTLESS_COLLECTORS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("shutdownAgentlessCollectors")
            .getter(getter(CustomerAgentlessCollectorInfo::shutdownAgentlessCollectors))
            .setter(setter(Builder::shutdownAgentlessCollectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shutdownAgentlessCollectors")
                    .build()).build();

    private static final SdkField<Integer> UNHEALTHY_AGENTLESS_COLLECTORS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("unhealthyAgentlessCollectors")
            .getter(getter(CustomerAgentlessCollectorInfo::unhealthyAgentlessCollectors))
            .setter(setter(Builder::unhealthyAgentlessCollectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unhealthyAgentlessCollectors")
                    .build()).build();

    private static final SdkField<Integer> TOTAL_AGENTLESS_COLLECTORS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalAgentlessCollectors").getter(getter(CustomerAgentlessCollectorInfo::totalAgentlessCollectors))
            .setter(setter(Builder::totalAgentlessCollectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalAgentlessCollectors").build())
            .build();

    private static final SdkField<Integer> UNKNOWN_AGENTLESS_COLLECTORS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("unknownAgentlessCollectors")
            .getter(getter(CustomerAgentlessCollectorInfo::unknownAgentlessCollectors))
            .setter(setter(Builder::unknownAgentlessCollectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unknownAgentlessCollectors").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ACTIVE_AGENTLESS_COLLECTORS_FIELD, HEALTHY_AGENTLESS_COLLECTORS_FIELD, DENY_LISTED_AGENTLESS_COLLECTORS_FIELD,
            SHUTDOWN_AGENTLESS_COLLECTORS_FIELD, UNHEALTHY_AGENTLESS_COLLECTORS_FIELD, TOTAL_AGENTLESS_COLLECTORS_FIELD,
            UNKNOWN_AGENTLESS_COLLECTORS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer activeAgentlessCollectors;

    private final Integer healthyAgentlessCollectors;

    private final Integer denyListedAgentlessCollectors;

    private final Integer shutdownAgentlessCollectors;

    private final Integer unhealthyAgentlessCollectors;

    private final Integer totalAgentlessCollectors;

    private final Integer unknownAgentlessCollectors;

    private CustomerAgentlessCollectorInfo(BuilderImpl builder) {
        this.activeAgentlessCollectors = builder.activeAgentlessCollectors;
        this.healthyAgentlessCollectors = builder.healthyAgentlessCollectors;
        this.denyListedAgentlessCollectors = builder.denyListedAgentlessCollectors;
        this.shutdownAgentlessCollectors = builder.shutdownAgentlessCollectors;
        this.unhealthyAgentlessCollectors = builder.unhealthyAgentlessCollectors;
        this.totalAgentlessCollectors = builder.totalAgentlessCollectors;
        this.unknownAgentlessCollectors = builder.unknownAgentlessCollectors;
    }

    /**
     * Returns the value of the ActiveAgentlessCollectors property for this object.
     * 
     * @return The value of the ActiveAgentlessCollectors property for this object.
     */
    public final Integer activeAgentlessCollectors() {
        return activeAgentlessCollectors;
    }

    /**
     * Returns the value of the HealthyAgentlessCollectors property for this object.
     * 
     * @return The value of the HealthyAgentlessCollectors property for this object.
     */
    public final Integer healthyAgentlessCollectors() {
        return healthyAgentlessCollectors;
    }

    /**
     * Returns the value of the DenyListedAgentlessCollectors property for this object.
     * 
     * @return The value of the DenyListedAgentlessCollectors property for this object.
     */
    public final Integer denyListedAgentlessCollectors() {
        return denyListedAgentlessCollectors;
    }

    /**
     * Returns the value of the ShutdownAgentlessCollectors property for this object.
     * 
     * @return The value of the ShutdownAgentlessCollectors property for this object.
     */
    public final Integer shutdownAgentlessCollectors() {
        return shutdownAgentlessCollectors;
    }

    /**
     * Returns the value of the UnhealthyAgentlessCollectors property for this object.
     * 
     * @return The value of the UnhealthyAgentlessCollectors property for this object.
     */
    public final Integer unhealthyAgentlessCollectors() {
        return unhealthyAgentlessCollectors;
    }

    /**
     * Returns the value of the TotalAgentlessCollectors property for this object.
     * 
     * @return The value of the TotalAgentlessCollectors property for this object.
     */
    public final Integer totalAgentlessCollectors() {
        return totalAgentlessCollectors;
    }

    /**
     * Returns the value of the UnknownAgentlessCollectors property for this object.
     * 
     * @return The value of the UnknownAgentlessCollectors property for this object.
     */
    public final Integer unknownAgentlessCollectors() {
        return unknownAgentlessCollectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activeAgentlessCollectors());
        hashCode = 31 * hashCode + Objects.hashCode(healthyAgentlessCollectors());
        hashCode = 31 * hashCode + Objects.hashCode(denyListedAgentlessCollectors());
        hashCode = 31 * hashCode + Objects.hashCode(shutdownAgentlessCollectors());
        hashCode = 31 * hashCode + Objects.hashCode(unhealthyAgentlessCollectors());
        hashCode = 31 * hashCode + Objects.hashCode(totalAgentlessCollectors());
        hashCode = 31 * hashCode + Objects.hashCode(unknownAgentlessCollectors());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerAgentlessCollectorInfo)) {
            return false;
        }
        CustomerAgentlessCollectorInfo other = (CustomerAgentlessCollectorInfo) obj;
        return Objects.equals(activeAgentlessCollectors(), other.activeAgentlessCollectors())
                && Objects.equals(healthyAgentlessCollectors(), other.healthyAgentlessCollectors())
                && Objects.equals(denyListedAgentlessCollectors(), other.denyListedAgentlessCollectors())
                && Objects.equals(shutdownAgentlessCollectors(), other.shutdownAgentlessCollectors())
                && Objects.equals(unhealthyAgentlessCollectors(), other.unhealthyAgentlessCollectors())
                && Objects.equals(totalAgentlessCollectors(), other.totalAgentlessCollectors())
                && Objects.equals(unknownAgentlessCollectors(), other.unknownAgentlessCollectors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomerAgentlessCollectorInfo").add("ActiveAgentlessCollectors", activeAgentlessCollectors())
                .add("HealthyAgentlessCollectors", healthyAgentlessCollectors())
                .add("DenyListedAgentlessCollectors", denyListedAgentlessCollectors())
                .add("ShutdownAgentlessCollectors", shutdownAgentlessCollectors())
                .add("UnhealthyAgentlessCollectors", unhealthyAgentlessCollectors())
                .add("TotalAgentlessCollectors", totalAgentlessCollectors())
                .add("UnknownAgentlessCollectors", unknownAgentlessCollectors()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "activeAgentlessCollectors":
            return Optional.ofNullable(clazz.cast(activeAgentlessCollectors()));
        case "healthyAgentlessCollectors":
            return Optional.ofNullable(clazz.cast(healthyAgentlessCollectors()));
        case "denyListedAgentlessCollectors":
            return Optional.ofNullable(clazz.cast(denyListedAgentlessCollectors()));
        case "shutdownAgentlessCollectors":
            return Optional.ofNullable(clazz.cast(shutdownAgentlessCollectors()));
        case "unhealthyAgentlessCollectors":
            return Optional.ofNullable(clazz.cast(unhealthyAgentlessCollectors()));
        case "totalAgentlessCollectors":
            return Optional.ofNullable(clazz.cast(totalAgentlessCollectors()));
        case "unknownAgentlessCollectors":
            return Optional.ofNullable(clazz.cast(unknownAgentlessCollectors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomerAgentlessCollectorInfo, T> g) {
        return obj -> g.apply((CustomerAgentlessCollectorInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomerAgentlessCollectorInfo> {
        /**
         * Sets the value of the ActiveAgentlessCollectors property for this object.
         *
         * @param activeAgentlessCollectors
         *        The new value for the ActiveAgentlessCollectors property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeAgentlessCollectors(Integer activeAgentlessCollectors);

        /**
         * Sets the value of the HealthyAgentlessCollectors property for this object.
         *
         * @param healthyAgentlessCollectors
         *        The new value for the HealthyAgentlessCollectors property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthyAgentlessCollectors(Integer healthyAgentlessCollectors);

        /**
         * Sets the value of the DenyListedAgentlessCollectors property for this object.
         *
         * @param denyListedAgentlessCollectors
         *        The new value for the DenyListedAgentlessCollectors property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder denyListedAgentlessCollectors(Integer denyListedAgentlessCollectors);

        /**
         * Sets the value of the ShutdownAgentlessCollectors property for this object.
         *
         * @param shutdownAgentlessCollectors
         *        The new value for the ShutdownAgentlessCollectors property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shutdownAgentlessCollectors(Integer shutdownAgentlessCollectors);

        /**
         * Sets the value of the UnhealthyAgentlessCollectors property for this object.
         *
         * @param unhealthyAgentlessCollectors
         *        The new value for the UnhealthyAgentlessCollectors property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unhealthyAgentlessCollectors(Integer unhealthyAgentlessCollectors);

        /**
         * Sets the value of the TotalAgentlessCollectors property for this object.
         *
         * @param totalAgentlessCollectors
         *        The new value for the TotalAgentlessCollectors property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalAgentlessCollectors(Integer totalAgentlessCollectors);

        /**
         * Sets the value of the UnknownAgentlessCollectors property for this object.
         *
         * @param unknownAgentlessCollectors
         *        The new value for the UnknownAgentlessCollectors property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unknownAgentlessCollectors(Integer unknownAgentlessCollectors);
    }

    static final class BuilderImpl implements Builder {
        private Integer activeAgentlessCollectors;

        private Integer healthyAgentlessCollectors;

        private Integer denyListedAgentlessCollectors;

        private Integer shutdownAgentlessCollectors;

        private Integer unhealthyAgentlessCollectors;

        private Integer totalAgentlessCollectors;

        private Integer unknownAgentlessCollectors;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerAgentlessCollectorInfo model) {
            activeAgentlessCollectors(model.activeAgentlessCollectors);
            healthyAgentlessCollectors(model.healthyAgentlessCollectors);
            denyListedAgentlessCollectors(model.denyListedAgentlessCollectors);
            shutdownAgentlessCollectors(model.shutdownAgentlessCollectors);
            unhealthyAgentlessCollectors(model.unhealthyAgentlessCollectors);
            totalAgentlessCollectors(model.totalAgentlessCollectors);
            unknownAgentlessCollectors(model.unknownAgentlessCollectors);
        }

        public final Integer getActiveAgentlessCollectors() {
            return activeAgentlessCollectors;
        }

        public final void setActiveAgentlessCollectors(Integer activeAgentlessCollectors) {
            this.activeAgentlessCollectors = activeAgentlessCollectors;
        }

        @Override
        public final Builder activeAgentlessCollectors(Integer activeAgentlessCollectors) {
            this.activeAgentlessCollectors = activeAgentlessCollectors;
            return this;
        }

        public final Integer getHealthyAgentlessCollectors() {
            return healthyAgentlessCollectors;
        }

        public final void setHealthyAgentlessCollectors(Integer healthyAgentlessCollectors) {
            this.healthyAgentlessCollectors = healthyAgentlessCollectors;
        }

        @Override
        public final Builder healthyAgentlessCollectors(Integer healthyAgentlessCollectors) {
            this.healthyAgentlessCollectors = healthyAgentlessCollectors;
            return this;
        }

        public final Integer getDenyListedAgentlessCollectors() {
            return denyListedAgentlessCollectors;
        }

        public final void setDenyListedAgentlessCollectors(Integer denyListedAgentlessCollectors) {
            this.denyListedAgentlessCollectors = denyListedAgentlessCollectors;
        }

        @Override
        public final Builder denyListedAgentlessCollectors(Integer denyListedAgentlessCollectors) {
            this.denyListedAgentlessCollectors = denyListedAgentlessCollectors;
            return this;
        }

        public final Integer getShutdownAgentlessCollectors() {
            return shutdownAgentlessCollectors;
        }

        public final void setShutdownAgentlessCollectors(Integer shutdownAgentlessCollectors) {
            this.shutdownAgentlessCollectors = shutdownAgentlessCollectors;
        }

        @Override
        public final Builder shutdownAgentlessCollectors(Integer shutdownAgentlessCollectors) {
            this.shutdownAgentlessCollectors = shutdownAgentlessCollectors;
            return this;
        }

        public final Integer getUnhealthyAgentlessCollectors() {
            return unhealthyAgentlessCollectors;
        }

        public final void setUnhealthyAgentlessCollectors(Integer unhealthyAgentlessCollectors) {
            this.unhealthyAgentlessCollectors = unhealthyAgentlessCollectors;
        }

        @Override
        public final Builder unhealthyAgentlessCollectors(Integer unhealthyAgentlessCollectors) {
            this.unhealthyAgentlessCollectors = unhealthyAgentlessCollectors;
            return this;
        }

        public final Integer getTotalAgentlessCollectors() {
            return totalAgentlessCollectors;
        }

        public final void setTotalAgentlessCollectors(Integer totalAgentlessCollectors) {
            this.totalAgentlessCollectors = totalAgentlessCollectors;
        }

        @Override
        public final Builder totalAgentlessCollectors(Integer totalAgentlessCollectors) {
            this.totalAgentlessCollectors = totalAgentlessCollectors;
            return this;
        }

        public final Integer getUnknownAgentlessCollectors() {
            return unknownAgentlessCollectors;
        }

        public final void setUnknownAgentlessCollectors(Integer unknownAgentlessCollectors) {
            this.unknownAgentlessCollectors = unknownAgentlessCollectors;
        }

        @Override
        public final Builder unknownAgentlessCollectors(Integer unknownAgentlessCollectors) {
            this.unknownAgentlessCollectors = unknownAgentlessCollectors;
            return this;
        }

        @Override
        public CustomerAgentlessCollectorInfo build() {
            return new CustomerAgentlessCollectorInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
