/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the agent or data collector that failed to delete, each containing agentId, errorMessage, and
 * errorCode.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteAgentError implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchDeleteAgentError.Builder, BatchDeleteAgentError> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(BatchDeleteAgentError::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(BatchDeleteAgentError::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(BatchDeleteAgentError::errorCodeAsString)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD,
            ERROR_MESSAGE_FIELD, ERROR_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String agentId;

    private final String errorMessage;

    private final String errorCode;

    private BatchDeleteAgentError(BuilderImpl builder) {
        this.agentId = builder.agentId;
        this.errorMessage = builder.errorMessage;
        this.errorCode = builder.errorCode;
    }

    /**
     * <p>
     * The ID of the agent or data collector to delete.
     * </p>
     * 
     * @return The ID of the agent or data collector to delete.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * The description of the error that occurred for the delete failed agent.
     * </p>
     * 
     * @return The description of the error that occurred for the delete failed agent.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The type of error that occurred for the delete failed agent. Valid status are: AGENT_IN_USE | NOT_FOUND |
     * INTERNAL_SERVER_ERROR.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link DeleteAgentErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The type of error that occurred for the delete failed agent. Valid status are: AGENT_IN_USE | NOT_FOUND |
     *         INTERNAL_SERVER_ERROR.
     * @see DeleteAgentErrorCode
     */
    public final DeleteAgentErrorCode errorCode() {
        return DeleteAgentErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * The type of error that occurred for the delete failed agent. Valid status are: AGENT_IN_USE | NOT_FOUND |
     * INTERNAL_SERVER_ERROR.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link DeleteAgentErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The type of error that occurred for the delete failed agent. Valid status are: AGENT_IN_USE | NOT_FOUND |
     *         INTERNAL_SERVER_ERROR.
     * @see DeleteAgentErrorCode
     */
    public final String errorCodeAsString() {
        return errorCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteAgentError)) {
            return false;
        }
        BatchDeleteAgentError other = (BatchDeleteAgentError) obj;
        return Objects.equals(agentId(), other.agentId()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(errorCodeAsString(), other.errorCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteAgentError").add("AgentId", agentId()).add("ErrorMessage", errorMessage())
                .add("ErrorCode", errorCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteAgentError, T> g) {
        return obj -> g.apply((BatchDeleteAgentError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchDeleteAgentError> {
        /**
         * <p>
         * The ID of the agent or data collector to delete.
         * </p>
         * 
         * @param agentId
         *        The ID of the agent or data collector to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * The description of the error that occurred for the delete failed agent.
         * </p>
         * 
         * @param errorMessage
         *        The description of the error that occurred for the delete failed agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The type of error that occurred for the delete failed agent. Valid status are: AGENT_IN_USE | NOT_FOUND |
         * INTERNAL_SERVER_ERROR.
         * </p>
         * 
         * @param errorCode
         *        The type of error that occurred for the delete failed agent. Valid status are: AGENT_IN_USE |
         *        NOT_FOUND | INTERNAL_SERVER_ERROR.
         * @see DeleteAgentErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeleteAgentErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The type of error that occurred for the delete failed agent. Valid status are: AGENT_IN_USE | NOT_FOUND |
         * INTERNAL_SERVER_ERROR.
         * </p>
         * 
         * @param errorCode
         *        The type of error that occurred for the delete failed agent. Valid status are: AGENT_IN_USE |
         *        NOT_FOUND | INTERNAL_SERVER_ERROR.
         * @see DeleteAgentErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeleteAgentErrorCode
         */
        Builder errorCode(DeleteAgentErrorCode errorCode);
    }

    static final class BuilderImpl implements Builder {
        private String agentId;

        private String errorMessage;

        private String errorCode;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteAgentError model) {
            agentId(model.agentId);
            errorMessage(model.errorMessage);
            errorCode(model.errorCode);
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(DeleteAgentErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        @Override
        public BatchDeleteAgentError build() {
            return new BatchDeleteAgentError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
