/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteImportDataRequest extends ApplicationDiscoveryRequest implements
        ToCopyableBuilder<BatchDeleteImportDataRequest.Builder, BatchDeleteImportDataRequest> {
    private static final SdkField<List<String>> IMPORT_TASK_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("importTaskIds")
            .getter(getter(BatchDeleteImportDataRequest::importTaskIds))
            .setter(setter(Builder::importTaskIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importTaskIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DELETE_HISTORY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deleteHistory").getter(getter(BatchDeleteImportDataRequest::deleteHistory))
            .setter(setter(Builder::deleteHistory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteHistory").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_TASK_IDS_FIELD,
            DELETE_HISTORY_FIELD));

    private final List<String> importTaskIds;

    private final Boolean deleteHistory;

    private BatchDeleteImportDataRequest(BuilderImpl builder) {
        super(builder);
        this.importTaskIds = builder.importTaskIds;
        this.deleteHistory = builder.deleteHistory;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImportTaskIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImportTaskIds() {
        return importTaskIds != null && !(importTaskIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs for the import tasks that you want to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImportTaskIds} method.
     * </p>
     * 
     * @return The IDs for the import tasks that you want to delete.
     */
    public final List<String> importTaskIds() {
        return importTaskIds;
    }

    /**
     * <p>
     * Set to <code>true</code> to remove the deleted import task from <a>DescribeImportTasks</a>.
     * </p>
     * 
     * @return Set to <code>true</code> to remove the deleted import task from <a>DescribeImportTasks</a>.
     */
    public final Boolean deleteHistory() {
        return deleteHistory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasImportTaskIds() ? importTaskIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deleteHistory());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteImportDataRequest)) {
            return false;
        }
        BatchDeleteImportDataRequest other = (BatchDeleteImportDataRequest) obj;
        return hasImportTaskIds() == other.hasImportTaskIds() && Objects.equals(importTaskIds(), other.importTaskIds())
                && Objects.equals(deleteHistory(), other.deleteHistory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteImportDataRequest").add("ImportTaskIds", hasImportTaskIds() ? importTaskIds() : null)
                .add("DeleteHistory", deleteHistory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "importTaskIds":
            return Optional.ofNullable(clazz.cast(importTaskIds()));
        case "deleteHistory":
            return Optional.ofNullable(clazz.cast(deleteHistory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteImportDataRequest, T> g) {
        return obj -> g.apply((BatchDeleteImportDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationDiscoveryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchDeleteImportDataRequest> {
        /**
         * <p>
         * The IDs for the import tasks that you want to delete.
         * </p>
         * 
         * @param importTaskIds
         *        The IDs for the import tasks that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importTaskIds(Collection<String> importTaskIds);

        /**
         * <p>
         * The IDs for the import tasks that you want to delete.
         * </p>
         * 
         * @param importTaskIds
         *        The IDs for the import tasks that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importTaskIds(String... importTaskIds);

        /**
         * <p>
         * Set to <code>true</code> to remove the deleted import task from <a>DescribeImportTasks</a>.
         * </p>
         * 
         * @param deleteHistory
         *        Set to <code>true</code> to remove the deleted import task from <a>DescribeImportTasks</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteHistory(Boolean deleteHistory);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationDiscoveryRequest.BuilderImpl implements Builder {
        private List<String> importTaskIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean deleteHistory;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteImportDataRequest model) {
            super(model);
            importTaskIds(model.importTaskIds);
            deleteHistory(model.deleteHistory);
        }

        public final Collection<String> getImportTaskIds() {
            if (importTaskIds instanceof SdkAutoConstructList) {
                return null;
            }
            return importTaskIds;
        }

        public final void setImportTaskIds(Collection<String> importTaskIds) {
            this.importTaskIds = ToDeleteIdentifierListCopier.copy(importTaskIds);
        }

        @Override
        public final Builder importTaskIds(Collection<String> importTaskIds) {
            this.importTaskIds = ToDeleteIdentifierListCopier.copy(importTaskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importTaskIds(String... importTaskIds) {
            importTaskIds(Arrays.asList(importTaskIds));
            return this;
        }

        public final Boolean getDeleteHistory() {
            return deleteHistory;
        }

        public final void setDeleteHistory(Boolean deleteHistory) {
            this.deleteHistory = deleteHistory;
        }

        @Override
        public final Builder deleteHistory(Boolean deleteHistory) {
            this.deleteHistory = deleteHistory;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteImportDataRequest build() {
            return new BatchDeleteImportDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
