/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateConfigurationItemsToApplicationRequest extends ApplicationDiscoveryRequest
        implements
        ToCopyableBuilder<AssociateConfigurationItemsToApplicationRequest.Builder, AssociateConfigurationItemsToApplicationRequest> {
    private static final SdkField<String> APPLICATION_CONFIGURATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateConfigurationItemsToApplicationRequest::applicationConfigurationId))
            .setter(setter(Builder::applicationConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationConfigurationId").build())
            .build();

    private static final SdkField<List<String>> CONFIGURATION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(AssociateConfigurationItemsToApplicationRequest::configurationIds))
            .setter(setter(Builder::configurationIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPLICATION_CONFIGURATION_ID_FIELD, CONFIGURATION_IDS_FIELD));

    private final String applicationConfigurationId;

    private final List<String> configurationIds;

    private AssociateConfigurationItemsToApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationConfigurationId = builder.applicationConfigurationId;
        this.configurationIds = builder.configurationIds;
    }

    /**
     * <p>
     * The configuration ID of an application with which items are to be associated.
     * </p>
     * 
     * @return The configuration ID of an application with which items are to be associated.
     */
    public String applicationConfigurationId() {
        return applicationConfigurationId;
    }

    /**
     * <p>
     * The ID of each configuration item to be associated with an application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The ID of each configuration item to be associated with an application.
     */
    public List<String> configurationIds() {
        return configurationIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(configurationIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateConfigurationItemsToApplicationRequest)) {
            return false;
        }
        AssociateConfigurationItemsToApplicationRequest other = (AssociateConfigurationItemsToApplicationRequest) obj;
        return Objects.equals(applicationConfigurationId(), other.applicationConfigurationId())
                && Objects.equals(configurationIds(), other.configurationIds());
    }

    @Override
    public String toString() {
        return ToString.builder("AssociateConfigurationItemsToApplicationRequest")
                .add("ApplicationConfigurationId", applicationConfigurationId()).add("ConfigurationIds", configurationIds())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationConfigurationId":
            return Optional.ofNullable(clazz.cast(applicationConfigurationId()));
        case "configurationIds":
            return Optional.ofNullable(clazz.cast(configurationIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateConfigurationItemsToApplicationRequest, T> g) {
        return obj -> g.apply((AssociateConfigurationItemsToApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationDiscoveryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateConfigurationItemsToApplicationRequest> {
        /**
         * <p>
         * The configuration ID of an application with which items are to be associated.
         * </p>
         * 
         * @param applicationConfigurationId
         *        The configuration ID of an application with which items are to be associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationConfigurationId(String applicationConfigurationId);

        /**
         * <p>
         * The ID of each configuration item to be associated with an application.
         * </p>
         * 
         * @param configurationIds
         *        The ID of each configuration item to be associated with an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationIds(Collection<String> configurationIds);

        /**
         * <p>
         * The ID of each configuration item to be associated with an application.
         * </p>
         * 
         * @param configurationIds
         *        The ID of each configuration item to be associated with an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationIds(String... configurationIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationDiscoveryRequest.BuilderImpl implements Builder {
        private String applicationConfigurationId;

        private List<String> configurationIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateConfigurationItemsToApplicationRequest model) {
            super(model);
            applicationConfigurationId(model.applicationConfigurationId);
            configurationIds(model.configurationIds);
        }

        public final String getApplicationConfigurationId() {
            return applicationConfigurationId;
        }

        @Override
        public final Builder applicationConfigurationId(String applicationConfigurationId) {
            this.applicationConfigurationId = applicationConfigurationId;
            return this;
        }

        public final void setApplicationConfigurationId(String applicationConfigurationId) {
            this.applicationConfigurationId = applicationConfigurationId;
        }

        public final Collection<String> getConfigurationIds() {
            return configurationIds;
        }

        @Override
        public final Builder configurationIds(Collection<String> configurationIds) {
            this.configurationIds = ConfigurationIdListCopier.copy(configurationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationIds(String... configurationIds) {
            configurationIds(Arrays.asList(configurationIds));
            return this;
        }

        public final void setConfigurationIds(Collection<String> configurationIds) {
            this.configurationIds = ConfigurationIdListCopier.copy(configurationIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateConfigurationItemsToApplicationRequest build() {
            return new AssociateConfigurationItemsToApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
