/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter that can use conditional operators.
 * </p>
 * <p>
 * For more information about filters, see <a
 * href="http://docs.aws.amazon.com/application-discovery/latest/APIReference/discovery-api-queries.html">Querying
 * Discovered Configuration Items</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Filter implements SdkPojo, Serializable, ToCopyableBuilder<Filter.Builder, Filter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Filter::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Filter::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Filter::condition)).setter(setter(Builder::condition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUES_FIELD,
            CONDITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> values;

    private final String condition;

    private Filter(BuilderImpl builder) {
        this.name = builder.name;
        this.values = builder.values;
        this.condition = builder.condition;
    }

    /**
     * <p>
     * The name of the filter.
     * </p>
     * 
     * @return The name of the filter.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A string value on which to filter. For example, if you choose the <code>destinationServer.osVersion</code> filter
     * name, you could specify <code>Ubuntu</code> for the value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A string value on which to filter. For example, if you choose the
     *         <code>destinationServer.osVersion</code> filter name, you could specify <code>Ubuntu</code> for the
     *         value.
     */
    public List<String> values() {
        return values;
    }

    /**
     * <p>
     * A conditional operator. The following operators are valid: EQUALS, NOT_EQUALS, CONTAINS, NOT_CONTAINS. If you
     * specify multiple filters, the system utilizes all filters as though concatenated by <i>AND</i>. If you specify
     * multiple values for a particular filter, the system differentiates the values using <i>OR</i>. Calling either
     * <i>DescribeConfigurations</i> or <i>ListConfigurations</i> returns attributes of matching configuration items.
     * </p>
     * 
     * @return A conditional operator. The following operators are valid: EQUALS, NOT_EQUALS, CONTAINS, NOT_CONTAINS. If
     *         you specify multiple filters, the system utilizes all filters as though concatenated by <i>AND</i>. If
     *         you specify multiple values for a particular filter, the system differentiates the values using
     *         <i>OR</i>. Calling either <i>DescribeConfigurations</i> or <i>ListConfigurations</i> returns attributes
     *         of matching configuration items.
     */
    public String condition() {
        return condition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        hashCode = 31 * hashCode + Objects.hashCode(condition());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(values(), other.values())
                && Objects.equals(condition(), other.condition());
    }

    @Override
    public String toString() {
        return ToString.builder("Filter").add("Name", name()).add("Values", values()).add("Condition", condition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "values":
            return Optional.ofNullable(clazz.cast(values()));
        case "condition":
            return Optional.ofNullable(clazz.cast(condition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Filter, T> g) {
        return obj -> g.apply((Filter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Filter> {
        /**
         * <p>
         * The name of the filter.
         * </p>
         * 
         * @param name
         *        The name of the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A string value on which to filter. For example, if you choose the <code>destinationServer.osVersion</code>
         * filter name, you could specify <code>Ubuntu</code> for the value.
         * </p>
         * 
         * @param values
         *        A string value on which to filter. For example, if you choose the
         *        <code>destinationServer.osVersion</code> filter name, you could specify <code>Ubuntu</code> for the
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * A string value on which to filter. For example, if you choose the <code>destinationServer.osVersion</code>
         * filter name, you could specify <code>Ubuntu</code> for the value.
         * </p>
         * 
         * @param values
         *        A string value on which to filter. For example, if you choose the
         *        <code>destinationServer.osVersion</code> filter name, you could specify <code>Ubuntu</code> for the
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);

        /**
         * <p>
         * A conditional operator. The following operators are valid: EQUALS, NOT_EQUALS, CONTAINS, NOT_CONTAINS. If you
         * specify multiple filters, the system utilizes all filters as though concatenated by <i>AND</i>. If you
         * specify multiple values for a particular filter, the system differentiates the values using <i>OR</i>.
         * Calling either <i>DescribeConfigurations</i> or <i>ListConfigurations</i> returns attributes of matching
         * configuration items.
         * </p>
         * 
         * @param condition
         *        A conditional operator. The following operators are valid: EQUALS, NOT_EQUALS, CONTAINS, NOT_CONTAINS.
         *        If you specify multiple filters, the system utilizes all filters as though concatenated by <i>AND</i>.
         *        If you specify multiple values for a particular filter, the system differentiates the values using
         *        <i>OR</i>. Calling either <i>DescribeConfigurations</i> or <i>ListConfigurations</i> returns
         *        attributes of matching configuration items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(String condition);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private String condition;

        private BuilderImpl() {
        }

        private BuilderImpl(Filter model) {
            name(model.name);
            values(model.values);
            condition(model.condition);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getValues() {
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = FilterValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = FilterValuesCopier.copy(values);
        }

        public final String getCondition() {
            return condition;
        }

        @Override
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        @Override
        public Filter build() {
            return new Filter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
