/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServerNeighborsRequest extends ApplicationDiscoveryRequest implements
        ToCopyableBuilder<ListServerNeighborsRequest.Builder, ListServerNeighborsRequest> {
    private static final SdkField<String> CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListServerNeighborsRequest::configurationId)).setter(setter(Builder::configurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationId").build()).build();

    private static final SdkField<Boolean> PORT_INFORMATION_NEEDED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ListServerNeighborsRequest::portInformationNeeded)).setter(setter(Builder::portInformationNeeded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portInformationNeeded").build())
            .build();

    private static final SdkField<List<String>> NEIGHBOR_CONFIGURATION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListServerNeighborsRequest::neighborConfigurationIds))
            .setter(setter(Builder::neighborConfigurationIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("neighborConfigurationIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListServerNeighborsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListServerNeighborsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_ID_FIELD,
            PORT_INFORMATION_NEEDED_FIELD, NEIGHBOR_CONFIGURATION_IDS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String configurationId;

    private final Boolean portInformationNeeded;

    private final List<String> neighborConfigurationIds;

    private final Integer maxResults;

    private final String nextToken;

    private ListServerNeighborsRequest(BuilderImpl builder) {
        super(builder);
        this.configurationId = builder.configurationId;
        this.portInformationNeeded = builder.portInformationNeeded;
        this.neighborConfigurationIds = builder.neighborConfigurationIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Configuration ID of the server for which neighbors are being listed.
     * </p>
     * 
     * @return Configuration ID of the server for which neighbors are being listed.
     */
    public String configurationId() {
        return configurationId;
    }

    /**
     * <p>
     * Flag to indicate if port and protocol information is needed as part of the response.
     * </p>
     * 
     * @return Flag to indicate if port and protocol information is needed as part of the response.
     */
    public Boolean portInformationNeeded() {
        return portInformationNeeded;
    }

    /**
     * <p>
     * List of configuration IDs to test for one-hop-away.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return List of configuration IDs to test for one-hop-away.
     */
    public List<String> neighborConfigurationIds() {
        return neighborConfigurationIds;
    }

    /**
     * <p>
     * Maximum number of results to return in a single page of output.
     * </p>
     * 
     * @return Maximum number of results to return in a single page of output.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Token to retrieve the next set of results. For example, if you previously specified 100 IDs for
     * <code>ListServerNeighborsRequest$neighborConfigurationIds</code> but set
     * <code>ListServerNeighborsRequest$maxResults</code> to 10, you received a set of 10 results along with a token.
     * Use that token in this query to get the next set of 10.
     * </p>
     * 
     * @return Token to retrieve the next set of results. For example, if you previously specified 100 IDs for
     *         <code>ListServerNeighborsRequest$neighborConfigurationIds</code> but set
     *         <code>ListServerNeighborsRequest$maxResults</code> to 10, you received a set of 10 results along with a
     *         token. Use that token in this query to get the next set of 10.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationId());
        hashCode = 31 * hashCode + Objects.hashCode(portInformationNeeded());
        hashCode = 31 * hashCode + Objects.hashCode(neighborConfigurationIds());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServerNeighborsRequest)) {
            return false;
        }
        ListServerNeighborsRequest other = (ListServerNeighborsRequest) obj;
        return Objects.equals(configurationId(), other.configurationId())
                && Objects.equals(portInformationNeeded(), other.portInformationNeeded())
                && Objects.equals(neighborConfigurationIds(), other.neighborConfigurationIds())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListServerNeighborsRequest").add("ConfigurationId", configurationId())
                .add("PortInformationNeeded", portInformationNeeded())
                .add("NeighborConfigurationIds", neighborConfigurationIds()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configurationId":
            return Optional.ofNullable(clazz.cast(configurationId()));
        case "portInformationNeeded":
            return Optional.ofNullable(clazz.cast(portInformationNeeded()));
        case "neighborConfigurationIds":
            return Optional.ofNullable(clazz.cast(neighborConfigurationIds()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServerNeighborsRequest, T> g) {
        return obj -> g.apply((ListServerNeighborsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationDiscoveryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListServerNeighborsRequest> {
        /**
         * <p>
         * Configuration ID of the server for which neighbors are being listed.
         * </p>
         * 
         * @param configurationId
         *        Configuration ID of the server for which neighbors are being listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationId(String configurationId);

        /**
         * <p>
         * Flag to indicate if port and protocol information is needed as part of the response.
         * </p>
         * 
         * @param portInformationNeeded
         *        Flag to indicate if port and protocol information is needed as part of the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portInformationNeeded(Boolean portInformationNeeded);

        /**
         * <p>
         * List of configuration IDs to test for one-hop-away.
         * </p>
         * 
         * @param neighborConfigurationIds
         *        List of configuration IDs to test for one-hop-away.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neighborConfigurationIds(Collection<String> neighborConfigurationIds);

        /**
         * <p>
         * List of configuration IDs to test for one-hop-away.
         * </p>
         * 
         * @param neighborConfigurationIds
         *        List of configuration IDs to test for one-hop-away.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neighborConfigurationIds(String... neighborConfigurationIds);

        /**
         * <p>
         * Maximum number of results to return in a single page of output.
         * </p>
         * 
         * @param maxResults
         *        Maximum number of results to return in a single page of output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Token to retrieve the next set of results. For example, if you previously specified 100 IDs for
         * <code>ListServerNeighborsRequest$neighborConfigurationIds</code> but set
         * <code>ListServerNeighborsRequest$maxResults</code> to 10, you received a set of 10 results along with a
         * token. Use that token in this query to get the next set of 10.
         * </p>
         * 
         * @param nextToken
         *        Token to retrieve the next set of results. For example, if you previously specified 100 IDs for
         *        <code>ListServerNeighborsRequest$neighborConfigurationIds</code> but set
         *        <code>ListServerNeighborsRequest$maxResults</code> to 10, you received a set of 10 results along with
         *        a token. Use that token in this query to get the next set of 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationDiscoveryRequest.BuilderImpl implements Builder {
        private String configurationId;

        private Boolean portInformationNeeded;

        private List<String> neighborConfigurationIds = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServerNeighborsRequest model) {
            super(model);
            configurationId(model.configurationId);
            portInformationNeeded(model.portInformationNeeded);
            neighborConfigurationIds(model.neighborConfigurationIds);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getConfigurationId() {
            return configurationId;
        }

        @Override
        public final Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public final void setConfigurationId(String configurationId) {
            this.configurationId = configurationId;
        }

        public final Boolean getPortInformationNeeded() {
            return portInformationNeeded;
        }

        @Override
        public final Builder portInformationNeeded(Boolean portInformationNeeded) {
            this.portInformationNeeded = portInformationNeeded;
            return this;
        }

        public final void setPortInformationNeeded(Boolean portInformationNeeded) {
            this.portInformationNeeded = portInformationNeeded;
        }

        public final Collection<String> getNeighborConfigurationIds() {
            return neighborConfigurationIds;
        }

        @Override
        public final Builder neighborConfigurationIds(Collection<String> neighborConfigurationIds) {
            this.neighborConfigurationIds = ConfigurationIdListCopier.copy(neighborConfigurationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder neighborConfigurationIds(String... neighborConfigurationIds) {
            neighborConfigurationIds(Arrays.asList(neighborConfigurationIds));
            return this;
        }

        public final void setNeighborConfigurationIds(Collection<String> neighborConfigurationIds) {
            this.neighborConfigurationIds = ConfigurationIdListCopier.copy(neighborConfigurationIds);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListServerNeighborsRequest build() {
            return new ListServerNeighborsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
