/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The inventory data for installed Migration Evaluator collectors.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomerMeCollectorInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomerMeCollectorInfo.Builder, CustomerMeCollectorInfo> {
    private static final SdkField<Integer> ACTIVE_ME_COLLECTORS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("activeMeCollectors").getter(getter(CustomerMeCollectorInfo::activeMeCollectors))
            .setter(setter(Builder::activeMeCollectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeMeCollectors").build())
            .build();

    private static final SdkField<Integer> HEALTHY_ME_COLLECTORS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("healthyMeCollectors").getter(getter(CustomerMeCollectorInfo::healthyMeCollectors))
            .setter(setter(Builder::healthyMeCollectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthyMeCollectors").build())
            .build();

    private static final SdkField<Integer> DENY_LISTED_ME_COLLECTORS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("denyListedMeCollectors").getter(getter(CustomerMeCollectorInfo::denyListedMeCollectors))
            .setter(setter(Builder::denyListedMeCollectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("denyListedMeCollectors").build())
            .build();

    private static final SdkField<Integer> SHUTDOWN_ME_COLLECTORS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("shutdownMeCollectors").getter(getter(CustomerMeCollectorInfo::shutdownMeCollectors))
            .setter(setter(Builder::shutdownMeCollectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shutdownMeCollectors").build())
            .build();

    private static final SdkField<Integer> UNHEALTHY_ME_COLLECTORS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("unhealthyMeCollectors").getter(getter(CustomerMeCollectorInfo::unhealthyMeCollectors))
            .setter(setter(Builder::unhealthyMeCollectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unhealthyMeCollectors").build())
            .build();

    private static final SdkField<Integer> TOTAL_ME_COLLECTORS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalMeCollectors").getter(getter(CustomerMeCollectorInfo::totalMeCollectors))
            .setter(setter(Builder::totalMeCollectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalMeCollectors").build()).build();

    private static final SdkField<Integer> UNKNOWN_ME_COLLECTORS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("unknownMeCollectors").getter(getter(CustomerMeCollectorInfo::unknownMeCollectors))
            .setter(setter(Builder::unknownMeCollectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unknownMeCollectors").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_ME_COLLECTORS_FIELD,
            HEALTHY_ME_COLLECTORS_FIELD, DENY_LISTED_ME_COLLECTORS_FIELD, SHUTDOWN_ME_COLLECTORS_FIELD,
            UNHEALTHY_ME_COLLECTORS_FIELD, TOTAL_ME_COLLECTORS_FIELD, UNKNOWN_ME_COLLECTORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer activeMeCollectors;

    private final Integer healthyMeCollectors;

    private final Integer denyListedMeCollectors;

    private final Integer shutdownMeCollectors;

    private final Integer unhealthyMeCollectors;

    private final Integer totalMeCollectors;

    private final Integer unknownMeCollectors;

    private CustomerMeCollectorInfo(BuilderImpl builder) {
        this.activeMeCollectors = builder.activeMeCollectors;
        this.healthyMeCollectors = builder.healthyMeCollectors;
        this.denyListedMeCollectors = builder.denyListedMeCollectors;
        this.shutdownMeCollectors = builder.shutdownMeCollectors;
        this.unhealthyMeCollectors = builder.unhealthyMeCollectors;
        this.totalMeCollectors = builder.totalMeCollectors;
        this.unknownMeCollectors = builder.unknownMeCollectors;
    }

    /**
     * <p>
     * The number of active Migration Evaluator collectors.
     * </p>
     * 
     * @return The number of active Migration Evaluator collectors.
     */
    public final Integer activeMeCollectors() {
        return activeMeCollectors;
    }

    /**
     * <p>
     * The number of healthy Migration Evaluator collectors.
     * </p>
     * 
     * @return The number of healthy Migration Evaluator collectors.
     */
    public final Integer healthyMeCollectors() {
        return healthyMeCollectors;
    }

    /**
     * <p>
     * The number of deny-listed Migration Evaluator collectors.
     * </p>
     * 
     * @return The number of deny-listed Migration Evaluator collectors.
     */
    public final Integer denyListedMeCollectors() {
        return denyListedMeCollectors;
    }

    /**
     * <p>
     * The number of Migration Evaluator collectors with <code>SHUTDOWN</code> status.
     * </p>
     * 
     * @return The number of Migration Evaluator collectors with <code>SHUTDOWN</code> status.
     */
    public final Integer shutdownMeCollectors() {
        return shutdownMeCollectors;
    }

    /**
     * <p>
     * The number of unhealthy Migration Evaluator collectors.
     * </p>
     * 
     * @return The number of unhealthy Migration Evaluator collectors.
     */
    public final Integer unhealthyMeCollectors() {
        return unhealthyMeCollectors;
    }

    /**
     * <p>
     * The total number of Migration Evaluator collectors.
     * </p>
     * 
     * @return The total number of Migration Evaluator collectors.
     */
    public final Integer totalMeCollectors() {
        return totalMeCollectors;
    }

    /**
     * <p>
     * The number of unknown Migration Evaluator collectors.
     * </p>
     * 
     * @return The number of unknown Migration Evaluator collectors.
     */
    public final Integer unknownMeCollectors() {
        return unknownMeCollectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activeMeCollectors());
        hashCode = 31 * hashCode + Objects.hashCode(healthyMeCollectors());
        hashCode = 31 * hashCode + Objects.hashCode(denyListedMeCollectors());
        hashCode = 31 * hashCode + Objects.hashCode(shutdownMeCollectors());
        hashCode = 31 * hashCode + Objects.hashCode(unhealthyMeCollectors());
        hashCode = 31 * hashCode + Objects.hashCode(totalMeCollectors());
        hashCode = 31 * hashCode + Objects.hashCode(unknownMeCollectors());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerMeCollectorInfo)) {
            return false;
        }
        CustomerMeCollectorInfo other = (CustomerMeCollectorInfo) obj;
        return Objects.equals(activeMeCollectors(), other.activeMeCollectors())
                && Objects.equals(healthyMeCollectors(), other.healthyMeCollectors())
                && Objects.equals(denyListedMeCollectors(), other.denyListedMeCollectors())
                && Objects.equals(shutdownMeCollectors(), other.shutdownMeCollectors())
                && Objects.equals(unhealthyMeCollectors(), other.unhealthyMeCollectors())
                && Objects.equals(totalMeCollectors(), other.totalMeCollectors())
                && Objects.equals(unknownMeCollectors(), other.unknownMeCollectors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomerMeCollectorInfo").add("ActiveMeCollectors", activeMeCollectors())
                .add("HealthyMeCollectors", healthyMeCollectors()).add("DenyListedMeCollectors", denyListedMeCollectors())
                .add("ShutdownMeCollectors", shutdownMeCollectors()).add("UnhealthyMeCollectors", unhealthyMeCollectors())
                .add("TotalMeCollectors", totalMeCollectors()).add("UnknownMeCollectors", unknownMeCollectors()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "activeMeCollectors":
            return Optional.ofNullable(clazz.cast(activeMeCollectors()));
        case "healthyMeCollectors":
            return Optional.ofNullable(clazz.cast(healthyMeCollectors()));
        case "denyListedMeCollectors":
            return Optional.ofNullable(clazz.cast(denyListedMeCollectors()));
        case "shutdownMeCollectors":
            return Optional.ofNullable(clazz.cast(shutdownMeCollectors()));
        case "unhealthyMeCollectors":
            return Optional.ofNullable(clazz.cast(unhealthyMeCollectors()));
        case "totalMeCollectors":
            return Optional.ofNullable(clazz.cast(totalMeCollectors()));
        case "unknownMeCollectors":
            return Optional.ofNullable(clazz.cast(unknownMeCollectors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("activeMeCollectors", ACTIVE_ME_COLLECTORS_FIELD);
        map.put("healthyMeCollectors", HEALTHY_ME_COLLECTORS_FIELD);
        map.put("denyListedMeCollectors", DENY_LISTED_ME_COLLECTORS_FIELD);
        map.put("shutdownMeCollectors", SHUTDOWN_ME_COLLECTORS_FIELD);
        map.put("unhealthyMeCollectors", UNHEALTHY_ME_COLLECTORS_FIELD);
        map.put("totalMeCollectors", TOTAL_ME_COLLECTORS_FIELD);
        map.put("unknownMeCollectors", UNKNOWN_ME_COLLECTORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomerMeCollectorInfo, T> g) {
        return obj -> g.apply((CustomerMeCollectorInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomerMeCollectorInfo> {
        /**
         * <p>
         * The number of active Migration Evaluator collectors.
         * </p>
         * 
         * @param activeMeCollectors
         *        The number of active Migration Evaluator collectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeMeCollectors(Integer activeMeCollectors);

        /**
         * <p>
         * The number of healthy Migration Evaluator collectors.
         * </p>
         * 
         * @param healthyMeCollectors
         *        The number of healthy Migration Evaluator collectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthyMeCollectors(Integer healthyMeCollectors);

        /**
         * <p>
         * The number of deny-listed Migration Evaluator collectors.
         * </p>
         * 
         * @param denyListedMeCollectors
         *        The number of deny-listed Migration Evaluator collectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder denyListedMeCollectors(Integer denyListedMeCollectors);

        /**
         * <p>
         * The number of Migration Evaluator collectors with <code>SHUTDOWN</code> status.
         * </p>
         * 
         * @param shutdownMeCollectors
         *        The number of Migration Evaluator collectors with <code>SHUTDOWN</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shutdownMeCollectors(Integer shutdownMeCollectors);

        /**
         * <p>
         * The number of unhealthy Migration Evaluator collectors.
         * </p>
         * 
         * @param unhealthyMeCollectors
         *        The number of unhealthy Migration Evaluator collectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unhealthyMeCollectors(Integer unhealthyMeCollectors);

        /**
         * <p>
         * The total number of Migration Evaluator collectors.
         * </p>
         * 
         * @param totalMeCollectors
         *        The total number of Migration Evaluator collectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalMeCollectors(Integer totalMeCollectors);

        /**
         * <p>
         * The number of unknown Migration Evaluator collectors.
         * </p>
         * 
         * @param unknownMeCollectors
         *        The number of unknown Migration Evaluator collectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unknownMeCollectors(Integer unknownMeCollectors);
    }

    static final class BuilderImpl implements Builder {
        private Integer activeMeCollectors;

        private Integer healthyMeCollectors;

        private Integer denyListedMeCollectors;

        private Integer shutdownMeCollectors;

        private Integer unhealthyMeCollectors;

        private Integer totalMeCollectors;

        private Integer unknownMeCollectors;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerMeCollectorInfo model) {
            activeMeCollectors(model.activeMeCollectors);
            healthyMeCollectors(model.healthyMeCollectors);
            denyListedMeCollectors(model.denyListedMeCollectors);
            shutdownMeCollectors(model.shutdownMeCollectors);
            unhealthyMeCollectors(model.unhealthyMeCollectors);
            totalMeCollectors(model.totalMeCollectors);
            unknownMeCollectors(model.unknownMeCollectors);
        }

        public final Integer getActiveMeCollectors() {
            return activeMeCollectors;
        }

        public final void setActiveMeCollectors(Integer activeMeCollectors) {
            this.activeMeCollectors = activeMeCollectors;
        }

        @Override
        public final Builder activeMeCollectors(Integer activeMeCollectors) {
            this.activeMeCollectors = activeMeCollectors;
            return this;
        }

        public final Integer getHealthyMeCollectors() {
            return healthyMeCollectors;
        }

        public final void setHealthyMeCollectors(Integer healthyMeCollectors) {
            this.healthyMeCollectors = healthyMeCollectors;
        }

        @Override
        public final Builder healthyMeCollectors(Integer healthyMeCollectors) {
            this.healthyMeCollectors = healthyMeCollectors;
            return this;
        }

        public final Integer getDenyListedMeCollectors() {
            return denyListedMeCollectors;
        }

        public final void setDenyListedMeCollectors(Integer denyListedMeCollectors) {
            this.denyListedMeCollectors = denyListedMeCollectors;
        }

        @Override
        public final Builder denyListedMeCollectors(Integer denyListedMeCollectors) {
            this.denyListedMeCollectors = denyListedMeCollectors;
            return this;
        }

        public final Integer getShutdownMeCollectors() {
            return shutdownMeCollectors;
        }

        public final void setShutdownMeCollectors(Integer shutdownMeCollectors) {
            this.shutdownMeCollectors = shutdownMeCollectors;
        }

        @Override
        public final Builder shutdownMeCollectors(Integer shutdownMeCollectors) {
            this.shutdownMeCollectors = shutdownMeCollectors;
            return this;
        }

        public final Integer getUnhealthyMeCollectors() {
            return unhealthyMeCollectors;
        }

        public final void setUnhealthyMeCollectors(Integer unhealthyMeCollectors) {
            this.unhealthyMeCollectors = unhealthyMeCollectors;
        }

        @Override
        public final Builder unhealthyMeCollectors(Integer unhealthyMeCollectors) {
            this.unhealthyMeCollectors = unhealthyMeCollectors;
            return this;
        }

        public final Integer getTotalMeCollectors() {
            return totalMeCollectors;
        }

        public final void setTotalMeCollectors(Integer totalMeCollectors) {
            this.totalMeCollectors = totalMeCollectors;
        }

        @Override
        public final Builder totalMeCollectors(Integer totalMeCollectors) {
            this.totalMeCollectors = totalMeCollectors;
            return this;
        }

        public final Integer getUnknownMeCollectors() {
            return unknownMeCollectors;
        }

        public final void setUnknownMeCollectors(Integer unknownMeCollectors) {
            this.unknownMeCollectors = unknownMeCollectors;
        }

        @Override
        public final Builder unknownMeCollectors(Integer unknownMeCollectors) {
            this.unknownMeCollectors = unknownMeCollectors;
            return this;
        }

        @Override
        public CustomerMeCollectorInfo build() {
            return new CustomerMeCollectorInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
